/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.resetdigital;

import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Price;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.currency.CurrencyConversionService;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResetDigitalBidder
implements Bidder<BidRequest> {
    private static final String DEFAULT_CURRENCY = "USD";
    private final String endpointUrl;
    private final CurrencyConversionService currencyConversionService;
    private final JacksonMapper mapper;

    public ResetDigitalBidder(String endpointUrl, CurrencyConversionService currencyConversionService, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.currencyConversionService = Objects.requireNonNull(currencyConversionService);
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList bannerImps = new ArrayList();
        ArrayList videoImps = new ArrayList();
        ArrayList audioImps = new ArrayList();
        for (Imp imp : request.getImp()) {
            Price bidFloorPrice;
            try {
                bidFloorPrice = this.resolveBidFloor(imp, request);
            }
            catch (PreBidException e) {
                return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
            }
            ResetDigitalBidder.populateBannerImps(bannerImps, (Price)bidFloorPrice, (Imp)imp);
            ResetDigitalBidder.populateVideoImps(videoImps, (Price)bidFloorPrice, (Imp)imp);
            ResetDigitalBidder.populateAudiImps(audioImps, (Price)bidFloorPrice, (Imp)imp);
        }
        return Result.withValues((List)this.getHttpRequests(request, bannerImps, videoImps, audioImps));
    }

    private List<HttpRequest<BidRequest>> getHttpRequests(BidRequest request, List<Imp> bannerImps, List<Imp> videoImps, List<Imp> audioImps) {
        return Stream.of(bannerImps, videoImps, audioImps).filter(CollectionUtils::isNotEmpty).map(imp -> this.makeHttpRequest(request, imp)).toList();
    }

    private HttpRequest<BidRequest> makeHttpRequest(BidRequest bidRequest, List<Imp> imp) {
        BidRequest outgoingRequest = bidRequest.toBuilder().imp(imp).build();
        return BidderUtil.defaultRequest((BidRequest)outgoingRequest, (String)this.endpointUrl, (JacksonMapper)this.mapper);
    }

    private static Imp modifyImp(Imp imp, Price bidFloorPrice) {
        return imp.toBuilder().bidfloorcur(bidFloorPrice.getCurrency()).bidfloor(bidFloorPrice.getValue()).build();
    }

    private Price resolveBidFloor(Imp imp, BidRequest bidRequest) {
        Price initialBidFloorPrice = Price.of((String)imp.getBidfloorcur(), (BigDecimal)imp.getBidfloor());
        return BidderUtil.isValidPrice((Price)initialBidFloorPrice) ? this.convertBidFloor(initialBidFloorPrice, imp.getId(), bidRequest) : initialBidFloorPrice;
    }

    private Price convertBidFloor(Price bidFloorPrice, String impId, BidRequest bidRequest) {
        String bidFloorCur = bidFloorPrice.getCurrency();
        try {
            BigDecimal convertedPrice = this.currencyConversionService.convertCurrency(bidFloorPrice.getValue(), bidRequest, bidFloorCur, "USD");
            return Price.of((String)"USD", (BigDecimal)convertedPrice);
        }
        catch (PreBidException e) {
            throw new PreBidException("Unable to convert provided bid floor currency from %s to %s for imp `%s`".formatted(bidFloorCur, "USD", impId));
        }
    }

    private static void populateBannerImps(List<Imp> bannerImps, Price bidFloorPrice, Imp imp) {
        if (imp.getBanner() != null) {
            Imp bannerImp = imp.toBuilder().video(null).xNative(null).audio(null).build();
            bannerImps.add(ResetDigitalBidder.modifyImp((Imp)bannerImp, (Price)bidFloorPrice));
        }
    }

    private static void populateVideoImps(List<Imp> videoImps, Price bidFloorPrice, Imp imp) {
        if (imp.getVideo() != null) {
            Imp videoImp = imp.toBuilder().banner(null).xNative(null).audio(null).build();
            videoImps.add(ResetDigitalBidder.modifyImp((Imp)videoImp, (Price)bidFloorPrice));
        }
    }

    private static void populateAudiImps(List<Imp> audioImps, Price bidFloorPrice, Imp imp) {
        if (imp.getAudio() != null) {
            Imp audioImp = imp.toBuilder().banner(null).xNative(null).video(null).build();
            audioImps.add(ResetDigitalBidder.modifyImp((Imp)audioImp, (Price)bidFloorPrice));
        }
    }

    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues((List)ResetDigitalBidder.extractBids((BidResponse)bidResponse, (BidRequest)((BidRequest)httpCall.getRequest().getPayload())));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse, BidRequest bidRequest) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        if (bidResponse.getCur() != null && !StringUtils.equalsIgnoreCase((CharSequence)"USD", (CharSequence)bidResponse.getCur())) {
            throw new PreBidException("Bidder support only USD currency");
        }
        return ResetDigitalBidder.bidsFromResponse((BidResponse)bidResponse, (BidRequest)bidRequest);
    }

    private static List<BidderBid> bidsFromResponse(BidResponse bidResponse, BidRequest bidRequest) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of((Bid)bid, (BidType)ResetDigitalBidder.getBidType((Bid)bid, (List)bidRequest.getImp()), (String)"USD")).toList();
    }

    private static BidType getBidType(Bid bid, List<Imp> imps) {
        String impId = bid.getImpid();
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getAudio() == null) continue;
            return BidType.audio;
        }
        throw new PreBidException("Failed to find banner/video/audio impression " + impId);
    }
}

