/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.pubmatic;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Publisher;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.SeatBid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.CompositeBidderResponse;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.bidder.pubmatic.model.request.PubmaticBidderImpExt;
import org.prebid.server.bidder.pubmatic.model.request.PubmaticExtData;
import org.prebid.server.bidder.pubmatic.model.request.PubmaticExtDataAdServer;
import org.prebid.server.bidder.pubmatic.model.request.PubmaticWrapper;
import org.prebid.server.bidder.pubmatic.model.response.PubmaticBidExt;
import org.prebid.server.bidder.pubmatic.model.response.PubmaticBidResponse;
import org.prebid.server.bidder.pubmatic.model.response.PubmaticExtBidResponse;
import org.prebid.server.bidder.pubmatic.model.response.VideoCreativeInfo;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.FlexibleExtension;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.proto.openrtb.ext.request.pubmatic.ExtImpPubmatic;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.proto.openrtb.ext.response.ExtBidPrebid;
import org.prebid.server.proto.openrtb.ext.response.ExtBidPrebidVideo;
import org.prebid.server.proto.openrtb.ext.response.FledgeAuctionConfig;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class PubmaticBidder
implements Bidder<BidRequest> {
    private static final String DCTR_KEY_NAME = "key_val";
    private static final String PM_ZONE_ID_KEY_NAME = "pmZoneId";
    private static final String PM_ZONE_ID_OLD_KEY_NAME = "pmZoneID";
    private static final String IMP_EXT_AD_UNIT_KEY = "dfp_ad_unit_code";
    private static final String AD_SERVER_GAM = "gam";
    private static final String PREBID = "prebid";
    private static final String ACAT_EXT_REQUEST = "acat";
    private static final String WRAPPER_EXT_REQUEST = "wrapper";
    private static final String BIDDER_NAME = "pubmatic";
    private static final String AE = "ae";
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public PubmaticBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        PubmaticWrapper wrapper;
        List acat;
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        ArrayList<Imp> validImps = new ArrayList<Imp>();
        String publisherId = null;
        try {
            acat = this.extractAcat(request);
            wrapper = this.extractWrapper(request);
        }
        catch (IllegalArgumentException e) {
            return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
        }
        for (Imp imp : request.getImp()) {
            try {
                PubmaticBidder.validateMediaType((Imp)imp);
                PubmaticBidderImpExt impExt = this.parseImpExt(imp);
                ExtImpPubmatic extImpPubmatic = impExt.getBidder();
                publisherId = (String)ObjectUtils.defaultIfNull(publisherId, (Object)StringUtils.trimToNull((String)extImpPubmatic.getPublisherId()));
                wrapper = PubmaticBidder.merge((PubmaticWrapper)wrapper, (PubmaticWrapper)extImpPubmatic.getWrapper());
                validImps.add(this.modifyImp(imp, impExt));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        if (validImps.isEmpty()) {
            return Result.withErrors(errors);
        }
        BidRequest modifiedBidRequest = this.modifyBidRequest(request, validImps, publisherId, wrapper, acat);
        return Result.of(Collections.singletonList(this.makeHttpRequest(modifiedBidRequest)), errors);
    }

    private List<String> extractAcat(BidRequest request) {
        JsonNode bidderParams = PubmaticBidder.getExtRequestPrebidBidderparams((BidRequest)request);
        JsonNode acatNode = bidderParams != null ? bidderParams.get("acat") : null;
        return acatNode != null && acatNode.isArray() ? Arrays.stream((String[])this.mapper.mapper().convertValue((Object)acatNode, String[].class)).map(StringUtils::stripToEmpty).toList() : null;
    }

    private PubmaticWrapper extractWrapper(BidRequest request) {
        JsonNode pubmatic = PubmaticBidder.getExtRequestPrebidBidderparams((BidRequest)request);
        JsonNode wrapperNode = pubmatic != null ? pubmatic.get("wrapper") : null;
        return wrapperNode != null && wrapperNode.isObject() ? (PubmaticWrapper)this.mapper.mapper().convertValue((Object)wrapperNode, PubmaticWrapper.class) : null;
    }

    private static JsonNode getExtRequestPrebidBidderparams(BidRequest request) {
        ExtRequest extRequest = request.getExt();
        ExtRequestPrebid extRequestPrebid = extRequest != null ? extRequest.getPrebid() : null;
        ObjectNode bidderParams = extRequestPrebid != null ? extRequestPrebid.getBidderparams() : null;
        return bidderParams != null ? bidderParams.get("pubmatic") : null;
    }

    private static void validateMediaType(Imp imp) {
        if (imp.getBanner() == null && imp.getVideo() == null && imp.getXNative() == null) {
            throw new PreBidException("Invalid MediaType. PubMatic only supports Banner, Video and Native. Ignoring ImpID=%s".formatted(imp.getId()));
        }
    }

    private static PubmaticWrapper merge(PubmaticWrapper left, PubmaticWrapper right) {
        if (Objects.equals(left, right) || PubmaticBidder.isWrapperValid((PubmaticWrapper)left)) {
            return left;
        }
        if (right == null) {
            return left;
        }
        if (left == null) {
            return right;
        }
        return PubmaticWrapper.of((Integer)((Integer)ObjectUtils.defaultIfNull((Object)PubmaticBidder.stripToNull((Integer)left.getProfile()), (Object)right.getProfile())), (Integer)((Integer)ObjectUtils.defaultIfNull((Object)PubmaticBidder.stripToNull((Integer)left.getVersion()), (Object)right.getVersion())));
    }

    private static boolean isWrapperValid(PubmaticWrapper wrapper) {
        return wrapper != null && PubmaticBidder.stripToNull((Integer)wrapper.getProfile()) != null && PubmaticBidder.stripToNull((Integer)wrapper.getVersion()) != null;
    }

    private static Integer stripToNull(Integer value) {
        return value == null || value == 0 ? null : value;
    }

    private PubmaticBidderImpExt parseImpExt(Imp imp) {
        try {
            return (PubmaticBidderImpExt)this.mapper.mapper().convertValue((Object)imp.getExt(), PubmaticBidderImpExt.class);
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private Imp modifyImp(Imp imp, PubmaticBidderImpExt impExt) {
        Banner banner = imp.getBanner();
        ExtImpPubmatic impExtBidder = impExt.getBidder();
        ObjectNode modifiedExt = this.makeKeywords(impExt);
        if (impExt.getAe() != null) {
            modifiedExt.put("ae", impExt.getAe());
        }
        Imp.ImpBuilder impBuilder = imp.toBuilder().banner(banner != null ? PubmaticBidder.assignSizesIfMissing((Banner)banner) : null).ext((ObjectNode)(!modifiedExt.isEmpty() ? modifiedExt : null)).bidfloor(this.resolveBidFloor(impExtBidder.getKadfloor(), imp.getBidfloor())).audio(null);
        return PubmaticBidder.enrichWithAdSlotParameters((Imp.ImpBuilder)impBuilder, (String)impExtBidder.getAdSlot(), (Banner)banner).build();
    }

    private BigDecimal resolveBidFloor(String kadfloor, BigDecimal existingFloor) {
        BigDecimal kadFloor = PubmaticBidder.parseKadFloor((String)kadfloor);
        return ObjectUtils.allNotNull((Object[])new Object[]{kadFloor, existingFloor}) ? kadFloor.max(existingFloor) : (BigDecimal)ObjectUtils.firstNonNull((Object[])new BigDecimal[]{kadFloor, existingFloor});
    }

    private static BigDecimal parseKadFloor(String kadFloorString) {
        try {
            return new BigDecimal(StringUtils.trimToEmpty((String)kadFloorString));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Imp.ImpBuilder enrichWithAdSlotParameters(Imp.ImpBuilder impBuilder, String adSlot, Banner banner) {
        String trimmedAdSlot = StringUtils.trimToNull((String)adSlot);
        if (StringUtils.isEmpty((CharSequence)trimmedAdSlot)) {
            return impBuilder;
        }
        if (!trimmedAdSlot.contains("@")) {
            impBuilder.tagid(trimmedAdSlot);
            return impBuilder;
        }
        String[] adSlotParams = trimmedAdSlot.split("@");
        if (adSlotParams.length != 2 || StringUtils.isEmpty((CharSequence)adSlotParams[0].trim()) || StringUtils.isEmpty((CharSequence)adSlotParams[1].trim())) {
            throw new PreBidException("Invalid adSlot '%s'".formatted(trimmedAdSlot));
        }
        impBuilder.tagid(adSlotParams[0]);
        String[] adSize = adSlotParams[1].toLowerCase().split("x");
        if (adSize.length != 2) {
            throw new PreBidException("Invalid size provided in adSlot '%s'".formatted(trimmedAdSlot));
        }
        Integer width = PubmaticBidder.parseAdSizeParam((String)adSize[0], (String)"width", (String)adSlot);
        String[] heightParams = adSize[1].split(":");
        Integer height = PubmaticBidder.parseAdSizeParam((String)heightParams[0], (String)"height", (String)adSlot);
        return impBuilder.banner(PubmaticBidder.modifyWithSizeParams((Banner)banner, (Integer)width, (Integer)height));
    }

    private static Integer parseAdSizeParam(String number, String paramName, String adSlot) {
        try {
            return Integer.parseInt(number.trim());
        }
        catch (NumberFormatException e) {
            throw new PreBidException("Invalid %s provided in adSlot '%s'".formatted(paramName, adSlot));
        }
    }

    private static Banner modifyWithSizeParams(Banner banner, Integer width, Integer height) {
        return banner != null ? banner.toBuilder().w(width).h(height).build() : null;
    }

    private static Banner assignSizesIfMissing(Banner banner) {
        List format = banner.getFormat();
        if (banner.getW() != null && banner.getH() != null || CollectionUtils.isEmpty((Collection)format)) {
            return banner;
        }
        Format firstFormat = (Format)format.get(0);
        return PubmaticBidder.modifyWithSizeParams((Banner)banner, (Integer)firstFormat.getW(), (Integer)firstFormat.getH());
    }

    private ObjectNode makeKeywords(PubmaticBidderImpExt impExt) {
        ObjectNode keywordsNode = this.mapper.mapper().createObjectNode();
        PubmaticBidder.putExtBidderKeywords((ObjectNode)keywordsNode, (ExtImpPubmatic)impExt.getBidder());
        PubmaticExtData pubmaticExtData = impExt.getData();
        if (pubmaticExtData != null) {
            PubmaticBidder.putExtDataKeywords((ObjectNode)keywordsNode, (PubmaticExtData)pubmaticExtData);
        }
        return keywordsNode;
    }

    private static void putExtBidderKeywords(ObjectNode keywords, ExtImpPubmatic extBidder) {
        CollectionUtils.emptyIfNull((Collection)extBidder.getKeywords()).forEach(keyword -> {
            if (CollectionUtils.isEmpty((Collection)keyword.getValue())) {
                return;
            }
            keywords.put(keyword.getKey(), String.join((CharSequence)",", keyword.getValue()));
        });
        JsonNode pmZoneIdKeyWords = keywords.remove("pmZoneID");
        String pmZomeId = extBidder.getPmZoneId();
        if (StringUtils.isNotEmpty((CharSequence)pmZomeId)) {
            keywords.put("pmZoneId", extBidder.getPmZoneId());
        } else if (pmZoneIdKeyWords != null) {
            keywords.set("pmZoneId", pmZoneIdKeyWords);
        }
        String dctr = extBidder.getDctr();
        if (StringUtils.isNotEmpty((CharSequence)dctr)) {
            keywords.put("key_val", dctr);
        }
    }

    private static void putExtDataKeywords(ObjectNode keywords, PubmaticExtData extData) {
        String adSeverAdSlot;
        String pbaAdSlot = extData.getPbAdSlot();
        PubmaticExtDataAdServer extAdServer = extData.getAdServer();
        String adSeverName = extAdServer != null ? extAdServer.getName() : null;
        String string = adSeverAdSlot = extAdServer != null ? extAdServer.getAdSlot() : null;
        if ("gam".equals(adSeverName) && StringUtils.isNotEmpty((CharSequence)adSeverAdSlot)) {
            keywords.put("dfp_ad_unit_code", adSeverAdSlot);
        } else if (StringUtils.isNotEmpty((CharSequence)pbaAdSlot)) {
            keywords.put("dfp_ad_unit_code", pbaAdSlot);
        }
    }

    private HttpRequest<BidRequest> makeHttpRequest(BidRequest request) {
        return BidderUtil.defaultRequest((BidRequest)request, (String)this.endpointUrl, (JacksonMapper)this.mapper);
    }

    private BidRequest modifyBidRequest(BidRequest request, List<Imp> imps, String publisherId, PubmaticWrapper wrapper, List<String> acat) {
        return request.toBuilder().imp(imps).app(PubmaticBidder.modifyApp((App)request.getApp(), (String)publisherId)).site(PubmaticBidder.modifySite((Site)request.getSite(), (String)publisherId)).ext(this.modifyExtRequest(request.getExt(), wrapper, acat)).build();
    }

    private ExtRequest modifyExtRequest(ExtRequest extRequest, PubmaticWrapper wrapper, List<String> acat) {
        ObjectNode extNode = this.mapper.mapper().createObjectNode();
        if (wrapper != null) {
            extNode.set("wrapper", this.mapper.mapper().valueToTree((Object)wrapper));
        }
        if (CollectionUtils.isNotEmpty(acat)) {
            extNode.set("acat", this.mapper.mapper().valueToTree(acat));
        }
        return extNode.isEmpty() ? extRequest : (ExtRequest)this.mapper.fillExtension((FlexibleExtension)ExtRequest.empty(), (Object)extNode);
    }

    private static Site modifySite(Site site, String publisherId) {
        return publisherId != null && site != null ? site.toBuilder().publisher(PubmaticBidder.modifyPublisher((Publisher)site.getPublisher(), (String)publisherId)).build() : site;
    }

    private static App modifyApp(App app, String publisherId) {
        return publisherId != null && app != null ? app.toBuilder().publisher(PubmaticBidder.modifyPublisher((Publisher)app.getPublisher(), (String)publisherId)).build() : app;
    }

    private static Publisher modifyPublisher(Publisher publisher, String publisherId) {
        return publisher != null ? publisher.toBuilder().id(publisherId).build() : Publisher.builder().id(publisherId).build();
    }

    @Deprecated(forRemoval=true)
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        return Result.withError((BidderError)BidderError.generic((String)"Deprecated adapter method invoked"));
    }

    public CompositeBidderResponse makeBidderResponse(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            ArrayList bidderErrors = new ArrayList();
            PubmaticBidResponse bidResponse = (PubmaticBidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), PubmaticBidResponse.class);
            return CompositeBidderResponse.withBids((List)this.extractBids(bidResponse, bidderErrors), (List)PubmaticBidder.extractFledge((PubmaticBidResponse)bidResponse));
        }
        catch (PreBidException | DecodeException e) {
            return CompositeBidderResponse.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(PubmaticBidResponse bidResponse, List<BidderError> bidderErrors) {
        return bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid()) ? Collections.emptyList() : this.bidsFromResponse(bidResponse, bidderErrors);
    }

    private List<BidderBid> bidsFromResponse(PubmaticBidResponse bidResponse, List<BidderError> bidderErrors) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> this.resolveBidderBid(bid, bidResponse.getCur(), bidderErrors)).toList();
    }

    private BidderBid resolveBidderBid(Bid bid, String currency, List<BidderError> bidderErrors) {
        String resolvedAdm;
        List singleElementBidCat = CollectionUtils.emptyIfNull((Collection)bid.getCat()).stream().limit(1L).collect(Collectors.collectingAndThen(Collectors.toList(), bidCat -> !bidCat.isEmpty() ? bidCat : null));
        PubmaticBidExt pubmaticBidExt = this.extractBidExt(bid.getExt());
        Integer duration = PubmaticBidder.getDuration((PubmaticBidExt)pubmaticBidExt);
        BidType bidType = PubmaticBidder.getBidType((PubmaticBidExt)pubmaticBidExt);
        String bidAdm = bid.getAdm();
        String string = resolvedAdm = bidAdm != null && bidType == BidType.xNative ? this.resolveNativeAdm(bidAdm, bidderErrors) : bidAdm;
        Bid updatedBid = singleElementBidCat != null || duration != null || resolvedAdm != null ? bid.toBuilder().adm(resolvedAdm != null ? resolvedAdm : bidAdm).cat(singleElementBidCat).ext(duration != null ? this.updateBidExtWithExtPrebid(duration, bid.getExt()) : bid.getExt()).build() : bid;
        return BidderBid.builder().bid(updatedBid).type(bidType).bidCurrency(currency).dealPriority(PubmaticBidder.getDealPriority((PubmaticBidExt)pubmaticBidExt)).build();
    }

    private PubmaticBidExt extractBidExt(ObjectNode bidExt) {
        try {
            return bidExt != null ? (PubmaticBidExt)this.mapper.mapper().treeToValue((TreeNode)bidExt, PubmaticBidExt.class) : null;
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    private static BidType getBidType(PubmaticBidExt bidExt) {
        Integer bidType = bidExt != null ? (Integer)ObjectUtils.defaultIfNull((Object)bidExt.getBidType(), (Object)0) : Integer.valueOf(0);
        return switch (bidType) {
            case 1 -> BidType.video;
            case 2 -> BidType.xNative;
            default -> BidType.banner;
        };
    }

    private String resolveNativeAdm(String adm, List<BidderError> bidderErrors) {
        JsonNode admNode;
        try {
            admNode = this.mapper.mapper().readTree(adm);
        }
        catch (JsonProcessingException e) {
            bidderErrors.add(BidderError.badServerResponse((String)"Unable to parse native adm: %s".formatted(adm)));
            return null;
        }
        JsonNode nativeNode = admNode.get("native");
        if (!nativeNode.isMissingNode()) {
            return nativeNode.toString();
        }
        return null;
    }

    private static Integer getDuration(PubmaticBidExt bidExt) {
        VideoCreativeInfo creativeInfo = bidExt != null ? bidExt.getVideo() : null;
        return creativeInfo != null ? creativeInfo.getDuration() : null;
    }

    private ObjectNode updateBidExtWithExtPrebid(Integer duration, ObjectNode extBid) {
        ExtBidPrebid extBidPrebid = ExtBidPrebid.builder().video(ExtBidPrebidVideo.of((Integer)duration, null)).build();
        return (ObjectNode)extBid.set("prebid", this.mapper.mapper().valueToTree((Object)extBidPrebid));
    }

    private static Integer getDealPriority(PubmaticBidExt bidExt) {
        return Optional.ofNullable(bidExt).map(PubmaticBidExt::getPrebidDealPriority).orElse(null);
    }

    private static List<FledgeAuctionConfig> extractFledge(PubmaticBidResponse bidResponse) {
        return Optional.ofNullable(bidResponse).map(PubmaticBidResponse::getExt).map(PubmaticExtBidResponse::getFledgeAuctionConfigs).orElse(Collections.emptyMap()).entrySet().stream().map(e -> FledgeAuctionConfig.builder().impId((String)e.getKey()).config((ObjectNode)e.getValue()).build()).toList();
    }
}

