/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.operaads;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Native;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.operaads.ExtImpOperaads;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class OperaadsBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpOperaads>> OPERAADS_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final String PUBLISHER_ID_MACRO = "{{PublisherId}}";
    private static final String ACCOUNT_ID_MACRO = "{{AccountId}}";
    private static final String BIDDER_CURRENCY = "USD";
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public OperaadsBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        try {
            OperaadsBidder.validateDevice((Device)request.getDevice());
        }
        catch (PreBidException e) {
            return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
        }
        ArrayList<HttpRequest> requests = new ArrayList<HttpRequest>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        for (Imp imp : request.getImp()) {
            Imp modifiedImp;
            ExtImpOperaads extImpOperaads;
            try {
                extImpOperaads = this.parseImpExt(imp);
                modifiedImp = this.modifyImp(imp, extImpOperaads.getPlacementId());
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
                continue;
            }
            if (modifiedImp == null) continue;
            requests.add(this.createRequest(request, modifiedImp, extImpOperaads));
        }
        return Result.of(requests, errors);
    }

    private static void validateDevice(Device device) {
        if (device == null || StringUtils.isEmpty((CharSequence)device.getOs())) {
            throw new PreBidException("Request is missing device OS information");
        }
    }

    private ExtImpOperaads parseImpExt(Imp imp) {
        try {
            return (ExtImpOperaads)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), OPERAADS_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private Imp modifyImp(Imp imp, String placementId) {
        Imp.ImpBuilder impBuilder = imp.toBuilder().tagid(placementId);
        String impId = imp.getId();
        if (imp.getBanner() != null) {
            impBuilder.id(OperaadsBidder.buildImpId((String)impId, (BidType)BidType.banner)).banner(OperaadsBidder.modifyBanner((Banner)imp.getBanner())).video(null).xNative(null);
        } else if (imp.getVideo() != null) {
            impBuilder.id(OperaadsBidder.buildImpId((String)impId, (BidType)BidType.video)).xNative(null);
        } else if (imp.getXNative() != null) {
            impBuilder.id(OperaadsBidder.buildImpId((String)impId, (BidType)BidType.xNative)).xNative(this.modifyNative(imp.getXNative()));
        } else {
            return null;
        }
        return impBuilder.build();
    }

    private static String buildImpId(String originalId, BidType type) {
        return "%s:opa:%s".formatted(originalId, type.getName());
    }

    private static Banner modifyBanner(Banner banner) {
        Integer w = banner.getW();
        Integer h = banner.getH();
        List formats = banner.getFormat();
        if (w == null || w == 0 || h == null || h == 0) {
            if (CollectionUtils.isNotEmpty((Collection)formats)) {
                Format firstFormat = (Format)formats.get(0);
                return banner.toBuilder().w(firstFormat.getW()).h(firstFormat.getH()).build();
            }
            throw new PreBidException("Size information missing for banner");
        }
        return banner;
    }

    private Native modifyNative(Native xNative) {
        MissingNode nativeNode;
        JsonNode requestNode;
        try {
            requestNode = this.mapper.mapper().readTree(xNative.getRequest());
        }
        catch (JsonProcessingException e) {
            throw new PreBidException(e.getMessage());
        }
        Object object = nativeNode = requestNode != null ? requestNode.path("native") : MissingNode.getInstance();
        if (nativeNode.isMissingNode()) {
            JsonNode modifiedRequestNode = this.mapper.mapper().createObjectNode().set("native", requestNode);
            return xNative.toBuilder().request(this.mapper.encodeToString((Object)modifiedRequestNode)).build();
        }
        return xNative;
    }

    private HttpRequest<BidRequest> createRequest(BidRequest bidRequest, Imp imp, ExtImpOperaads extImpOperaads) {
        BidRequest outgoingRequest = bidRequest.toBuilder().imp(Collections.singletonList(imp)).build();
        return BidderUtil.defaultRequest((BidRequest)outgoingRequest, (String)this.resolveUrl(extImpOperaads), (JacksonMapper)this.mapper);
    }

    private String resolveUrl(ExtImpOperaads extImpOperaads) {
        return this.endpointUrl.replace("{{PublisherId}}", HttpUtil.encodeUrl((String)extImpOperaads.getPublisherId())).replace("{{AccountId}}", HttpUtil.encodeUrl((String)extImpOperaads.getEndpointId()));
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues((List)this.extractBids(bidResponse));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(OperaadsBidder::isValidBid).map(arg_0 -> this.createBidderBid(arg_0)).toList();
    }

    private static boolean isValidBid(Bid bid) {
        return BidderUtil.isValidPrice((BigDecimal)((BigDecimal)ObjectUtil.getIfNotNull((Object)bid, Bid::getPrice)));
    }

    private BidderBid createBidderBid(Bid bid) {
        String[] idParts = StringUtils.split((String)bid.getImpid(), (String)":");
        if (idParts == null || idParts.length < 2) {
            throw new PreBidException("BidType not provided.");
        }
        return BidderBid.of((Bid)OperaadsBidder.modifyBid((Bid)bid, (String)OperaadsBidder.constructImpId((String[])idParts)), (BidType)this.parseBidType(idParts[idParts.length - 1]), (String)"USD");
    }

    private static Bid modifyBid(Bid bid, String impId) {
        return bid.toBuilder().impid(impId).build();
    }

    private static String constructImpId(String[] idParts) {
        return Arrays.stream(idParts).limit(idParts.length - 2).collect(Collectors.joining(":"));
    }

    private BidType parseBidType(String bidType) {
        try {
            return (BidType)this.mapper.mapper().convertValue((Object)bidType, BidType.class);
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }
}

