/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.nextmillennium;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtStoredRequest;
import org.prebid.server.proto.openrtb.ext.request.nextmillennium.ExtImpNextMillennium;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class NextMillenniumBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpNextMillennium>> NEXTMILLENNIUM_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public NextMillenniumBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    private BidRequest updateBidRequest(BidRequest bidRequest, ExtImpNextMillennium ext) {
        ExtRequest extRequest = ExtRequest.of((ExtRequestPrebid)ExtRequestPrebid.builder().storedrequest(ExtStoredRequest.of((String)NextMillenniumBidder.resolveStoredRequestId((BidRequest)bidRequest, (ExtImpNextMillennium)ext))).build());
        ObjectNode impExt = (ObjectNode)this.mapper.mapper().valueToTree((Object)extRequest);
        List<Imp> imps = bidRequest.getImp().stream().map(imp -> imp.toBuilder().ext(impExt).build()).toList();
        return bidRequest.toBuilder().imp(imps).ext(extRequest).build();
    }

    private static String resolveStoredRequestId(BidRequest bidRequest, ExtImpNextMillennium extImpNextMillennium) {
        String groupId = extImpNextMillennium.getGroupId();
        if (StringUtils.isEmpty((CharSequence)groupId)) {
            return extImpNextMillennium.getPlacementId();
        }
        String size = NextMillenniumBidder.formattedSizeFromBanner((Banner)((Imp)bidRequest.getImp().get(0)).getBanner());
        String domain = (String)ObjectUtils.firstNonNull((Object[])new String[]{(String)ObjectUtil.getIfNotNull((Object)bidRequest.getSite(), Site::getDomain), (String)ObjectUtil.getIfNotNull((Object)bidRequest.getApp(), App::getDomain), ""});
        return "g%s;%s;%s".formatted(groupId, size, domain);
    }

    public final Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        ArrayList errors = new ArrayList();
        List impExts = this.getImpExts(bidRequest, errors);
        return errors.isEmpty() ? Result.withValues((List)this.makeRequests(bidRequest, impExts)) : Result.withErrors(errors);
    }

    private List<ExtImpNextMillennium> getImpExts(BidRequest bidRequest, List<BidderError> errors) {
        return bidRequest.getImp().stream().map(imp -> this.convertExt(imp, errors)).filter(Objects::nonNull).toList();
    }

    private ExtImpNextMillennium convertExt(Imp imp, List<BidderError> errors) {
        try {
            return (ExtImpNextMillennium)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), NEXTMILLENNIUM_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            errors.add(BidderError.badInput((String)e.getMessage()));
            return null;
        }
    }

    private List<HttpRequest<BidRequest>> makeRequests(BidRequest bidRequest, List<ExtImpNextMillennium> extImps) {
        return extImps.stream().map(extImp -> this.makeHttpRequest(this.updateBidRequest(bidRequest, extImp))).toList();
    }

    private static String formattedSizeFromBanner(Banner banner) {
        if (banner == null) {
            return "";
        }
        List formats = banner.getFormat();
        Format firstFormat = CollectionUtils.isNotEmpty((Collection)formats) ? (Format)formats.get(0) : null;
        return (String)ObjectUtils.firstNonNull((Object[])new String[]{NextMillenniumBidder.formatSize((Integer)((Integer)ObjectUtil.getIfNotNull((Object)firstFormat, Format::getW)), (Integer)((Integer)ObjectUtil.getIfNotNull((Object)firstFormat, Format::getH))), NextMillenniumBidder.formatSize((Integer)banner.getW(), (Integer)banner.getH()), ""});
    }

    private static String formatSize(Integer w, Integer h) {
        return w != null && h != null ? "%dx%d".formatted(w, h) : null;
    }

    private HttpRequest<BidRequest> makeHttpRequest(BidRequest bidRequest) {
        return HttpRequest.builder().method(HttpMethod.POST).uri(this.endpointUrl).headers(NextMillenniumBidder.headers()).payload((Object)bidRequest).body(this.mapper.encodeToBytes((Object)bidRequest)).build();
    }

    private static MultiMap headers() {
        return HttpUtil.headers().add(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.5");
    }

    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            if (CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
                return Result.empty();
            }
            return Result.withValues((List)NextMillenniumBidder.bidsFromResponse((BidResponse)bidResponse));
        }
        catch (DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> bidsFromResponse(BidResponse bidResponse) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of((Bid)bid, (BidType)BidType.banner, (String)bidResponse.getCur())).toList();
    }
}

