/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.model;

import java.beans.ConstructorProperties;
import org.prebid.server.bidder.model.BidderCallType;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.HttpResponse;

public final class BidderCall<T> {
    private final HttpRequest<T> request;
    private final HttpResponse response;
    private final BidderCallType callType;
    private final BidderError error;

    public static <T> BidderCall<T> storedHttp(HttpRequest<T> request, HttpResponse response) {
        return new BidderCall(request, response, BidderCallType.STORED_BID_RESPONSE, null);
    }

    public static <T> BidderCall<T> succeededHttp(HttpRequest<T> request, HttpResponse response, BidderError error) {
        return new BidderCall(request, response, BidderCallType.HTTP, error);
    }

    public static <T> BidderCall<T> failedHttp(HttpRequest<T> request, BidderError error) {
        return new BidderCall(request, null, BidderCallType.HTTP, error);
    }

    public static <T> BidderCall<T> unfinishedHttp(HttpRequest<T> request) {
        return new BidderCall(request, null, BidderCallType.HTTP, null);
    }

    public HttpRequest<T> getRequest() {
        return this.request;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public BidderCallType getCallType() {
        return this.callType;
    }

    public BidderError getError() {
        return this.error;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BidderCall)) {
            return false;
        }
        BidderCall other = (BidderCall)o;
        HttpRequest this$request = this.getRequest();
        HttpRequest other$request = other.getRequest();
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        HttpResponse this$response = this.getResponse();
        HttpResponse other$response = other.getResponse();
        if (this$response == null ? other$response != null : !this$response.equals(other$response)) {
            return false;
        }
        BidderCallType this$callType = this.getCallType();
        BidderCallType other$callType = other.getCallType();
        if (this$callType == null ? other$callType != null : !this$callType.equals(other$callType)) {
            return false;
        }
        BidderError this$error = this.getError();
        BidderError other$error = other.getError();
        return !(this$error == null ? other$error != null : !this$error.equals(other$error));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpRequest $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        HttpResponse $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : $response.hashCode());
        BidderCallType $callType = this.getCallType();
        result = result * 59 + ($callType == null ? 43 : $callType.hashCode());
        BidderError $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        return result;
    }

    public String toString() {
        return "BidderCall(request=" + this.getRequest() + ", response=" + this.getResponse() + ", callType=" + this.getCallType() + ", error=" + this.getError() + ")";
    }

    @ConstructorProperties(value={"request", "response", "callType", "error"})
    private BidderCall(HttpRequest<T> request, HttpResponse response, BidderCallType callType, BidderError error) {
        this.request = request;
        this.response = response;
        this.callType = callType;
        this.error = error;
    }
}

