/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.mgidx;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.appush.proto.AppushImpExtBidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.mgidx.ExtImpMgidx;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class MgidxBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpMgidx>> MGIDX_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final String PUBLISHER_PROPERTY = "publisher";
    private static final String NETWORK_PROPERTY = "network";
    private static final String BIDDER_PROPERTY = "bidder";
    private static final String PREBID_EXT = "prebid";
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public MgidxBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<HttpRequest> httpRequests = new ArrayList<HttpRequest>();
        for (Imp imp : request.getImp()) {
            ExtImpMgidx extImpMgidx;
            try {
                extImpMgidx = this.parseExtImp(imp);
            }
            catch (PreBidException e) {
                return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
            }
            Imp modifiedImp = this.modifyImp(imp, extImpMgidx);
            httpRequests.add(this.makeHttpRequest(request, modifiedImp));
        }
        return Result.withValues(httpRequests);
    }

    private Imp modifyImp(Imp imp, ExtImpMgidx extImpMgidx) {
        AppushImpExtBidder impExtAppushWithType = this.resolveImpExt(extImpMgidx);
        ObjectNode modifiedImpExtBidder = this.mapper.mapper().createObjectNode();
        modifiedImpExtBidder.set(BIDDER_PROPERTY, this.mapper.mapper().valueToTree((Object)impExtAppushWithType));
        return imp.toBuilder().ext(modifiedImpExtBidder).build();
    }

    private AppushImpExtBidder resolveImpExt(ExtImpMgidx extImpMgidx) {
        AppushImpExtBidder.AppushImpExtBidderBuilder builder = AppushImpExtBidder.builder();
        if (StringUtils.isNotEmpty((CharSequence)extImpMgidx.getPlacementId())) {
            builder.type(PUBLISHER_PROPERTY).placementId(extImpMgidx.getPlacementId());
        } else if (StringUtils.isNotEmpty((CharSequence)extImpMgidx.getEndpointId())) {
            builder.type(NETWORK_PROPERTY).endpointId(extImpMgidx.getEndpointId());
        }
        return builder.build();
    }

    private ExtImpMgidx parseExtImp(Imp imp) {
        try {
            return (ExtImpMgidx)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), MGIDX_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private HttpRequest<BidRequest> makeHttpRequest(BidRequest request, Imp imp) {
        BidRequest outgoingRequest = request.toBuilder().imp(List.of(imp)).build();
        return BidderUtil.defaultRequest((BidRequest)outgoingRequest, (String)this.endpointUrl, (JacksonMapper)this.mapper);
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            List bids = this.extractBids((BidRequest)httpCall.getRequest().getPayload(), bidResponse);
            return Result.withValues((List)bids);
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> BidderBid.of((Bid)bid, (BidType)this.getBidType(bid), (String)bidResponse.getCur())).toList();
    }

    private BidType getBidType(Bid bid) {
        BidType bidType;
        JsonNode typeNode = Optional.ofNullable(bid.getExt()).map(extNode -> extNode.get(PREBID_EXT)).map(extPrebidNode -> extPrebidNode.get("type")).orElse(null);
        try {
            bidType = (BidType)this.mapper.mapper().convertValue((Object)typeNode, BidType.class);
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("Failed to parse bid.ext.prebid.type for bid.id: '%s'".formatted(bid.getId()));
        }
        if (bidType == null) {
            throw new PreBidException("bid.ext.prebid.type is not present for bid.id: '%s'".formatted(bid.getId()));
        }
        return bidType;
    }
}

