/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.lockerdome;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.lockerdome.ExtImpLockerdome;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class LockerdomeBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpLockerdome>> LOCKERDOME_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public LockerdomeBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        List requestImps = bidRequest.getImp();
        ArrayList<Imp> validImps = new ArrayList<Imp>();
        for (Imp imp : requestImps) {
            try {
                validImps.add(this.validateImp(imp));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        if (validImps.isEmpty()) {
            errors.add(BidderError.badInput((String)"No valid or supported impressions in the bid request."));
            return Result.withErrors(errors);
        }
        MultiMap headers = HttpUtil.headers().add(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.5");
        BidRequest outgoingRequest = validImps.size() != requestImps.size() ? bidRequest.toBuilder().imp(validImps).build() : bidRequest;
        return Result.of(Collections.singletonList(HttpRequest.builder().method(HttpMethod.POST).uri(this.endpointUrl).headers(headers).body(this.mapper.encodeToBytes((Object)outgoingRequest)).payload((Object)outgoingRequest).build()), errors);
    }

    private Imp validateImp(Imp imp) {
        ExtImpLockerdome extImpLockerdome;
        if (imp.getBanner() == null) {
            throw new PreBidException("LockerDome does not currently support non-banner types.");
        }
        try {
            extImpLockerdome = (ExtImpLockerdome)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), LOCKERDOME_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
        if (StringUtils.isBlank((CharSequence)extImpLockerdome.getAdUnitId())) {
            throw new PreBidException("ext.bidder.adUnitId is empty.");
        }
        return imp;
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues((List)LockerdomeBidder.extractBids((BidResponse)bidResponse));
        }
        catch (DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse) {
        return bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid()) ? Collections.emptyList() : LockerdomeBidder.bidsFromResponse((BidResponse)bidResponse);
    }

    private static List<BidderBid> bidsFromResponse(BidResponse bidResponse) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of((Bid)bid, (BidType)BidType.banner, (String)bidResponse.getCur())).toList();
    }
}

