/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.krushmedia;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.krushmedia.ExtImpKrushmedia;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class KrushmediaBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpKrushmedia>> KRUSHMEDIA_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final String URI_ACCOUNT_ID_MACRO = "{{AccountID}}";
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public KrushmediaBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        String url;
        ArrayList errors = new ArrayList();
        try {
            ExtImpKrushmedia extImpKrushmedia = this.parseImpExt((Imp)request.getImp().get(0));
            url = this.resolveEndpoint(extImpKrushmedia.getAccountId());
        }
        catch (PreBidException e) {
            return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
        }
        BidRequest outgoingRequest = request.toBuilder().imp(KrushmediaBidder.removeFirstImpExt((List)request.getImp())).build();
        return Result.of(Collections.singletonList(HttpRequest.builder().method(HttpMethod.POST).uri(url).headers(this.resolveHeaders(request.getDevice())).payload((Object)outgoingRequest).body(this.mapper.encodeToBytes((Object)outgoingRequest)).build()), errors);
    }

    private ExtImpKrushmedia parseImpExt(Imp imp) {
        try {
            return (ExtImpKrushmedia)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), KRUSHMEDIA_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("Error while unmarshalling bidder extension");
        }
    }

    private String resolveEndpoint(String accountId) {
        return this.endpointUrl.replace("{{AccountID}}", StringUtils.stripToEmpty((String)accountId));
    }

    private static List<Imp> removeFirstImpExt(List<Imp> imps) {
        return IntStream.range(0, imps.size()).mapToObj(impIndex -> impIndex == 0 ? ((Imp)imps.get(impIndex)).toBuilder().ext(null).build() : (Imp)imps.get(impIndex)).toList();
    }

    private MultiMap resolveHeaders(Device device) {
        MultiMap headers = HttpUtil.headers().add(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.5");
        if (device != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.USER_AGENT_HEADER, (CharSequence)device.getUa());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.ACCEPT_LANGUAGE_HEADER, (CharSequence)device.getLanguage());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)device.getIp());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)device.getIpv6());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.DNT_HEADER, (CharSequence)Objects.toString(device.getDnt(), null));
        }
        return headers;
    }

    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of((Object)this.extractBids((BidRequest)httpCall.getRequest().getPayload(), bidResponse), Collections.emptyList());
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return this.bidsFromResponse(bidRequest, bidResponse);
    }

    private List<BidderBid> bidsFromResponse(BidRequest bidRequest, BidResponse bidResponse) {
        SeatBid firstSeatBid = (SeatBid)bidResponse.getSeatbid().get(0);
        return firstSeatBid.getBid().stream().filter(Objects::nonNull).map(bid -> BidderBid.of((Bid)bid, (BidType)this.getBidType(bid.getImpid(), bidRequest.getImp()), (String)bidResponse.getCur())).toList();
    }

    protected BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getXNative() == null) continue;
            return BidType.xNative;
        }
        return BidType.banner;
    }
}

