/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.kargo;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.kargo.model.KargoExtBid;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class KargoBidder
implements Bidder<BidRequest> {
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public KargoBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        return Result.withValue((Object)BidderUtil.defaultRequest((BidRequest)bidRequest, (String)this.endpointUrl, (JacksonMapper)this.mapper));
    }

    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues((List)this.extractBids(bidResponse));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return this.bidsFromResponse(bidResponse);
    }

    private List<BidderBid> bidsFromResponse(BidResponse bidResponse) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of((Bid)bid, (BidType)this.resolvedBidType(bid), (String)bidResponse.getCur())).collect(Collectors.toList());
    }

    private BidType resolvedBidType(Bid bid) {
        String mediaType;
        KargoExtBid kargoExtBid = bid.getExt() != null ? this.getMappedBidExt(bid.getExt()) : null;
        String string = mediaType = kargoExtBid != null ? kargoExtBid.getMediaType() : null;
        if (mediaType == null) {
            return BidType.banner;
        }
        return switch (mediaType) {
            case "video" -> BidType.video;
            case "native" -> BidType.xNative;
            default -> BidType.banner;
        };
    }

    private KargoExtBid getMappedBidExt(ObjectNode objectNode) {
        try {
            return (KargoExtBid)this.mapper.mapper().convertValue((Object)objectNode, KargoExtBid.class);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

