/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.gumgum;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Publisher;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.Video;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.gumgum.ExtImpGumgum;
import org.prebid.server.proto.openrtb.ext.request.gumgum.ExtImpGumgumBanner;
import org.prebid.server.proto.openrtb.ext.request.gumgum.ExtImpGumgumVideo;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class GumgumBidder
implements Bidder<BidRequest> {
    private static final String REQUEST_EXT_PRODUCT = "product";
    private static final TypeReference<ExtPrebid<?, ExtImpGumgum>> GUMGUM_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public GumgumBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        BidRequest outgoingRequest;
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        try {
            outgoingRequest = this.createBidRequest(bidRequest, errors);
        }
        catch (PreBidException e) {
            errors.add(BidderError.badInput((String)e.getMessage()));
            return Result.withErrors(errors);
        }
        return Result.of(Collections.singletonList(BidderUtil.defaultRequest((BidRequest)outgoingRequest, (String)this.endpointUrl, (JacksonMapper)this.mapper)), errors);
    }

    private BidRequest createBidRequest(BidRequest bidRequest, List<BidderError> errors) {
        ArrayList<Imp> modifiedImps = new ArrayList<Imp>();
        String zone = null;
        BigInteger pubId = null;
        for (Imp imp : bidRequest.getImp()) {
            try {
                BigInteger extPubId;
                ExtImpGumgum extImp = this.parseImpExt(imp);
                modifiedImps.add(this.modifyImp(imp, extImp));
                String extZone = extImp.getZone();
                if (StringUtils.isNotEmpty((CharSequence)extZone)) {
                    zone = extZone;
                }
                if ((extPubId = extImp.getPubId()) == null || extPubId.equals(BigInteger.ZERO)) continue;
                pubId = extPubId;
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        if (modifiedImps.isEmpty()) {
            throw new PreBidException("No valid impressions");
        }
        return bidRequest.toBuilder().imp(modifiedImps).site(GumgumBidder.modifySite((Site)bidRequest.getSite(), zone, pubId)).build();
    }

    private ExtImpGumgum parseImpExt(Imp imp) {
        try {
            return (ExtImpGumgum)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), GUMGUM_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private Imp modifyImp(Imp imp, ExtImpGumgum extImp) {
        Video video;
        Banner resolvedBanner;
        Banner banner;
        Imp.ImpBuilder impBuilder = imp.toBuilder();
        String product = extImp.getProduct();
        if (StringUtils.isNotEmpty((CharSequence)product)) {
            ObjectNode productExt = this.mapper.mapper().createObjectNode().put("product", product);
            impBuilder.ext(productExt);
        }
        if ((banner = imp.getBanner()) != null && (resolvedBanner = this.resolveBanner(banner, extImp)) != null) {
            impBuilder.banner(resolvedBanner);
        }
        if ((video = imp.getVideo()) != null) {
            this.validateVideoParams(video);
            String irisId = extImp.getIrisId();
            if (StringUtils.isNotEmpty((CharSequence)irisId)) {
                Video resolvedVideo = this.resolveVideo(video, irisId);
                impBuilder.video(resolvedVideo);
            }
        }
        return impBuilder.build();
    }

    private Banner resolveBanner(Banner banner, ExtImpGumgum extImpGumgum) {
        List format = banner.getFormat();
        if (banner.getH() == null && banner.getW() == null && CollectionUtils.isNotEmpty((Collection)format)) {
            Format firstFormat = (Format)format.get(0);
            Long slot = extImpGumgum.getSlot();
            ObjectNode bannerExt = slot != null && slot != 0L ? (ObjectNode)this.mapper.mapper().valueToTree((Object)GumgumBidder.resolveBannerExt((List)format, (Long)slot)) : banner.getExt();
            return banner.toBuilder().w(firstFormat.getW()).h(firstFormat.getH()).ext(bannerExt).build();
        }
        return null;
    }

    private static ExtImpGumgumBanner resolveBannerExt(List<Format> formats, Long slot) {
        return formats.stream().filter(format -> ObjectUtils.allNotNull((Object[])new Object[]{format.getW(), format.getH()})).max(Comparator.comparing(format -> Math.max(format.getW(), format.getH())).thenComparing(Format::getW).thenComparing(Format::getH)).map(format -> ExtImpGumgumBanner.of((Long)slot, (Integer)format.getW(), (Integer)format.getH())).orElseGet(() -> ExtImpGumgumBanner.of((Long)slot, (Integer)0, (Integer)0));
    }

    private void validateVideoParams(Video video) {
        if (GumgumBidder.anyOfNull((Integer[])new Integer[]{video.getW(), video.getH(), video.getMinduration(), video.getMaxduration(), video.getPlacement(), video.getLinearity()})) {
            throw new PreBidException("Invalid or missing video field(s)");
        }
    }

    private Video resolveVideo(Video video, String irisId) {
        ObjectNode videoExt = (ObjectNode)this.mapper.mapper().valueToTree((Object)ExtImpGumgumVideo.of((String)irisId));
        return video.toBuilder().ext(videoExt).build();
    }

    private static boolean anyOfNull(Integer ... numbers) {
        return Arrays.stream(ArrayUtils.nullToEmpty((Integer[])numbers)).anyMatch(GumgumBidder::isNullOrZero);
    }

    private static boolean isNullOrZero(Integer number) {
        return number == null || number == 0;
    }

    private static Site modifySite(Site requestSite, String zone, BigInteger pubId) {
        if (requestSite == null) {
            return null;
        }
        Site.SiteBuilder modifiedSite = requestSite.toBuilder();
        if (StringUtils.isNotEmpty((CharSequence)zone)) {
            modifiedSite.id(zone);
        }
        if (pubId != null && !pubId.equals(BigInteger.ZERO)) {
            Publisher publisher = requestSite.getPublisher();
            Publisher.PublisherBuilder publisherBuilder = publisher != null ? publisher.toBuilder() : Publisher.builder();
            modifiedSite.publisher(publisherBuilder.id(pubId.toString()).build());
        }
        return modifiedSite.build();
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of((Object)GumgumBidder.extractBids((BidResponse)bidResponse, (BidRequest)bidRequest), Collections.emptyList());
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse, BidRequest bidRequest) {
        return bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid()) ? Collections.emptyList() : GumgumBidder.bidsFromResponse((BidResponse)bidResponse, (BidRequest)bidRequest);
    }

    private static List<BidderBid> bidsFromResponse(BidResponse bidResponse, BidRequest bidRequest) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> GumgumBidder.toBidderBid((Bid)bid, (BidRequest)bidRequest, (String)bidResponse.getCur())).toList();
    }

    private static BidderBid toBidderBid(Bid bid, BidRequest bidRequest, String currency) {
        BidType bidType = GumgumBidder.getBidType((String)bid.getImpid(), (List)bidRequest.getImp());
        Bid updatedBid = bidType == BidType.video ? bid.toBuilder().adm(GumgumBidder.resolveAdm((String)bid.getAdm(), (BigDecimal)bid.getPrice())).build() : bid;
        return BidderBid.of((Bid)updatedBid, (BidType)bidType, (String)currency);
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            return imp.getBanner() != null ? BidType.banner : BidType.video;
        }
        return BidType.video;
    }

    private static String resolveAdm(String bidAdm, BigDecimal price) {
        return StringUtils.isNotBlank((CharSequence)bidAdm) ? bidAdm.replace("${AUCTION_PRICE}", String.valueOf(price)) : bidAdm;
    }
}

