/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.grid;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BaseJsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.User;
import com.iab.openrtb.response.Bid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.grid.GridKeywordsProcessor;
import org.prebid.server.bidder.grid.model.request.ExtImp;
import org.prebid.server.bidder.grid.model.request.ExtImpGridData;
import org.prebid.server.bidder.grid.model.request.ExtImpGridDataAdServer;
import org.prebid.server.bidder.grid.model.request.Keywords;
import org.prebid.server.bidder.grid.model.response.GridBidResponse;
import org.prebid.server.bidder.grid.model.response.GridSeatBid;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.FlexibleExtension;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.proto.openrtb.ext.request.grid.ExtImpGrid;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.proto.openrtb.ext.response.ExtBidPrebid;
import org.prebid.server.proto.openrtb.ext.response.ExtBidPrebidMeta;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class GridBidder
implements Bidder<BidRequest> {
    private final String endpointUrl;
    private final JacksonMapper mapper;
    private final GridKeywordsProcessor gridKeywordsProcessor;

    public GridBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
        this.gridKeywordsProcessor = new GridKeywordsProcessor(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        List imps = request.getImp();
        List modifiedImps = this.modifyImps(imps, errors);
        if (modifiedImps.isEmpty()) {
            errors.add(BidderError.badInput((String)"No valid impressions for grid"));
            return Result.withErrors(errors);
        }
        Keywords firstImpKeywords = this.getKeywordsFromImpExt((JsonNode)((Imp)imps.get(0)).getExt());
        BidRequest modifiedRequest = this.modifyRequest(request, firstImpKeywords, modifiedImps);
        return Result.of(Collections.singletonList(BidderUtil.defaultRequest((BidRequest)modifiedRequest, (String)this.endpointUrl, (JacksonMapper)this.mapper)), errors);
    }

    private List<Imp> modifyImps(List<Imp> imps, List<BidderError> errors) {
        ArrayList<Imp> modifiedImps = new ArrayList<Imp>();
        for (Imp imp : imps) {
            try {
                modifiedImps.add(this.modifyImp(imp, this.parseAndValidateImpExt(imp)));
            }
            catch (IllegalArgumentException | PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        return modifiedImps;
    }

    private ExtImp parseAndValidateImpExt(Imp imp) {
        ExtImp extImp = (ExtImp)this.mapper.mapper().convertValue((Object)imp.getExt(), ExtImp.class);
        GridBidder.validateImpExt((ExtImp)extImp, (String)imp.getId());
        return extImp;
    }

    private static void validateImpExt(ExtImp extImp, String impId) {
        Integer uid;
        ExtImpGrid extImpGrid = extImp != null ? extImp.getBidder() : null;
        Integer n = uid = extImpGrid != null ? extImpGrid.getUid() : null;
        if (BidderUtil.isNullOrZero((Integer)uid)) {
            throw new PreBidException("Empty uid in imp with id: " + impId);
        }
    }

    private Imp modifyImp(Imp imp, ExtImp extImp) {
        String adSlot;
        ExtImpGridData extImpData = extImp.getData();
        ExtImpGridDataAdServer adServer = extImpData != null ? extImpData.getAdServer() : null;
        String string = adSlot = adServer != null ? adServer.getAdSlot() : null;
        if (StringUtils.isNotEmpty((CharSequence)adSlot)) {
            ExtImp modifiedExtImp = extImp.toBuilder().gpid(adSlot).build();
            return imp.toBuilder().ext((ObjectNode)this.mapper.mapper().valueToTree((Object)modifiedExtImp)).build();
        }
        return imp;
    }

    private Keywords getKeywordsFromImpExt(JsonNode extImp) {
        try {
            return this.getExtImpGridBidder(extImp).getKeywords();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private ExtImpGrid getExtImpGridBidder(JsonNode extImp) {
        return ((ExtImp)this.mapper.mapper().convertValue((Object)extImp, ExtImp.class)).getBidder();
    }

    private BidRequest modifyRequest(BidRequest bidRequest, Keywords firstImpKeywords, List<Imp> imp) {
        User user = bidRequest.getUser();
        String userKeywords = user != null ? user.getKeywords() : null;
        Site site = bidRequest.getSite();
        String siteKeywords = site != null ? site.getKeywords() : null;
        ExtRequest extRequest = bidRequest.getExt();
        Keywords resolvedKeywords = this.buildBidRequestExtKeywords(userKeywords, siteKeywords, firstImpKeywords, this.getKeywordsFromRequestExt(extRequest));
        return bidRequest.toBuilder().imp(imp).ext(this.modifyExtRequest(extRequest, resolvedKeywords)).build();
    }

    private Keywords getKeywordsFromRequestExt(ExtRequest extRequest) {
        try {
            JsonNode requestKeywordsNode = extRequest != null ? extRequest.getProperty("keywords") : null;
            return requestKeywordsNode != null ? (Keywords)this.mapper.mapper().treeToValue((TreeNode)requestKeywordsNode, Keywords.class) : null;
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    private Keywords buildBidRequestExtKeywords(String userKeywords, String siteKeywords, Keywords firstImpExtKeywords, Keywords requestExtKeywords) {
        String resolvedUserKeywords = (String)ObjectUtils.defaultIfNull((Object)userKeywords, (Object)"");
        String resolvedSiteKeywords = (String)ObjectUtils.defaultIfNull((Object)siteKeywords, (Object)"");
        return this.gridKeywordsProcessor.merge(new Keywords[]{this.gridKeywordsProcessor.resolveKeywordsFromOpenRtb(resolvedUserKeywords, resolvedSiteKeywords), this.gridKeywordsProcessor.resolveKeywords(firstImpExtKeywords), this.gridKeywordsProcessor.resolveKeywords(requestExtKeywords)});
    }

    private ExtRequest modifyExtRequest(ExtRequest extRequest, Keywords keywords) {
        ExtRequestPrebid extRequestPrebid = (ExtRequestPrebid)ObjectUtil.getIfNotNull((Object)extRequest, ExtRequest::getPrebid);
        Map extRequestProperties = (Map)ObjectUtil.getIfNotNullOrDefault((Object)extRequest, FlexibleExtension::getProperties, Collections::emptyMap);
        Map modifiedExtRequestProperties = this.gridKeywordsProcessor.modifyWithKeywords(extRequestProperties, keywords);
        if (modifiedExtRequestProperties.isEmpty()) {
            return null;
        }
        ExtRequest modifiedBidRequestExt = ExtRequest.of((ExtRequestPrebid)extRequestPrebid);
        modifiedBidRequestExt.addProperties(modifiedExtRequestProperties);
        return modifiedBidRequestExt;
    }

    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            GridBidResponse bidResponse = (GridBidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), GridBidResponse.class);
            return Result.withValues((List)this.extractBids((BidRequest)httpCall.getRequest().getPayload(), bidResponse));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidRequest bidRequest, GridBidResponse gridBidResponse) {
        if (gridBidResponse == null || CollectionUtils.isEmpty((Collection)gridBidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return this.bidsFromResponse(bidRequest, gridBidResponse);
    }

    private List<BidderBid> bidsFromResponse(BidRequest bidRequest, GridBidResponse gridBidResponse) {
        return gridBidResponse.getSeatbid().stream().filter(Objects::nonNull).map(GridSeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> this.makeBidderBid(bid, bidRequest.getImp(), gridBidResponse.getCur())).toList();
    }

    private BidderBid makeBidderBid(ObjectNode bidNode, List<Imp> imps, String currency) {
        try {
            Bid bid = (Bid)this.mapper.mapper().treeToValue((TreeNode)bidNode, Bid.class);
            Bid modifiedBid = bid.toBuilder().ext(this.modifyBidExt(bidNode)).build();
            return BidderBid.of((Bid)modifiedBid, (BidType)GridBidder.resolveBidType((ObjectNode)bidNode, (String)bid.getImpid(), imps), (String)currency);
        }
        catch (JsonProcessingException | IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private ObjectNode modifyBidExt(ObjectNode gridBid) {
        String demandSource = ((BaseJsonNode)ObjectUtils.defaultIfNull((Object)gridBid, (Object)MissingNode.getInstance())).at("/ext/bidder/grid/demandSource").textValue();
        if (StringUtils.isEmpty((CharSequence)demandSource)) {
            return null;
        }
        ExtBidPrebid extBidPrebid = ExtBidPrebid.builder().meta(ExtBidPrebidMeta.builder().demandSource(demandSource).build()).build();
        return (ObjectNode)this.mapper.mapper().valueToTree((Object)ExtPrebid.of((Object)extBidPrebid, null));
    }

    private static BidType resolveBidType(ObjectNode bidNode, String impId, List<Imp> imps) {
        BidType contentType = BidType.fromString((String)bidNode.at("/content_type").asText());
        if (contentType != null) {
            return contentType;
        }
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            throw new PreBidException("Unknown impression type for ID: " + impId);
        }
        throw new PreBidException("Failed to find impression for ID: " + impId);
    }
}

