/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.gamma;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.gamma.model.GammaBid;
import org.prebid.server.bidder.gamma.model.GammaBidResponse;
import org.prebid.server.bidder.gamma.model.GammaSeatBid;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.gamma.ExtImpGamma;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class GammaBidder
implements Bidder<Void> {
    private static final TypeReference<ExtPrebid<?, ExtImpGamma>> GAMMA_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public GammaBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<Void>>> makeHttpRequests(BidRequest bidRequest) {
        List outgoingRequests;
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        try {
            outgoingRequests = this.createHttpRequests(bidRequest, errors);
        }
        catch (PreBidException e) {
            errors.add(BidderError.badInput((String)e.getMessage()));
            return Result.withErrors(errors);
        }
        return Result.of((Object)outgoingRequests, errors);
    }

    private List<HttpRequest<Void>> createHttpRequests(BidRequest bidRequest, List<BidderError> errors) {
        ArrayList<Imp> modifiedImps = new ArrayList<Imp>();
        for (Imp imp : bidRequest.getImp()) {
            try {
                modifiedImps.add(GammaBidder.modifyImp((Imp)imp));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        if (modifiedImps.isEmpty()) {
            throw new PreBidException("No valid impressions");
        }
        ArrayList<HttpRequest<Void>> httpRequests = new ArrayList<HttpRequest<Void>>();
        for (Imp modifiedImp : modifiedImps) {
            try {
                httpRequests.add((HttpRequest<Void>)this.makeHttpRequest(bidRequest, modifiedImp));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        return httpRequests;
    }

    private static Imp modifyImp(Imp imp) {
        if (imp.getVideo() == null && imp.getBanner() == null) {
            throw new PreBidException("Gamma only supports banner and video media types. Ignoring imp id= " + imp.getId());
        }
        Banner banner = imp.getBanner();
        if (banner != null) {
            List format = banner.getFormat();
            if (banner.getW() == null && banner.getH() == null && CollectionUtils.isNotEmpty((Collection)format)) {
                Format firstFormat = (Format)format.get(0);
                Banner modifiedBanner = banner.toBuilder().w(firstFormat.getW()).h(firstFormat.getH()).build();
                return imp.toBuilder().banner(modifiedBanner).build();
            }
        }
        return imp;
    }

    private HttpRequest<Void> makeHttpRequest(BidRequest bidRequest, Imp imp) {
        ExtImpGamma extImpGamma = this.parseImpExt(imp);
        if (StringUtils.isBlank((CharSequence)extImpGamma.getId())) {
            throw new PreBidException("PartnerID is empty");
        }
        if (StringUtils.isBlank((CharSequence)extImpGamma.getZid())) {
            throw new PreBidException("ZoneID is empty");
        }
        if (StringUtils.isBlank((CharSequence)extImpGamma.getWid())) {
            throw new PreBidException("WebID is empty");
        }
        Device device = bidRequest.getDevice();
        return HttpRequest.builder().method(HttpMethod.GET).uri(this.makeUri(extImpGamma, imp.getId(), device, bidRequest.getApp())).headers(this.makeHeaders(device)).build();
    }

    private ExtImpGamma parseImpExt(Imp imp) {
        try {
            return (ExtImpGamma)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), GAMMA_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("ext.bidder.publisher not provided");
        }
    }

    private String makeUri(ExtImpGamma extImpGamma, String impId, Device device, App app) {
        StringBuilder uri = new StringBuilder(this.endpointUrl).append("?id=").append(extImpGamma.getId()).append("&zid=").append(extImpGamma.getZid()).append("&wid=").append(extImpGamma.getWid()).append("&bidid=").append((String)ObjectUtils.defaultIfNull((Object)impId, (Object)"")).append("&hb=pbmobile");
        if (device != null) {
            if (StringUtils.isNotBlank((CharSequence)device.getIp())) {
                uri.append("&device_ip=").append(device.getIp());
            }
            if (StringUtils.isNotBlank((CharSequence)device.getModel())) {
                uri.append("&device_model=").append(device.getModel());
            }
            if (StringUtils.isNotBlank((CharSequence)device.getOs())) {
                uri.append("&device_os=").append(device.getOs());
            }
            if (StringUtils.isNotBlank((CharSequence)device.getUa())) {
                uri.append("&device_ua=").append(HttpUtil.encodeUrl((String)device.getUa()));
            }
            if (StringUtils.isNotBlank((CharSequence)device.getIfa())) {
                uri.append("&device_ifa=").append(device.getIfa());
            }
        }
        if (app != null) {
            if (StringUtils.isNotBlank((CharSequence)app.getId())) {
                uri.append("&app_id=").append(app.getId());
            }
            if (StringUtils.isNotBlank((CharSequence)app.getBundle())) {
                uri.append("&app_bundle=").append(app.getBundle());
            }
            if (StringUtils.isNotBlank((CharSequence)app.getName())) {
                uri.append("&app_name=").append(app.getName());
            }
        }
        return uri.toString();
    }

    private MultiMap makeHeaders(Device device) {
        MultiMap headers = MultiMap.caseInsensitiveMultiMap().set(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.5").set(HttpUtil.ACCEPT_HEADER, (CharSequence)"*/*").set(HttpUtil.CACHE_CONTROL_HEADER, (CharSequence)"no-cache").set(HttpUtil.CONNECTION_HEADER, (CharSequence)"keep-alive");
        if (device != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.USER_AGENT_HEADER, (CharSequence)device.getUa());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)device.getIp());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.ACCEPT_LANGUAGE_HEADER, (CharSequence)device.getLanguage());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.DNT_HEADER, (CharSequence)Objects.toString(device.getDnt(), null));
        }
        return headers;
    }

    public Result<List<BidderBid>> makeBids(BidderCall<Void> httpCall, BidRequest bidRequest) {
        String body = httpCall.getResponse().getBody();
        if (body == null) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)"bad server response: body is empty"));
        }
        try {
            GammaBidResponse bidResponse = (GammaBidResponse)this.mapper.decodeValue(body, GammaBidResponse.class);
            ArrayList errors = new ArrayList();
            return Result.of((Object)GammaBidder.extractBidsAndFillErrors((GammaBidResponse)bidResponse, (BidRequest)bidRequest, errors), errors);
        }
        catch (DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)("bad server response: " + e.getMessage())));
        }
    }

    private static List<BidderBid> extractBidsAndFillErrors(GammaBidResponse bidResponse, BidRequest bidRequest, List<BidderError> errors) {
        return bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid()) ? Collections.emptyList() : GammaBidder.bidsFromResponse((GammaBidResponse)bidResponse, (BidRequest)bidRequest, errors);
    }

    private static List<BidderBid> bidsFromResponse(GammaBidResponse bidResponse, BidRequest bidRequest, List<BidderError> errors) {
        ArrayList<BidderBid> bidderBids = new ArrayList<BidderBid>();
        for (GammaSeatBid gammaSeatBid : bidResponse.getSeatbid()) {
            for (GammaBid gammaBid : gammaSeatBid.getBid()) {
                try {
                    BidType mediaType = GammaBidder.getMediaTypes((String)bidResponse.getId(), (List)bidRequest.getImp());
                    Bid updatedBid = GammaBidder.convertBid((GammaBid)gammaBid, (BidType)mediaType);
                    bidderBids.add(BidderBid.of((Bid)updatedBid, (BidType)mediaType, (String)bidResponse.getCur()));
                }
                catch (PreBidException e) {
                    errors.add(BidderError.badServerResponse((String)e.getMessage()));
                }
            }
        }
        return bidderBids;
    }

    private static BidType getMediaTypes(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId) || imp.getVideo() == null) continue;
            return BidType.video;
        }
        return BidType.banner;
    }

    private static Bid convertBid(GammaBid gammaBid, BidType bidType) {
        boolean isVideo = BidType.video.equals((Object)bidType);
        if (!isVideo && StringUtils.isBlank((CharSequence)gammaBid.getBid().getAdm())) {
            throw new PreBidException("Missing Ad Markup. Run with request.debug = 1 for more info");
        }
        Bid bid = gammaBid.getBid();
        if (isVideo) {
            String vastXml = gammaBid.getVastXml();
            if (StringUtils.isNotBlank((CharSequence)vastXml)) {
                Bid.BidBuilder bidBuilder = gammaBid.getBid().toBuilder().adm(vastXml);
                String vastUrl = gammaBid.getVastUrl();
                if (StringUtils.isNotBlank((CharSequence)vastUrl)) {
                    bidBuilder.nurl(vastUrl);
                }
                bid = bidBuilder.build();
            } else {
                throw new PreBidException("Missing Ad Markup. Run with request.debug = 1 for more info");
            }
        }
        return bid;
    }
}

