/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.eplanning;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.User;
import com.iab.openrtb.response.Bid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.eplanning.model.CleanStepName;
import org.prebid.server.bidder.eplanning.model.HbResponse;
import org.prebid.server.bidder.eplanning.model.HbResponseAd;
import org.prebid.server.bidder.eplanning.model.HbResponseSpace;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.eplanning.ExtImpEplanning;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class EplanningBidder
implements Bidder<Void> {
    private static final String NULL_SIZE = "1x1";
    private static final String DEFAULT_PAGE_URL = "FILE";
    private static final String SEC = "ROS";
    private static final String DFP_CLIENT_ID = "1";
    private static final String REQUEST_TARGET_INVENTORY = "1";
    private static final List<CleanStepName> CLEAN_STEP_NAMES = Arrays.asList(CleanStepName.of((String)"_|\\.|-|\\/", (String)""), CleanStepName.of((String)"\\)\\(|\\(|\\)|:", (String)"_"), CleanStepName.of((String)"^_+|_+$", (String)""));
    private static final Set<Integer> MOBILE_DEVICE_TYPES = new HashSet<Integer>(Arrays.asList(1, 4, 5));
    private static final String SIZE_FORMAT = "%sx%s";
    private static final List<String> PRIORITY_SIZES_FOR_MOBILE = new ArrayList<String>(Arrays.asList("300x250", "320x50", "300x50", "1x1"));
    private static final List<String> PRIORITY_SIZES_FOR_DESKTOP = new ArrayList<String>(Arrays.asList("300x250", "728x90", "300x600", "160x600", "970x250", "970x90", "1x1"));
    private static final TypeReference<ExtPrebid<?, ExtImpEplanning>> EPLANNING_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public EplanningBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<Void>>> makeHttpRequests(BidRequest request) {
        String uri;
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        ArrayList<CallSite> requestsStrings = new ArrayList<CallSite>();
        boolean isMobile = this.isMobile(request);
        String clientId = null;
        for (Imp imp : request.getImp()) {
            try {
                EplanningBidder.validateImp((Imp)imp);
                ExtImpEplanning extImpEplanning = this.validateAndModifyImpExt(imp);
                if (clientId == null) {
                    clientId = extImpEplanning.getClientId();
                }
                String sizeString = EplanningBidder.resolveSizeString((Imp)imp, (boolean)isMobile);
                String name = EplanningBidder.getCleanAdUnitCode((ExtImpEplanning)extImpEplanning, () -> sizeString);
                requestsStrings.add((CallSite)((Object)(name + ":" + sizeString)));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        if (CollectionUtils.isEmpty(requestsStrings)) {
            return Result.withErrors(errors);
        }
        try {
            uri = this.resolveRequestUri(request, requestsStrings, clientId);
        }
        catch (PreBidException e) {
            return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
        }
        return Result.of(Collections.singletonList(HttpRequest.builder().method(HttpMethod.GET).uri(uri).headers(EplanningBidder.createHeaders((Device)request.getDevice())).body(null).payload(null).build()), errors);
    }

    private static void validateImp(Imp imp) {
        if (imp.getBanner() == null) {
            throw new PreBidException("EPlanning only supports banner Imps. Ignoring Imp ID=" + imp.getId());
        }
    }

    private boolean isMobile(BidRequest bidRequest) {
        Device device = bidRequest.getDevice();
        Integer deviceType = device != null ? device.getDevicetype() : null;
        return MOBILE_DEVICE_TYPES.contains(deviceType);
    }

    private ExtImpEplanning validateAndModifyImpExt(Imp imp) throws PreBidException {
        ExtImpEplanning extImpEplanning;
        try {
            extImpEplanning = (ExtImpEplanning)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), EPLANNING_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("Ignoring imp id=%s, error while decoding extImpBidder, err: %s".formatted(imp.getId(), e.getMessage()));
        }
        if (extImpEplanning == null) {
            throw new PreBidException("Ignoring imp id=%s, error while decoding extImpBidder, err: bidder property is not present".formatted(imp.getId()));
        }
        if (StringUtils.isBlank((CharSequence)extImpEplanning.getClientId())) {
            throw new PreBidException("Ignoring imp id=%s, no ClientID present".formatted(imp.getId()));
        }
        return extImpEplanning;
    }

    private static String resolveSizeString(Imp imp, boolean isMobile) {
        Banner banner = imp.getBanner();
        Integer bannerWidth = banner.getW();
        Integer bannerHeight = banner.getH();
        if (bannerWidth != null && bannerHeight != null) {
            return "%sx%s".formatted(bannerWidth, bannerHeight);
        }
        List bannerFormats = banner.getFormat();
        Set formattedBannerSizes = CollectionUtils.emptyIfNull((Collection)bannerFormats).stream().filter(format -> format.getH() != null && format.getW() != null).map(format -> "%sx%s".formatted(format.getW(), format.getH())).collect(Collectors.toSet());
        List prioritySizes = isMobile ? PRIORITY_SIZES_FOR_MOBILE : PRIORITY_SIZES_FOR_DESKTOP;
        return prioritySizes.stream().filter(formattedBannerSizes::contains).findFirst().orElse("1x1");
    }

    private static String cleanName(String name) {
        String result = name;
        for (CleanStepName cleanStepName : CLEAN_STEP_NAMES) {
            result = result.replaceAll(cleanStepName.getExpression(), cleanStepName.getReplacementString());
        }
        return result;
    }

    private static MultiMap createHeaders(Device device) {
        MultiMap headers = HttpUtil.headers();
        if (device != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.USER_AGENT_HEADER, (CharSequence)device.getUa());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.ACCEPT_LANGUAGE_HEADER, (CharSequence)device.getLanguage());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)device.getIp());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.DNT_HEADER, (CharSequence)Objects.toString(device.getDnt(), null));
        }
        return headers;
    }

    private String resolveRequestUri(BidRequest request, List<String> requestsStrings, String clientId) {
        Device device;
        String ip;
        String buyeruid;
        URIBuilder uriBuilder;
        App app;
        Site site = request.getSite();
        String pageUrl = "FILE";
        if (site != null && StringUtils.isNotBlank((CharSequence)site.getPage())) {
            pageUrl = site.getPage();
        }
        String pageDomain = "FILE";
        if (site != null) {
            if (StringUtils.isNotBlank((CharSequence)site.getDomain())) {
                pageDomain = site.getDomain();
            } else if (StringUtils.isNotBlank((CharSequence)site.getPage())) {
                pageDomain = EplanningBidder.parseUrl((String)site.getPage()).getHost();
            }
        }
        String requestTarget = (app = request.getApp()) != null && StringUtils.isNotBlank((CharSequence)app.getBundle()) ? app.getBundle() : pageDomain;
        String uri = "%s/%s/%s/%s/%s".formatted(this.endpointUrl, clientId, "1", requestTarget, "ROS");
        try {
            uriBuilder = new URIBuilder(uri);
        }
        catch (URISyntaxException e) {
            throw new PreBidException("Invalid url: %s, error: %s".formatted(uri, e.getMessage()));
        }
        uriBuilder.addParameter("r", "pbs").addParameter("ncb", "1");
        if (app == null) {
            uriBuilder.addParameter("ur", pageUrl);
        }
        uriBuilder.addParameter("e", String.join((CharSequence)"+", requestsStrings));
        User user = request.getUser();
        String string = buyeruid = user != null ? user.getBuyeruid() : null;
        if (StringUtils.isNotBlank((CharSequence)buyeruid)) {
            uriBuilder.addParameter("uid", buyeruid);
        }
        String string2 = ip = (device = request.getDevice()) != null ? device.getIp() : null;
        if (StringUtils.isNotBlank((CharSequence)ip)) {
            uriBuilder.addParameter("ip", ip);
        }
        if (app != null) {
            if (StringUtils.isNotBlank((CharSequence)app.getName())) {
                uriBuilder.addParameter("appn", app.getName());
            }
            if (StringUtils.isNotBlank((CharSequence)app.getId())) {
                uriBuilder.addParameter("appid", app.getId());
            }
            if (request.getDevice() != null && StringUtils.isNotBlank((CharSequence)request.getDevice().getIfa())) {
                uriBuilder.addParameter("ifa", request.getDevice().getIfa());
            }
            uriBuilder.addParameter("app", "1");
        }
        return uriBuilder.toString();
    }

    private static URL parseUrl(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new PreBidException("Invalid url: " + url, (Throwable)e);
        }
    }

    public Result<List<BidderBid>> makeBids(BidderCall<Void> httpCall, BidRequest bidRequest) {
        try {
            HbResponse hbResponse = (HbResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), HbResponse.class);
            return this.extractBids(hbResponse, bidRequest);
        }
        catch (DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private Result<List<BidderBid>> extractBids(HbResponse hbResponse, BidRequest bidRequest) {
        HashMap<String, String> nameSpaceToImpId = new HashMap<String, String>();
        boolean isMobile = this.isMobile(bidRequest);
        for (Imp imp : bidRequest.getImp()) {
            ExtImpEplanning impExt;
            try {
                impExt = this.validateAndModifyImpExt(imp);
            }
            catch (PreBidException e) {
                continue;
            }
            String name = EplanningBidder.getCleanAdUnitCode((ExtImpEplanning)impExt, () -> EplanningBidder.resolveSizeString((Imp)imp, (boolean)isMobile));
            nameSpaceToImpId.put(name, imp.getId());
        }
        return Result.of(EplanningBidder.getSpacesStream((HbResponse)hbResponse).flatMap(hbResponseSpace -> EplanningBidder.getAdsStream((HbResponseSpace)hbResponseSpace).map(hbResponseAd -> EplanningBidder.mapToBidderBid((HbResponseSpace)hbResponseSpace, (HbResponseAd)hbResponseAd, (Map)nameSpaceToImpId))).toList(), Collections.emptyList());
    }

    private static String getCleanAdUnitCode(ExtImpEplanning extImpEplanning, Supplier<String> fallbackNameSupplier) {
        String adunitCode = extImpEplanning.getAdunitCode();
        return EplanningBidder.cleanName((String)(StringUtils.isBlank((CharSequence)adunitCode) ? fallbackNameSupplier.get() : adunitCode));
    }

    private static Stream<HbResponseSpace> getSpacesStream(HbResponse hbResponse) {
        return hbResponse.getSpaces() != null ? hbResponse.getSpaces().stream() : Stream.empty();
    }

    private static Stream<HbResponseAd> getAdsStream(HbResponseSpace hbResponseSpace) {
        return hbResponseSpace.getAds() != null ? hbResponseSpace.getAds().stream() : Stream.empty();
    }

    private static BidderBid mapToBidderBid(HbResponseSpace hbResponseSpace, HbResponseAd hbResponseAd, Map<String, String> nameSpaceToImpId) {
        return BidderBid.of((Bid)Bid.builder().id(hbResponseAd.getImpressionId()).adid(hbResponseAd.getAdId()).impid(nameSpaceToImpId.get(hbResponseSpace.getName())).price(new BigDecimal(hbResponseAd.getPrice())).adm(hbResponseAd.getAdM()).crid(hbResponseAd.getCrId()).w(hbResponseAd.getWidth()).h(hbResponseAd.getHeight()).build(), (BidType)BidType.banner, null);
    }
}

