/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.criteo;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.proto.openrtb.ext.response.ExtBidPrebid;
import org.prebid.server.proto.openrtb.ext.response.ExtBidPrebidMeta;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class CriteoBidder
implements Bidder<BidRequest> {
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public CriteoBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        return Result.withValue((Object)BidderUtil.defaultRequest((BidRequest)bidRequest, (String)this.endpointUrl, (JacksonMapper)this.mapper));
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues((List)this.extractBidsFromResponse(bidResponse));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private List<BidderBid> extractBidsFromResponse(BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> BidderBid.of((Bid)this.modifyBidExt(bid), (BidType)CriteoBidder.getBidType((Bid)bid), (String)bidResponse.getCur())).toList();
    }

    private Bid modifyBidExt(Bid bid) {
        return Optional.ofNullable(bid.getExt()).map(ext -> ext.get("prebid")).map(prebid -> prebid.get("networkName")).filter(JsonNode::isTextual).map(JsonNode::textValue).map(networkName -> bid.toBuilder().ext(this.makeExt(networkName)).build()).orElse(bid);
    }

    private static BidType getBidType(Bid bid) {
        return Optional.ofNullable(bid.getExt()).map(ext -> ext.get("prebid")).map(extPrebid -> extPrebid.get("type")).filter(JsonNode::isTextual).map(JsonNode::textValue).map(BidType::fromString).orElseThrow(() -> new PreBidException("Missing ext.prebid.type in bid for impression : %s.".formatted(bid.getImpid())));
    }

    private ObjectNode makeExt(String networkName) {
        return (ObjectNode)this.mapper.mapper().valueToTree((Object)ExtBidPrebid.builder().meta(ExtBidPrebidMeta.builder().networkName(networkName).build()).build());
    }
}

