/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.connectad;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.connectad.ExtImpConnectAd;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConnectadBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpConnectAd>> CONNECTAD_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final String HTTPS_PREFIX = "https";
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public ConnectadBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        int secure = ConnectadBidder.secureFrom((Site)request.getSite());
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        ArrayList<Imp> processedImps = new ArrayList<Imp>();
        for (Imp imp : request.getImp()) {
            try {
                ExtImpConnectAd impExt = this.parseImpExt(imp);
                Imp updatedImp = this.updateImp(imp, Integer.valueOf(secure), impExt.getSiteId(), impExt.getBidfloor());
                processedImps.add(updatedImp);
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        if (CollectionUtils.isNotEmpty(errors)) {
            errors.add(BidderError.badInput((String)"Error in preprocess of Imp"));
            return Result.withErrors(errors);
        }
        BidRequest outgoingRequest = request.toBuilder().imp(processedImps).build();
        return Result.of(Collections.singletonList(HttpRequest.builder().method(HttpMethod.POST).uri(this.endpointUrl).headers(ConnectadBidder.resolveHeaders((Device)request.getDevice())).payload((Object)outgoingRequest).body(this.mapper.encodeToBytes((Object)outgoingRequest)).build()), errors);
    }

    private static int secureFrom(Site site) {
        String page = site != null ? site.getPage() : null;
        return page != null && page.startsWith("https") ? 1 : 0;
    }

    private ExtImpConnectAd parseImpExt(Imp imp) {
        ExtImpConnectAd extImpConnectAd;
        try {
            extImpConnectAd = (ExtImpConnectAd)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), CONNECTAD_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("Impression id=%s, has invalid Ext".formatted(imp.getId()));
        }
        Integer siteId = extImpConnectAd.getSiteId();
        if (siteId == null || siteId.equals(0)) {
            throw new PreBidException("Impression id=%s, has no siteId present".formatted(imp.getId()));
        }
        return extImpConnectAd;
    }

    private Imp updateImp(Imp imp, Integer secure, Integer siteId, BigDecimal bidFloor) {
        Banner banner;
        Imp.ImpBuilder updatedImp = imp.toBuilder().tagid(siteId.toString()).secure(secure);
        if (BidderUtil.isValidPrice((BigDecimal)bidFloor)) {
            updatedImp.bidfloor(bidFloor).bidfloorcur("USD");
        }
        if ((banner = imp.getBanner()) == null) {
            throw new PreBidException("We need a Banner Object in the request");
        }
        if (banner.getW() == null && banner.getH() == null) {
            if (CollectionUtils.isEmpty((Collection)banner.getFormat())) {
                throw new PreBidException("At least one size is required");
            }
            Format format = (Format)banner.getFormat().get(0);
            ArrayList slicedFormatList = new ArrayList(banner.getFormat());
            slicedFormatList.remove(0);
            updatedImp.banner(banner.toBuilder().format(slicedFormatList).w(format.getW()).h(format.getH()).build());
        }
        return updatedImp.build();
    }

    private static MultiMap resolveHeaders(Device device) {
        MultiMap headers = HttpUtil.headers();
        if (device != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.USER_AGENT_HEADER, (CharSequence)device.getUa());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.ACCEPT_LANGUAGE_HEADER, (CharSequence)device.getLanguage());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)device.getIp());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)device.getIpv6());
            Integer dnt = device.getDnt();
            headers.add(HttpUtil.DNT_HEADER, (CharSequence)(dnt != null ? dnt.toString() : "0"));
        }
        return headers;
    }

    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of((Object)this.extractBids(bidResponse), Collections.emptyList());
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return this.bidsFromResponse(bidResponse);
    }

    private List<BidderBid> bidsFromResponse(BidResponse bidResponse) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of((Bid)bid, (BidType)BidType.banner, (String)bidResponse.getCur())).toList();
    }
}

