/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.axis;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.axis.ExtImpAxis;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class AxisBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpAxis>> ADMAN_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final String ACCOUNT_ID_MACRO = "{{AccountID}}";
    private static final String SOURCE_ID_MACRO = "{{SourceId}}";
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public AxisBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<HttpRequest> httpRequests = new ArrayList<HttpRequest>();
        for (Imp imp : request.getImp()) {
            ExtImpAxis extImpAxis;
            try {
                extImpAxis = this.parseImpExt(imp);
            }
            catch (PreBidException e) {
                continue;
            }
            httpRequests.add(this.makeRequest(request, imp, extImpAxis));
        }
        return Result.withValues(httpRequests);
    }

    private ExtImpAxis parseImpExt(Imp imp) {
        try {
            return (ExtImpAxis)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), ADMAN_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private HttpRequest<BidRequest> makeRequest(BidRequest bidRequest, Imp imp, ExtImpAxis extImpAxis) {
        BidRequest modifyBidRequest = bidRequest.toBuilder().imp(Collections.singletonList(imp)).build();
        return BidderUtil.defaultRequest((BidRequest)modifyBidRequest, (String)this.resolveUrl(extImpAxis), (JacksonMapper)this.mapper);
    }

    private String resolveUrl(ExtImpAxis extImpAxis) {
        return this.endpointUrl.replace(ACCOUNT_ID_MACRO, HttpUtil.encodeUrl((String)extImpAxis.getIntegration())).replace(SOURCE_ID_MACRO, HttpUtil.encodeUrl((String)extImpAxis.getToken()));
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        ArrayList errors = new ArrayList();
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            List imps = ((BidRequest)httpCall.getRequest().getPayload()).getImp();
            List bidderBids = this.extractBids(bidResponse, errors, imps);
            return Result.of((Object)bidderBids, errors);
        }
        catch (DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidResponse bidResponse, List<BidderError> errors, List<Imp> imps) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> this.resolveBidderBid(bidResponse.getCur(), imps, bid, errors)).filter(Objects::nonNull).toList();
    }

    private BidderBid resolveBidderBid(String currency, List<Imp> imps, Bid bid, List<BidderError> errors) {
        BidType bidType;
        try {
            bidType = this.getBidType(bid.getImpid(), imps);
        }
        catch (PreBidException e) {
            errors.add(BidderError.badServerResponse((String)e.getMessage()));
            return null;
        }
        return BidderBid.of((Bid)bid, (BidType)bidType, (String)currency);
    }

    private BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getXNative() == null) continue;
            return BidType.xNative;
        }
        throw new PreBidException("Failed to find impression \"%s\"".formatted(impId));
    }
}

