/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.apacdex;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.apacdex.proto.ExtImpApacdex;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

public class ApacdexBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpApacdex>> APACDEX_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final JsonPointer BID_TYPE_POINTER = JsonPointer.valueOf((String)"/prebid/type");
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public ApacdexBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<Imp> imps = new ArrayList<Imp>();
        for (Imp imp : request.getImp()) {
            try {
                ExtImpApacdex extImpApacdex = this.parseImpExt(imp);
                imps.add(this.modifyImp(imp, extImpApacdex));
            }
            catch (PreBidException e) {
                return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
            }
        }
        return Result.withValue((Object)this.makeHttpRequest(request, imps));
    }

    private ExtImpApacdex parseImpExt(Imp imp) {
        try {
            return (ExtImpApacdex)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), APACDEX_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private Imp modifyImp(Imp imp, ExtImpApacdex extImpApacdex) {
        return imp.toBuilder().ext((ObjectNode)this.mapper.mapper().valueToTree((Object)extImpApacdex)).build();
    }

    private HttpRequest<BidRequest> makeHttpRequest(BidRequest bidRequest, List<Imp> imps) {
        BidRequest modifyBidRequest = bidRequest.toBuilder().imp(imps).build();
        MultiMap headers = HttpUtil.headers().add(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.5");
        return HttpRequest.builder().method(HttpMethod.POST).uri(this.endpointUrl).headers(headers).body(this.mapper.encodeToBytes((Object)modifyBidRequest)).payload((Object)modifyBidRequest).build();
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        BidResponse bidResponse;
        try {
            bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
        ArrayList errors = new ArrayList();
        return Result.of((Object)this.extractBids(bidResponse, errors), errors);
    }

    private List<BidderBid> extractBids(BidResponse bidResponse, List<BidderError> errors) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> this.constructBidderBid(bid, bidResponse.getCur(), errors)).filter(Objects::nonNull).toList();
    }

    private BidderBid constructBidderBid(Bid bid, String currency, List<BidderError> errors) {
        JsonNode bidTypeNode;
        ObjectNode extNode = bid.getExt();
        JsonNode jsonNode = bidTypeNode = extNode != null ? extNode.at(BID_TYPE_POINTER) : null;
        if (bidTypeNode == null || !bidTypeNode.isTextual()) {
            errors.add(BidderError.badServerResponse((String)("Failed to parse bid media type for impression " + bid.getImpid())));
            return null;
        }
        BidType bidType = this.parseBidType(bidTypeNode, errors);
        return bidType != null ? BidderBid.of((Bid)bid, (BidType)this.parseBidType(bidTypeNode, errors), (String)currency) : null;
    }

    private BidType parseBidType(JsonNode bidTypeNode, List<BidderError> errors) {
        try {
            return (BidType)this.mapper.mapper().convertValue((Object)bidTypeNode, BidType.class);
        }
        catch (IllegalArgumentException ignore) {
            errors.add(BidderError.badServerResponse((String)("invalid BidType: " + bidTypeNode.asText())));
            return null;
        }
    }
}

