/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.alkimi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Price;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.alkimi.ExtImpAlkimi;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class AlkimiBidder
implements Bidder<BidRequest> {
    private final String endpointUrl;
    private final JacksonMapper mapper;
    private static final String TYPE_BANNER = "Banner";
    private static final String TYPE_VIDEO = "Video";
    private static final String PRICE_MACRO = "${AUCTION_PRICE}";
    private static final TypeReference<ExtPrebid<?, ExtImpAlkimi>> ALKIMI_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;

    public AlkimiBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        List<Imp> updatedImps = request.getImp().stream().map(imp -> this.updateImp(imp, this.parseImpExt(imp))).toList();
        BidRequest outgoingRequest = request.toBuilder().imp(updatedImps).build();
        return Result.withValue((Object)BidderUtil.defaultRequest((BidRequest)outgoingRequest, (String)this.endpointUrl, (JacksonMapper)this.mapper));
    }

    private ExtImpAlkimi parseImpExt(Imp imp) {
        try {
            return (ExtImpAlkimi)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), ALKIMI_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("Missing bidder ext in impression with id: " + imp.getId());
        }
    }

    private Imp updateImp(Imp imp, ExtImpAlkimi extImpAlkimi) {
        Price bidFloorPrice = Price.of((String)imp.getBidfloorcur(), (BigDecimal)imp.getBidfloor());
        return imp.toBuilder().bidfloor(BidderUtil.isValidPrice((Price)bidFloorPrice) ? bidFloorPrice.getValue() : extImpAlkimi.getBidFloor()).instl(extImpAlkimi.getInstl()).exp(extImpAlkimi.getExp()).ext(this.makeImpExt(imp, extImpAlkimi)).build();
    }

    private ObjectNode makeImpExt(Imp imp, ExtImpAlkimi extImpAlkimi) {
        ExtImpAlkimi.ExtImpAlkimiBuilder extBuilder = extImpAlkimi.toBuilder();
        extBuilder.adUnitCode(imp.getId());
        return (ObjectNode)this.mapper.mapper().valueToTree((Object)ExtPrebid.of(null, (Object)extBuilder.build()));
    }

    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues((List)AlkimiBidder.extractBids((BidRequest)((BidRequest)httpCall.getRequest().getPayload()), (BidResponse)bidResponse));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return AlkimiBidder.bidsFromResponse((BidRequest)bidRequest, (BidResponse)bidResponse);
    }

    private static List<BidderBid> bidsFromResponse(BidRequest bidRequest, BidResponse bidResponse) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> AlkimiBidder.resolveBidderBid((String)bidResponse.getCur(), (List)bidRequest.getImp(), (Bid)bid)).toList();
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        BidType bidType = BidType.banner;
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() != null) {
                return bidType;
            }
            if (imp.getVideo() != null) {
                bidType = BidType.video;
                continue;
            }
            if (imp.getXNative() != null) {
                bidType = BidType.xNative;
                continue;
            }
            if (imp.getAudio() == null) continue;
            bidType = BidType.audio;
        }
        return bidType;
    }

    private static Bid resolveMacros(Bid bid) {
        BigDecimal price = bid.getPrice();
        String priceAsString = price != null ? price.toPlainString() : "0";
        return bid.toBuilder().nurl(StringUtils.replace((String)bid.getNurl(), (String)"${AUCTION_PRICE}", (String)priceAsString)).adm(StringUtils.replace((String)bid.getAdm(), (String)"${AUCTION_PRICE}", (String)priceAsString)).build();
    }

    private static BidderBid resolveBidderBid(String currency, List<Imp> imps, Bid bid) {
        try {
            return BidderBid.of((Bid)AlkimiBidder.resolveMacros((Bid)bid), (BidType)AlkimiBidder.getBidType((String)bid.getImpid(), imps), (String)currency);
        }
        catch (PreBidException e) {
            return null;
        }
    }
}

