/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.algorix;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Video;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.algorix.model.AlgorixVideoExt;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtImpPrebid;
import org.prebid.server.proto.openrtb.ext.request.algorix.ExtImpAlgorix;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class AlgorixBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<ExtImpPrebid, ExtImpAlgorix>> ALGORIX_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final String URL_REGION_MACRO = "{HOST}";
    private static final String URL_SID_MACRO = "{SID}";
    private static final String URL_TOKEN_MACRO = "{TOKEN}";
    private static final int FIRST_INDEX = 0;
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public AlgorixBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        ArrayList<Imp> updatedImps = new ArrayList<Imp>();
        ExtImpAlgorix extImpAlgorix = null;
        for (Imp imp : request.getImp()) {
            try {
                ExtPrebid impExt = this.parseImpExt(imp);
                extImpAlgorix = extImpAlgorix == null ? (ExtImpAlgorix)impExt.getBidder() : extImpAlgorix;
                updatedImps.add(this.updateImp(imp, (ExtImpPrebid)impExt.getPrebid()));
            }
            catch (PreBidException error) {
                errors.add(BidderError.badInput((String)error.getMessage()));
            }
        }
        if (extImpAlgorix == null) {
            return Result.withError((BidderError)BidderError.badInput((String)"Invalid ExtImpAlgoriX value"));
        }
        BidRequest outgoingRequest = request.toBuilder().imp(updatedImps).build();
        return Result.of(Collections.singletonList(HttpRequest.builder().method(HttpMethod.POST).uri(AlgorixBidder.resolveUrl((String)this.endpointUrl, (ExtImpAlgorix)extImpAlgorix)).headers(AlgorixBidder.resolveHeaders()).payload((Object)outgoingRequest).body(this.mapper.encodeToBytes((Object)outgoingRequest)).build()), errors);
    }

    private ExtPrebid<ExtImpPrebid, ExtImpAlgorix> parseImpExt(Imp imp) {
        try {
            return (ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), ALGORIX_EXT_TYPE_REFERENCE);
        }
        catch (IllegalArgumentException error) {
            throw new PreBidException("Impression Id=%s, has invalid Ext".formatted(imp.getId()));
        }
    }

    private Imp updateImp(Imp imp, ExtImpPrebid extImpPrebid) {
        if (imp.getBanner() != null) {
            imp = this.updateBannerImp(imp);
        }
        if (imp.getVideo() != null) {
            imp = this.updateVideoImp(imp, extImpPrebid);
        }
        return imp;
    }

    private Imp updateBannerImp(Imp imp) {
        Banner banner = imp.getBanner();
        if (!(AlgorixBidder.isValidSizeValue((Integer)banner.getW()) && AlgorixBidder.isValidSizeValue((Integer)banner.getH()) || !CollectionUtils.isNotEmpty((Collection)banner.getFormat()))) {
            Format firstFormat = (Format)banner.getFormat().get(0);
            return imp.toBuilder().banner(banner.toBuilder().w(firstFormat.getW()).h(firstFormat.getH()).build()).build();
        }
        return imp;
    }

    private Imp updateVideoImp(Imp imp, ExtImpPrebid extImpPrebid) {
        if (extImpPrebid != null && Objects.equals(extImpPrebid.getIsRewardedInventory(), 1)) {
            Video video = imp.getVideo();
            return imp.toBuilder().video(video.toBuilder().ext((ObjectNode)this.mapper.mapper().valueToTree((Object)AlgorixVideoExt.of((Integer)1))).build()).build();
        }
        return imp;
    }

    private static boolean isValidSizeValue(Integer value) {
        return value != null && value > 0;
    }

    private static String getRegionInfo(ExtImpAlgorix extImp) {
        if (Objects.isNull(extImp.getRegion())) {
            return "xyz";
        }
        return switch (extImp.getRegion()) {
            case "APAC" -> "apac.xyz";
            case "USE" -> "use.xyz";
            case "EUC" -> "euc.xyz";
            default -> "xyz";
        };
    }

    private static String resolveUrl(String endpoint, ExtImpAlgorix extImp) {
        return endpoint.replace("{HOST}", AlgorixBidder.getRegionInfo((ExtImpAlgorix)extImp)).replace("{SID}", extImp.getSid()).replace("{TOKEN}", extImp.getToken());
    }

    private static MultiMap resolveHeaders() {
        MultiMap headers = HttpUtil.headers();
        headers.add(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.5");
        return headers;
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of((Object)this.extractBids((BidRequest)httpCall.getRequest().getPayload(), bidResponse), Collections.emptyList());
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return this.bidsFromResponse(bidRequest, bidResponse);
    }

    private List<BidderBid> bidsFromResponse(BidRequest bidRequest, BidResponse bidResponse) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> BidderBid.of((Bid)bid, (BidType)this.getBidType(bid, bidRequest.getImp()), (String)bidResponse.getCur())).toList();
    }

    private BidType getBidType(Bid bid, List<Imp> imps) {
        BidType bidType;
        ObjectNode bidExt = bid.getExt();
        JsonNode mediaTypeNode = bidExt != null ? bidExt.get("mediaType") : null;
        String mediaType = mediaTypeNode != null && mediaTypeNode.isTextual() ? mediaTypeNode.textValue() : "";
        switch (mediaType) {
            case "banner": {
                BidType bidType2 = BidType.banner;
                break;
            }
            case "native": {
                BidType bidType2 = BidType.xNative;
                break;
            }
            case "video": {
                BidType bidType2 = BidType.video;
                break;
            }
            default: {
                BidType bidType2 = bidType = null;
            }
        }
        if (bidType != null) {
            return bidType;
        }
        for (Imp imp : imps) {
            if (!imp.getId().equals(bid.getImpid())) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getXNative() == null) continue;
            return BidType.xNative;
        }
        return BidType.banner;
    }
}

