/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.advangelists;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.advangelists.ExtImpAdvangelists;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class AdvangelistsBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpAdvangelists>> ADVANGELISTS_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final String URL_PUBLISHER_ID_MACRO = "{{PublisherID}}";
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public AdvangelistsBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList errors = new ArrayList();
        ArrayList httpRequests = new ArrayList();
        try {
            Map impToExtImp = this.getImpToExtImp(request, errors);
            httpRequests.addAll(this.buildAdapterRequests(request, impToExtImp));
        }
        catch (PreBidException e) {
            return Result.withErrors(errors);
        }
        return Result.of(httpRequests, errors);
    }

    private Map<ExtImpAdvangelists, List<Imp>> getImpToExtImp(BidRequest request, List<BidderError> errors) {
        HashMap<ExtImpAdvangelists, List<Imp>> extToListOfUpdatedImp = new HashMap<ExtImpAdvangelists, List<Imp>>();
        for (Imp imp : request.getImp()) {
            if (imp.getBanner() == null && imp.getVideo() == null) {
                errors.add(BidderError.badInput((String)"Unsupported impression has been received"));
                continue;
            }
            try {
                ExtImpAdvangelists extImpEmxDigital = this.parseImpExt(imp);
                Imp updatedImp = AdvangelistsBidder.updateImp((Imp)imp);
                extToListOfUpdatedImp.putIfAbsent(extImpEmxDigital, new ArrayList());
                ((List)extToListOfUpdatedImp.get(extImpEmxDigital)).add(updatedImp);
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        if (extToListOfUpdatedImp.isEmpty()) {
            throw new PreBidException("No appropriate impressions");
        }
        return extToListOfUpdatedImp;
    }

    private ExtImpAdvangelists parseImpExt(Imp imp) {
        ExtImpAdvangelists bidderExt;
        try {
            bidderExt = (ExtImpAdvangelists)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), ADVANGELISTS_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
        if (StringUtils.isEmpty((CharSequence)bidderExt.getPubid())) {
            throw new PreBidException("No pubid value provided");
        }
        return bidderExt;
    }

    private static Imp updateImp(Imp imp) {
        Imp.ImpBuilder impBuilder = imp.toBuilder().audio(null).xNative(null).ext(null);
        Banner banner = imp.getBanner();
        if (banner != null) {
            return impBuilder.banner(AdvangelistsBidder.modifyImpBanner((Banner)banner)).build();
        }
        return impBuilder.build();
    }

    private static Banner modifyImpBanner(Banner banner) {
        if (banner.getW() == null || banner.getH() == null) {
            List bannerFormats = banner.getFormat();
            if (CollectionUtils.isEmpty((Collection)bannerFormats)) {
                throw new PreBidException("Expected at least one banner.format entry or explicit w/h");
            }
            List formatSkipFirst = bannerFormats.subList(1, bannerFormats.size());
            Format firstFormat = (Format)bannerFormats.get(0);
            return banner.toBuilder().format(formatSkipFirst).w(firstFormat.getW()).h(firstFormat.getH()).build();
        }
        return banner;
    }

    private List<HttpRequest<BidRequest>> buildAdapterRequests(BidRequest bidRequest, Map<ExtImpAdvangelists, List<Imp>> impExtToListOfImps) {
        ArrayList<HttpRequest<BidRequest>> httpRequests = new ArrayList<HttpRequest<BidRequest>>();
        for (Map.Entry<ExtImpAdvangelists, List<Imp>> impExtAndListOfImo : impExtToListOfImps.entrySet()) {
            ExtImpAdvangelists extImpAdvangelists = impExtAndListOfImo.getKey();
            List<Imp> imps = impExtAndListOfImo.getValue();
            BidRequest updatedBidRequest = AdvangelistsBidder.makeBidRequest((BidRequest)bidRequest, (ExtImpAdvangelists)extImpAdvangelists, imps);
            MultiMap headers = HttpUtil.headers().add(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.5");
            String createdEndpoint = this.endpointUrl.replace("{{PublisherID}}", HttpUtil.encodeUrl((String)extImpAdvangelists.getPubid()));
            HttpRequest createdBidRequest = HttpRequest.builder().method(HttpMethod.POST).uri(createdEndpoint).body(this.mapper.encodeToBytes((Object)updatedBidRequest)).headers(headers).payload((Object)bidRequest).build();
            httpRequests.add((HttpRequest<BidRequest>)createdBidRequest);
        }
        return httpRequests;
    }

    private static BidRequest makeBidRequest(BidRequest bidRequest, ExtImpAdvangelists extImpAdvangelists, List<Imp> imps) {
        App app;
        List<Imp> modifiedImps = imps.stream().map(imp -> imp.toBuilder().tagid(extImpAdvangelists.getPlacement()).build()).toList();
        BidRequest.BidRequestBuilder bidRequestBuilder = bidRequest.toBuilder();
        bidRequestBuilder.imp(modifiedImps);
        Site site = bidRequest.getSite();
        if (site != null) {
            bidRequestBuilder.site(site.toBuilder().publisher(null).domain("").build());
        }
        if ((app = bidRequest.getApp()) != null) {
            bidRequestBuilder.app(app.toBuilder().publisher(null).build());
        }
        return bidRequestBuilder.build();
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues((List)AdvangelistsBidder.extractBids((BidRequest)((BidRequest)httpCall.getRequest().getPayload()), (BidResponse)bidResponse));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || bidResponse.getSeatbid() == null) {
            return Collections.emptyList();
        }
        if (bidResponse.getSeatbid().size() != 1) {
            throw new PreBidException("Invalid SeatBids count: " + bidResponse.getSeatbid().size());
        }
        return AdvangelistsBidder.bidsFromResponse((BidRequest)bidRequest, (BidResponse)bidResponse);
    }

    private static List<BidderBid> bidsFromResponse(BidRequest bidRequest, BidResponse bidResponse) {
        SeatBid firstSeatBid = (SeatBid)bidResponse.getSeatbid().get(0);
        List bids = firstSeatBid.getBid();
        if (CollectionUtils.isEmpty((Collection)bids)) {
            throw new PreBidException("Empty bids array");
        }
        return bids.stream().filter(Objects::nonNull).map(bid -> BidderBid.of((Bid)bid, (BidType)AdvangelistsBidder.getBidType((String)bid.getImpid(), (List)bidRequest.getImp()), (String)bidResponse.getCur())).toList();
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            return imp.getVideo() != null ? BidType.video : BidType.banner;
        }
        return BidType.banner;
    }
}

