/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.adtrgtme;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.adtrgtme.ExtImpAdtrgtme;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class AdtrgtmeBidder
implements Bidder<BidRequest> {
    private static final String X_OPENRTB_VERSION = "2.5";
    private static final TypeReference<ExtPrebid<?, ExtImpAdtrgtme>> ADTRGTME_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public AdtrgtmeBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<HttpRequest> requests = new ArrayList<HttpRequest>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        for (Imp imp : request.getImp()) {
            try {
                ExtImpAdtrgtme impAdtrgtme = this.parseImpExt(imp);
                BidRequest updatedRequest = AdtrgtmeBidder.createRequest((BidRequest)request, (Imp)imp);
                requests.add(this.makeHttpRequest(updatedRequest, impAdtrgtme.getSiteId()));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        return Result.of(requests, errors);
    }

    private ExtImpAdtrgtme parseImpExt(Imp imp) {
        try {
            return (ExtImpAdtrgtme)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), ADTRGTME_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("ext.bidder not provided");
        }
    }

    private static BidRequest createRequest(BidRequest request, Imp imp) {
        return request.toBuilder().imp(Collections.singletonList(AdtrgtmeBidder.prepareImp((Imp)imp))).build();
    }

    private static Imp prepareImp(Imp imp) {
        return imp.toBuilder().ext(null).build();
    }

    private HttpRequest<BidRequest> makeHttpRequest(BidRequest bidRequest, Integer siteId) {
        return HttpRequest.builder().method(HttpMethod.POST).uri(this.makeUrl(siteId)).headers(this.makeRequestHeaders(bidRequest.getDevice())).body(this.mapper.encodeToBytes((Object)bidRequest)).payload((Object)bidRequest).build();
    }

    private String makeUrl(Integer siteId) {
        return "%s?s=%d&prebid".formatted(this.endpointUrl, siteId);
    }

    private MultiMap makeRequestHeaders(Device device) {
        MultiMap headers = HttpUtil.headers();
        headers.set(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.5");
        HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.USER_AGENT_HEADER, (CharSequence)((CharSequence)ObjectUtil.getIfNotNull((Object)device, Device::getUa)));
        HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)((CharSequence)ObjectUtil.getIfNotNull((Object)device, Device::getIpv6)));
        HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)((CharSequence)ObjectUtil.getIfNotNull((Object)device, Device::getIp)));
        return headers;
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        ArrayList errors = new ArrayList();
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            List imps = ((BidRequest)httpCall.getRequest().getPayload()).getImp();
            List bidderBids = this.extractBids(bidResponse, errors, imps);
            return Result.of((Object)bidderBids, errors);
        }
        catch (DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidResponse bidResponse, List<BidderError> errors, List<Imp> imps) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> this.resolveBidderBid(bidResponse.getCur(), imps, bid, errors)).filter(Objects::nonNull).toList();
    }

    private BidderBid resolveBidderBid(String currency, List<Imp> imps, Bid bid, List<BidderError> errors) {
        BidType bidType;
        try {
            bidType = this.getBidType(bid.getImpid(), imps);
        }
        catch (PreBidException e) {
            errors.add(BidderError.badServerResponse((String)e.getMessage()));
            return null;
        }
        return BidderBid.of((Bid)bid, (BidType)bidType, (String)currency);
    }

    private BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            throw new PreBidException(String.format("Unsupported bidtype for bid: \"%s\"", impId));
        }
        throw new PreBidException("Failed to find impression \"%s\"".formatted(impId));
    }
}

