/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.adtarget;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.adtarget.proto.AdtargetImpExt;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.adtarget.ExtImpAdtarget;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class AdtargetBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpAdtarget>> ADTARGET_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public AdtargetBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        Result sourceIdToImpsResult = this.mapSourceIdToImp(request.getImp());
        ArrayList<HttpRequest> httpRequests = new ArrayList<HttpRequest>();
        for (Map.Entry sourceIdToImps : ((Map)sourceIdToImpsResult.getValue()).entrySet()) {
            String url = "%s?aid=%d".formatted(this.endpointUrl, ObjectUtils.defaultIfNull((Object)((Integer)sourceIdToImps.getKey()), (Object)0));
            BidRequest bidRequest = request.toBuilder().imp((List)sourceIdToImps.getValue()).build();
            httpRequests.add(BidderUtil.defaultRequest((BidRequest)bidRequest, (String)url, (JacksonMapper)this.mapper));
        }
        return Result.of(httpRequests, (List)sourceIdToImpsResult.getErrors());
    }

    private Result<Map<Integer, List<Imp>>> mapSourceIdToImp(List<Imp> imps) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        HashMap<Integer, List> sourceToImps = new HashMap<Integer, List>();
        for (Imp imp : imps) {
            ExtImpAdtarget extImpAdtarget;
            try {
                AdtargetBidder.validateImpression((Imp)imp);
                extImpAdtarget = this.parseImpAdtarget(imp);
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
                continue;
            }
            Imp updatedImp = this.updateImp(imp, extImpAdtarget);
            Integer sourceId = extImpAdtarget.getSourceId();
            sourceToImps.computeIfAbsent(sourceId, ignored -> new ArrayList()).add(updatedImp);
        }
        return Result.of(sourceToImps, errors);
    }

    private ExtImpAdtarget parseImpAdtarget(Imp imp) {
        try {
            return (ExtImpAdtarget)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), ADTARGET_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("ignoring imp id=%s, error while decoding impExt, err: %s".formatted(imp.getId(), e.getMessage()));
        }
    }

    private static void validateImpression(Imp imp) {
        String impId = imp.getId();
        if (imp.getBanner() == null && imp.getVideo() == null) {
            throw new PreBidException("ignoring imp id=%s, Adtarget supports only Video and Banner".formatted(impId));
        }
        ObjectNode impExt = imp.getExt();
        if (impExt == null || impExt.size() == 0) {
            throw new PreBidException("ignoring imp id=%s, extImpBidder is empty".formatted(impId));
        }
    }

    private Imp updateImp(Imp imp, ExtImpAdtarget extImpAdtarget) {
        AdtargetImpExt adtargetImpExt = AdtargetImpExt.of((ExtImpAdtarget)extImpAdtarget);
        BigDecimal bidFloor = extImpAdtarget.getBidFloor();
        return imp.toBuilder().bidfloor(BidderUtil.isValidPrice((BigDecimal)bidFloor) ? bidFloor : imp.getBidfloor()).ext((ObjectNode)this.mapper.mapper().valueToTree((Object)adtargetImpExt)).build();
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        ArrayList errors = new ArrayList();
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of((Object)AdtargetBidder.extractBids((BidResponse)bidResponse, (List)bidRequest.getImp(), errors), errors);
        }
        catch (DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse, List<Imp> imps, List<BidderError> errors) {
        return bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid()) ? Collections.emptyList() : AdtargetBidder.createBiddersBid((BidResponse)bidResponse, imps, errors);
    }

    private static List<BidderBid> createBiddersBid(BidResponse bidResponse, List<Imp> imps, List<BidderError> errors) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> AdtargetBidder.createBidderBid((Bid)bid, (List)imps, (String)bidResponse.getCur(), (List)errors)).filter(Objects::nonNull).toList();
    }

    private static BidderBid createBidderBid(Bid bid, List<Imp> imps, String currency, List<BidderError> errors) {
        BidType bidType;
        try {
            bidType = AdtargetBidder.getBidType((String)bid.getImpid(), (String)bid.getId(), imps);
        }
        catch (PreBidException e) {
            errors.add(BidderError.badServerResponse((String)e.getMessage()));
            return null;
        }
        return BidderBid.of((Bid)bid, (BidType)bidType, (String)currency);
    }

    private static BidType getBidType(String bidImpId, String bidId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(bidImpId)) continue;
            return imp.getVideo() != null ? BidType.video : BidType.banner;
        }
        throw new PreBidException("ignoring bid id=%s, request doesn't contain any impression with id=%s".formatted(bidId, bidImpId));
    }
}

