/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.adot;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.adot.model.AdotBidExt;
import org.prebid.server.bidder.adot.model.AdotExtAdot;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.adot.ExtImpAdot;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class AdotBidder
implements Bidder<BidRequest> {
    private static final List<BidType> ALLOWED_BID_TYPES = Arrays.asList(BidType.banner, BidType.video, BidType.xNative);
    private static final String PRICE_MACRO = "${AUCTION_PRICE}";
    private static final String PUBLISHER_MACRO = "{PUBLISHER_PATH}";
    private static final TypeReference<ExtPrebid<?, ExtImpAdot>> ADOT_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public AdotBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        ArrayList errors = new ArrayList();
        Imp firstImp = (Imp)bidRequest.getImp().get(0);
        String publisherPath = StringUtils.defaultString((String)((String)ObjectUtil.getIfNotNull((Object)this.parseImpExt(firstImp), ExtImpAdot::getPublisherPath)));
        return Result.of(Collections.singletonList(BidderUtil.defaultRequest((BidRequest)bidRequest, (String)this.resolveEndpointUrl(publisherPath), (JacksonMapper)this.mapper)), errors);
    }

    private String resolveEndpointUrl(String publisherPath) {
        return StringUtils.replace((String)this.endpointUrl, (String)"{PUBLISHER_PATH}", (String)publisherPath);
    }

    private ExtImpAdot parseImpExt(Imp firstImp) {
        try {
            ExtPrebid extImpAdot = (ExtPrebid)this.mapper.mapper().convertValue((Object)firstImp.getExt(), ADOT_EXT_TYPE_REFERENCE);
            return extImpAdot != null ? (ExtImpAdot)extImpAdot.getBidder() : null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues((List)this.extractBids(bidResponse));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidResponse bidResponse) {
        return bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid()) ? Collections.emptyList() : this.bidsFromResponse(bidResponse);
    }

    private List<BidderBid> bidsFromResponse(BidResponse bidResponse) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> this.createBidderBid(bid, bidResponse)).filter(Objects::nonNull).toList();
    }

    private BidderBid createBidderBid(Bid bid, BidResponse bidResponse) {
        try {
            return BidderBid.of((Bid)AdotBidder.resolveMacros((Bid)bid), (BidType)this.getBidType(bid), (String)bidResponse.getCur());
        }
        catch (PreBidException e) {
            return null;
        }
    }

    private static Bid resolveMacros(Bid bid) {
        BigDecimal price = bid.getPrice();
        String priceAsString = price != null ? price.toPlainString() : "0";
        return bid.toBuilder().nurl(StringUtils.replace((String)bid.getNurl(), (String)"${AUCTION_PRICE}", (String)priceAsString)).adm(StringUtils.replace((String)bid.getAdm(), (String)"${AUCTION_PRICE}", (String)priceAsString)).build();
    }

    private BidType getBidType(Bid bid) {
        String bidExtType = this.parseBidExtType(bid);
        return ALLOWED_BID_TYPES.stream().filter(bidType -> bidType.getName().equals(bidExtType)).findFirst().orElseThrow(() -> new PreBidException("Wrong Adot bid ext in bid with id : " + bid.getId()));
    }

    private String parseBidExtType(Bid bid) {
        try {
            String mediaType;
            AdotBidExt adotBidExt = (AdotBidExt)this.mapper.mapper().convertValue((Object)bid.getExt(), AdotBidExt.class);
            AdotExtAdot adotExtAdot = adotBidExt != null ? adotBidExt.getAdot() : null;
            String string = mediaType = adotExtAdot != null ? adotExtAdot.getMediaType() : null;
            if (StringUtils.isBlank((CharSequence)mediaType)) {
                throw new IllegalArgumentException();
            }
            return mediaType;
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("Wrong Adot bid ext in bid with id : " + bid.getId());
        }
    }
}

