/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.adoppler;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.adoppler.model.AdopplerResponseAdsExt;
import org.prebid.server.bidder.adoppler.model.AdopplerResponseExt;
import org.prebid.server.bidder.adoppler.model.AdopplerResponseVideoAdsExt;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.adoppler.ExtImpAdoppler;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

public class AdopplerBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpAdoppler>> ADOPPLER_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final String DEFAULT_CLIENT = "app";
    private final String endpointTemplate;
    private final JacksonMapper mapper;

    public AdopplerBidder(String endpointTemplate, JacksonMapper mapper) {
        this.endpointTemplate = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointTemplate));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        ArrayList<HttpRequest> result = new ArrayList<HttpRequest>();
        for (Imp imp : request.getImp()) {
            try {
                ExtImpAdoppler validExtImp = this.parseAndValidateImpExt(imp);
                String updateRequestId = request.getId() + "-" + validExtImp.getAdunit();
                BidRequest updateRequest = request.toBuilder().id(updateRequestId).build();
                String url = this.resolveUrl(validExtImp);
                result.add(this.createSingleRequest(imp, updateRequest, url));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        return Result.of(result, errors);
    }

    private ExtImpAdoppler parseAndValidateImpExt(Imp imp) {
        ExtImpAdoppler extImpAdoppler;
        try {
            extImpAdoppler = (ExtImpAdoppler)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), ADOPPLER_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
        if (StringUtils.isBlank((CharSequence)extImpAdoppler.getAdunit())) {
            throw new PreBidException("adunit parameter is required for adoppler bidder");
        }
        return extImpAdoppler;
    }

    private String resolveUrl(ExtImpAdoppler extImp) {
        String client = extImp.getClient();
        try {
            String accountIdMacro = StringUtils.isBlank((CharSequence)client) ? DEFAULT_CLIENT : HttpUtil.encodeUrl((String)client);
            return this.endpointTemplate.replace("{{AccountID}}", accountIdMacro).replace("{{AdUnit}}", HttpUtil.encodeUrl((String)extImp.getAdunit()));
        }
        catch (Exception e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private HttpRequest<BidRequest> createSingleRequest(Imp imp, BidRequest request, String url) {
        BidRequest outgoingRequest = request.toBuilder().imp(Collections.singletonList(imp)).build();
        MultiMap headers = HttpUtil.headers().add(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.5");
        return HttpRequest.builder().method(HttpMethod.POST).uri(url).headers(headers).body(this.mapper.encodeToBytes((Object)outgoingRequest)).payload((Object)outgoingRequest).build();
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.decodeBodyToBidResponse(httpCall);
            Map impTypes = this.getImpTypes(bidRequest);
            List<BidderBid> bidderBids = bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> this.createBid(bid, impTypes, bidResponse.getCur())).toList();
            return Result.withValues(bidderBids);
        }
        catch (PreBidException e) {
            return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
        }
    }

    private BidResponse decodeBodyToBidResponse(BidderCall<BidRequest> httpCall) {
        try {
            return (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
        }
        catch (DecodeException e) {
            throw new PreBidException("invalid body: " + e.getMessage());
        }
    }

    private Map<String, BidType> getImpTypes(BidRequest bidRequest) {
        HashMap<String, BidType> impTypes = new HashMap<String, BidType>();
        for (Imp imp : bidRequest.getImp()) {
            String impId = imp.getId();
            if (imp.getBanner() != null) {
                impTypes.put(impId, BidType.banner);
                continue;
            }
            if (imp.getVideo() != null) {
                impTypes.put(impId, BidType.video);
                continue;
            }
            if (imp.getAudio() != null) {
                impTypes.put(impId, BidType.audio);
                continue;
            }
            if (imp.getXNative() == null) continue;
            impTypes.put(impId, BidType.xNative);
        }
        return impTypes;
    }

    private BidderBid createBid(Bid bid, Map<String, BidType> impTypes, String currency) {
        String bidImpId = bid.getImpid();
        if (impTypes.get(bidImpId) == null) {
            throw new PreBidException("unknown impId: " + bidImpId);
        }
        if (impTypes.get(bidImpId) == BidType.video) {
            this.validateVideoBidExt(bid);
        }
        return BidderBid.of((Bid)bid, (BidType)impTypes.get(bidImpId), (String)currency);
    }

    private void validateVideoBidExt(Bid bid) {
        AdopplerResponseVideoAdsExt videoAdsExt;
        ObjectNode extNode = bid.getExt();
        AdopplerResponseExt ext = extNode != null ? this.parseResponseExt(extNode) : null;
        AdopplerResponseAdsExt adsExt = ext != null ? ext.getAds() : null;
        AdopplerResponseVideoAdsExt adopplerResponseVideoAdsExt = videoAdsExt = adsExt != null ? adsExt.getVideo() : null;
        if (videoAdsExt == null) {
            throw new PreBidException("$.seatbid.bid.ext.ads.video required");
        }
    }

    private AdopplerResponseExt parseResponseExt(ObjectNode ext) {
        try {
            return (AdopplerResponseExt)this.mapper.mapper().treeToValue((TreeNode)ext, AdopplerResponseExt.class);
        }
        catch (JsonProcessingException e) {
            throw new PreBidException(e.getMessage(), (Throwable)e);
        }
    }
}

