/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.aceex;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.aceex.ExtImpAceex;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class AceexBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpAceex>> ACEEX_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final String ACCOUNT_ID_MACRO = "{{AccountId}}";
    private static final String X_OPENRTB_VERSION = "2.5";
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public AceexBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ExtImpAceex extImpAceex;
        Imp firstImp = (Imp)request.getImp().get(0);
        try {
            extImpAceex = (ExtImpAceex)((ExtPrebid)this.mapper.mapper().convertValue((Object)firstImp.getExt(), ACEEX_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            return Result.withError((BidderError)BidderError.badInput((String)"Ext.bidder not provided"));
        }
        return Result.withValue((Object)HttpRequest.builder().method(HttpMethod.POST).uri(this.resolveEndpoint(extImpAceex.getAccountId())).headers(AceexBidder.constructHeaders((BidRequest)request)).body(this.mapper.encodeToBytes((Object)request)).payload((Object)request).build());
    }

    private String resolveEndpoint(String accountId) {
        return this.endpointUrl.replace("{{AccountId}}", HttpUtil.encodeUrl((String)accountId));
    }

    private static MultiMap constructHeaders(BidRequest bidRequest) {
        Device device = bidRequest.getDevice();
        MultiMap headers = HttpUtil.headers();
        headers.set(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.5");
        HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.USER_AGENT_HEADER, (CharSequence)((CharSequence)ObjectUtil.getIfNotNull((Object)device, Device::getUa)));
        HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)((CharSequence)ObjectUtil.getIfNotNull((Object)device, Device::getIpv6)));
        HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)((CharSequence)ObjectUtil.getIfNotNull((Object)device, Device::getIp)));
        return headers;
    }

    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues((List)AceexBidder.extractBids((BidRequest)((BidRequest)httpCall.getRequest().getPayload()), (BidResponse)bidResponse));
        }
        catch (DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)"Bad Server Response"));
        }
        catch (PreBidException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        SeatBid firstSeatBid;
        List seatBids = (List)ObjectUtil.getIfNotNull((Object)bidResponse, BidResponse::getSeatbid);
        SeatBid seatBid = firstSeatBid = CollectionUtils.isNotEmpty((Collection)seatBids) ? (SeatBid)seatBids.get(0) : null;
        if (firstSeatBid == null) {
            throw new PreBidException("Empty SeatBid array");
        }
        return CollectionUtils.emptyIfNull((Collection)firstSeatBid.getBid()).stream().filter(Objects::nonNull).map(bid -> BidderBid.of((Bid)bid, (BidType)AceexBidder.getBidMediaType((String)bid.getImpid(), (List)bidRequest.getImp()), (String)bidResponse.getCur())).toList();
    }

    private static BidType getBidMediaType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getXNative() == null) continue;
            return BidType.xNative;
        }
        return BidType.banner;
    }
}

