/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.UsersyncMethod;
import org.prebid.server.bidder.UsersyncMethodType;
import org.prebid.server.bidder.Usersyncer;
import org.prebid.server.proto.request.CookieSyncRequest;
import org.prebid.server.util.StreamUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class UsersyncMethodChooser {
    private static final String CATCH_ALL_BIDDERS = "*";
    private final Map<UsersyncMethodType, CookieSyncRequest.MethodFilter> filters;

    public UsersyncMethodChooser(CookieSyncRequest.FilterSettings filterSettings) {
        this.filters = UsersyncMethodChooser.initializeFilters((CookieSyncRequest.FilterSettings)filterSettings);
    }

    public static UsersyncMethodChooser from(CookieSyncRequest.FilterSettings filterSettings) {
        return new UsersyncMethodChooser(filterSettings);
    }

    public UsersyncMethod choose(Usersyncer usersyncer, String bidder) {
        return Stream.of(usersyncer.getIframe(), usersyncer.getRedirect()).filter(method -> this.methodValidAndAllowed(method, bidder)).findFirst().orElse(null);
    }

    private static Map<UsersyncMethodType, CookieSyncRequest.MethodFilter> initializeFilters(CookieSyncRequest.FilterSettings filterSettings) {
        if (filterSettings == null) {
            return Collections.emptyMap();
        }
        HashMap<UsersyncMethodType, CookieSyncRequest.MethodFilter> filterMap = new HashMap<UsersyncMethodType, CookieSyncRequest.MethodFilter>();
        filterMap.computeIfAbsent(UsersyncMethodType.IFRAME, key -> filterSettings.getIframe());
        filterMap.computeIfAbsent(UsersyncMethodType.REDIRECT, key -> filterSettings.getImage());
        return filterMap;
    }

    private boolean methodValidAndAllowed(UsersyncMethod usersyncMethod, String bidder) {
        return this.methodValid(usersyncMethod) && this.methodAllowed(usersyncMethod, bidder);
    }

    private boolean methodValid(UsersyncMethod usersyncMethod) {
        return usersyncMethod != null && StringUtils.isNotBlank((CharSequence)usersyncMethod.getUsersyncUrl());
    }

    private boolean methodAllowed(UsersyncMethod usersyncMethod, String bidder) {
        CookieSyncRequest.MethodFilter filter = (CookieSyncRequest.MethodFilter)this.filters.get(usersyncMethod.getType());
        return filter == null || filter.getFilter() == null || this.bidderNotExcluded(bidder, filter) || this.bidderIncluded(bidder, filter);
    }

    private boolean bidderNotExcluded(String bidder, CookieSyncRequest.MethodFilter filter) {
        return filter.getFilter() == CookieSyncRequest.FilterType.exclude && !this.bidderInList(bidder, filter.getBidders());
    }

    private boolean bidderIncluded(String bidder, CookieSyncRequest.MethodFilter filter) {
        return filter.getFilter() == CookieSyncRequest.FilterType.include && this.bidderInList(bidder, filter.getBidders());
    }

    private boolean bidderInList(String bidder, JsonNode bidders) {
        return this.listMatchesAllBidders(bidders) || this.listContainsBidder(bidders, bidder);
    }

    private boolean listMatchesAllBidders(JsonNode bidders) {
        return bidders == null || bidders.isNull() || bidders.isTextual() && Objects.equals(bidders.textValue(), "*");
    }

    private boolean listContainsBidder(JsonNode bidders, String bidder) {
        return bidders.isArray() && UsersyncMethodChooser.arrayContainsString((JsonNode)bidders, (String)bidder);
    }

    private static boolean arrayContainsString(JsonNode bidders, String value) {
        return StreamUtil.asStream((Spliterator)bidders.spliterator()).anyMatch(element -> UsersyncMethodChooser.elementEqualsString((JsonNode)element, (String)value));
    }

    private static boolean elementEqualsString(JsonNode element, String value) {
        return element != null && element.isTextual() && Objects.equals(element.textValue(), value);
    }
}

