/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder;

import com.iab.openrtb.request.BidRequest;
import io.netty.channel.ConnectTimeoutException;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.auction.BidderAliases;
import org.prebid.server.auction.model.BidRejectionReason;
import org.prebid.server.auction.model.BidRejectionTracker;
import org.prebid.server.auction.model.BidderRequest;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.BidderErrorNotifier;
import org.prebid.server.bidder.BidderRequestCompletionTracker;
import org.prebid.server.bidder.BidderRequestCompletionTrackerFactory;
import org.prebid.server.bidder.HttpBidderRequestEnricher;
import org.prebid.server.bidder.HttpBidderRequester;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.BidderSeatBid;
import org.prebid.server.bidder.model.CompositeBidderResponse;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.HttpResponse;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.execution.Timeout;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.model.CaseInsensitiveMultiMap;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.vertx.http.HttpClient;
import org.prebid.server.vertx.http.model.HttpClientResponse;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpBidderRequester {
    private static final Logger logger = LoggerFactory.getLogger(HttpBidderRequester.class);
    private final HttpClient httpClient;
    private final BidderRequestCompletionTrackerFactory completionTrackerFactory;
    private final BidderErrorNotifier bidderErrorNotifier;
    private final HttpBidderRequestEnricher requestEnricher;
    private final JacksonMapper mapper;

    public HttpBidderRequester(HttpClient httpClient, BidderRequestCompletionTrackerFactory completionTrackerFactory, BidderErrorNotifier bidderErrorNotifier, HttpBidderRequestEnricher requestEnricher, JacksonMapper mapper) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.completionTrackerFactory = HttpBidderRequester.completionTrackerFactoryOrFallback((BidderRequestCompletionTrackerFactory)completionTrackerFactory);
        this.bidderErrorNotifier = Objects.requireNonNull(bidderErrorNotifier);
        this.requestEnricher = Objects.requireNonNull(requestEnricher);
        this.mapper = Objects.requireNonNull(mapper);
    }

    public <T> Future<BidderSeatBid> requestBids(Bidder<T> bidder, BidderRequest bidderRequest, BidRejectionTracker bidRejectionTracker, Timeout timeout, CaseInsensitiveMultiMap requestHeaders, BidderAliases aliases, boolean debugEnabled) {
        String bidderName = bidderRequest.getBidder();
        BidRequest bidRequest = bidderRequest.getBidRequest();
        Result httpRequestsWithErrors = bidder.makeHttpRequests(bidRequest);
        List errors = httpRequestsWithErrors.getErrors();
        List httpRequests = this.enrichRequests(bidderName, (List)httpRequestsWithErrors.getValue(), requestHeaders, aliases, bidRequest);
        HttpBidderRequester.recordBidderProvidedErrors((BidRejectionTracker)bidRejectionTracker, (List)errors);
        if (CollectionUtils.isEmpty((Collection)httpRequests)) {
            return this.emptyBidderSeatBidWithErrors(errors);
        }
        String storedResponse = bidderRequest.getStoredResponse();
        Stream<Future> httpCalls = this.isStoredResponse(httpRequests, storedResponse, bidderName) ? Stream.of(this.makeStoredHttpCall((HttpRequest)httpRequests.get(0), storedResponse)) : httpRequests.stream().map(httpRequest -> this.doRequest(httpRequest, timeout));
        BidderRequestCompletionTracker completionTracker = this.completionTrackerFactory.create(bidRequest);
        ResultBuilder resultBuilder = new ResultBuilder(httpRequests, errors, completionTracker, bidRejectionTracker, this.mapper);
        List<Future> httpRequestFutures = httpCalls.map(httpCallFuture -> httpCallFuture.map(httpCall -> this.bidderErrorNotifier.processTimeout(httpCall, bidder)).map(httpCall -> this.processHttpCall(bidder, bidRequest, resultBuilder, httpCall))).toList();
        return CompositeFuture.any((Future)CompositeFuture.join(new ArrayList<Future>(httpRequestFutures)), (Future)completionTracker.future()).map(ignored -> resultBuilder.toBidderSeatBid(debugEnabled)).onSuccess(seatBid -> bidRejectionTracker.restoreFromRejection((Collection)seatBid.getBids()));
    }

    private <T> List<HttpRequest<T>> enrichRequests(String bidderName, List<HttpRequest<T>> httpRequests, CaseInsensitiveMultiMap requestHeaders, BidderAliases aliases, BidRequest bidRequest) {
        return httpRequests.stream().map(httpRequest -> httpRequest.toBuilder().headers(this.requestEnricher.enrichHeaders(bidderName, httpRequest.getHeaders(), requestHeaders, aliases, bidRequest)).build()).toList();
    }

    private static void recordBidderProvidedErrors(BidRejectionTracker rejectionTracker, List<BidderError> errors) {
        errors.stream().filter(error -> CollectionUtils.isNotEmpty((Collection)error.getImpIds())).forEach(error -> rejectionTracker.reject((Collection)error.getImpIds(), BidRejectionReason.fromBidderError((BidderError)error)));
    }

    private <T> boolean isStoredResponse(List<HttpRequest<T>> httpRequests, String storedResponse, String bidder) {
        if (StringUtils.isBlank((CharSequence)storedResponse)) {
            return false;
        }
        if (httpRequests.size() > 1) {
            logger.warn((Object)"More than one request was created for stored response, when only single stored response per bidder is supported for the moment. Request to real {0} bidder will be performed.", new Object[]{bidder});
            return false;
        }
        return true;
    }

    private <T> Future<BidderCall<T>> makeStoredHttpCall(HttpRequest<T> httpRequest, String storedResponse) {
        HttpResponse httpResponse = HttpResponse.of((int)HttpResponseStatus.OK.code(), null, (String)storedResponse);
        return Future.succeededFuture((Object)BidderCall.storedHttp(httpRequest, (HttpResponse)httpResponse));
    }

    private Future<BidderSeatBid> emptyBidderSeatBidWithErrors(List<BidderError> bidderErrors) {
        List<BidderError> errors = bidderErrors.isEmpty() ? Collections.singletonList(BidderError.failedToRequestBids((String)"The bidder failed to generate any bid requests, but also failed to generate an error")) : bidderErrors;
        return Future.succeededFuture((Object)BidderSeatBid.builder().errors(errors).build());
    }

    private <T> Future<BidderCall<T>> doRequest(HttpRequest<T> httpRequest, Timeout timeout) {
        long remainingTimeout = timeout.remaining();
        if (remainingTimeout <= 0L) {
            return HttpBidderRequester.failResponse((Throwable)new TimeoutException("Timeout has been exceeded"), httpRequest);
        }
        return this.createRequest(httpRequest, remainingTimeout).compose(response -> HttpBidderRequester.processResponse((HttpClientResponse)response, (HttpRequest)httpRequest)).recover(exception -> HttpBidderRequester.failResponse((Throwable)exception, (HttpRequest)httpRequest));
    }

    private <T> Future<HttpClientResponse> createRequest(HttpRequest<T> httpRequest, long remainingTimeout) {
        MultiMap requestHeaders = httpRequest.getHeaders();
        byte[] preparedBody = HttpBidderRequester.compressIfRequired((byte[])httpRequest.getBody(), (MultiMap)requestHeaders);
        return this.httpClient.request(httpRequest.getMethod(), httpRequest.getUri(), requestHeaders, preparedBody, remainingTimeout);
    }

    private static byte[] compressIfRequired(byte[] body, MultiMap headers) {
        String contentEncodingHeader = headers.get(HttpUtil.CONTENT_ENCODING_HEADER);
        return Objects.equals(contentEncodingHeader, HttpHeaderValues.GZIP.toString()) ? HttpBidderRequester.gzip((byte[])body) : body;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static byte[] gzip(byte[] value) {
        try (ByteArrayOutputStream obj = new ByteArrayOutputStream();){
            byte[] byArray;
            try (GZIPOutputStream gzip = new GZIPOutputStream(obj);){
                gzip.write(value);
                gzip.finish();
                byArray = obj.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new PreBidException("Failed to compress request : " + e.getMessage());
        }
    }

    private static <T> Future<BidderCall<T>> failResponse(Throwable exception, HttpRequest<T> httpRequest) {
        logger.warn((Object)"Error occurred while sending HTTP request to a bidder url: {0} with message: {1}", new Object[]{httpRequest.getUri(), exception.getMessage()});
        logger.debug((Object)"Error occurred while sending HTTP request to a bidder url: {0}", exception, new Object[]{httpRequest.getUri()});
        BidderError.Type errorType = exception instanceof TimeoutException || exception instanceof ConnectTimeoutException ? BidderError.Type.timeout : BidderError.Type.generic;
        return Future.succeededFuture((Object)BidderCall.failedHttp(httpRequest, (BidderError)BidderError.create((String)exception.getMessage(), (BidderError.Type)errorType)));
    }

    private static <T> Future<BidderCall<T>> processResponse(HttpClientResponse response, HttpRequest<T> httpRequest) {
        int statusCode = response.getStatusCode();
        HttpResponse httpResponse = HttpResponse.of((int)statusCode, (MultiMap)response.getHeaders(), (String)response.getBody());
        return Future.succeededFuture((Object)BidderCall.succeededHttp(httpRequest, (HttpResponse)httpResponse, (BidderError)HttpBidderRequester.errorOrNull((int)statusCode)));
    }

    private static BidderError errorOrNull(int statusCode) {
        if (statusCode != HttpResponseStatus.OK.code() && statusCode != HttpResponseStatus.NO_CONTENT.code()) {
            return BidderError.create((String)("Unexpected status code: " + statusCode + ". Run with request.test = 1 for more info"), (BidderError.Type)(statusCode == HttpResponseStatus.BAD_REQUEST.code() ? BidderError.Type.bad_input : BidderError.Type.bad_server_response));
        }
        return null;
    }

    private <T> Void processHttpCall(Bidder<T> bidder, BidRequest bidRequest, ResultBuilder<T> seatBidBuilder, BidderCall<T> httpCall) {
        seatBidBuilder.addHttpCall(httpCall, HttpBidderRequester.makeBids(bidder, httpCall, (BidRequest)bidRequest));
        return null;
    }

    private static <T> CompositeBidderResponse makeBids(Bidder<T> bidder, BidderCall<T> httpCall, BidRequest bidRequest) {
        if (httpCall.getError() != null) {
            return null;
        }
        int statusCode = httpCall.getResponse().getStatusCode();
        if (statusCode == HttpResponseStatus.NO_CONTENT.code()) {
            return CompositeBidderResponse.empty();
        }
        if (statusCode != HttpResponseStatus.OK.code()) {
            return null;
        }
        return bidder.makeBidderResponse(HttpBidderRequester.toHttpCallWithSafeResponseBody(httpCall), bidRequest);
    }

    private static <T> BidderCall<T> toHttpCallWithSafeResponseBody(BidderCall<T> httpCall) {
        HttpResponse response = httpCall.getResponse();
        int statusCode = response.getStatusCode();
        if (statusCode == HttpResponseStatus.NO_CONTENT.code()) {
            HttpResponse updatedHttpResponse = HttpResponse.of((int)statusCode, (MultiMap)response.getHeaders(), (String)"{}");
            return BidderCall.succeededHttp((HttpRequest)httpCall.getRequest(), (HttpResponse)updatedHttpResponse, null);
        }
        return httpCall;
    }

    private static BidderRequestCompletionTrackerFactory completionTrackerFactoryOrFallback(BidderRequestCompletionTrackerFactory completionTrackerFactory) {
        return completionTrackerFactory != null ? completionTrackerFactory : bidRequest -> new NoOpCompletionTracker();
    }
}

