/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.requestfactory;

import com.iab.openrtb.request.App;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Dooh;
import com.iab.openrtb.request.Geo;
import com.iab.openrtb.request.Publisher;
import com.iab.openrtb.request.Site;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.activity.infrastructure.ActivityInfrastructure;
import org.prebid.server.activity.infrastructure.creator.ActivityInfrastructureCreator;
import org.prebid.server.auction.IpAddressHelper;
import org.prebid.server.auction.StoredRequestProcessor;
import org.prebid.server.auction.TimeoutResolver;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.auction.model.IpAddress;
import org.prebid.server.auction.model.debug.DebugContext;
import org.prebid.server.auction.requestfactory.Ortb2RequestFactory;
import org.prebid.server.cookie.UidsCookieService;
import org.prebid.server.deals.UserAdditionalInfoService;
import org.prebid.server.deals.model.DeepDebugLog;
import org.prebid.server.deals.model.TxnLog;
import org.prebid.server.exception.BlacklistedAccountException;
import org.prebid.server.exception.InvalidRequestException;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.exception.UnauthorizedAccountException;
import org.prebid.server.execution.Timeout;
import org.prebid.server.execution.TimeoutFactory;
import org.prebid.server.floors.PriceFloorProcessor;
import org.prebid.server.geolocation.CountryCodeMapper;
import org.prebid.server.geolocation.model.GeoInfo;
import org.prebid.server.hooks.execution.HookStageExecutor;
import org.prebid.server.hooks.execution.model.HookExecutionContext;
import org.prebid.server.hooks.execution.model.HookStageExecutionResult;
import org.prebid.server.hooks.v1.auction.AuctionRequestPayload;
import org.prebid.server.hooks.v1.entrypoint.EntrypointPayload;
import org.prebid.server.log.ConditionalLogger;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.Metrics;
import org.prebid.server.model.CaseInsensitiveMultiMap;
import org.prebid.server.model.Endpoint;
import org.prebid.server.model.HttpRequestContext;
import org.prebid.server.model.UpdateResult;
import org.prebid.server.privacy.model.PrivacyContext;
import org.prebid.server.proto.openrtb.ext.FlexibleExtension;
import org.prebid.server.proto.openrtb.ext.request.ExtPublisher;
import org.prebid.server.proto.openrtb.ext.request.ExtPublisherPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestTargeting;
import org.prebid.server.proto.openrtb.ext.request.TraceLevel;
import org.prebid.server.settings.ApplicationSettings;
import org.prebid.server.settings.model.Account;
import org.prebid.server.settings.model.AccountAuctionConfig;
import org.prebid.server.settings.model.AccountStatus;
import org.prebid.server.settings.model.AccountTargetingConfig;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;
import org.prebid.server.validation.RequestValidator;
import org.prebid.server.validation.model.ValidationResult;

/*
 * Exception performing whole class analysis ignored.
 */
public class Ortb2RequestFactory {
    private static final Logger logger = LoggerFactory.getLogger(Ortb2RequestFactory.class);
    private static final ConditionalLogger EMPTY_ACCOUNT_LOGGER = new ConditionalLogger("empty_account", logger);
    private static final ConditionalLogger UNKNOWN_ACCOUNT_LOGGER = new ConditionalLogger("unknown_account", logger);
    private final boolean enforceValidAccount;
    private final double logSamplingRate;
    private final List<String> blacklistedAccounts;
    private final UidsCookieService uidsCookieService;
    private final ActivityInfrastructureCreator activityInfrastructureCreator;
    private final RequestValidator requestValidator;
    private final TimeoutResolver timeoutResolver;
    private final TimeoutFactory timeoutFactory;
    private final StoredRequestProcessor storedRequestProcessor;
    private final ApplicationSettings applicationSettings;
    private final UserAdditionalInfoService userAdditionalInfoService;
    private final IpAddressHelper ipAddressHelper;
    private final HookStageExecutor hookStageExecutor;
    private final PriceFloorProcessor priceFloorProcessor;
    private final CountryCodeMapper countryCodeMapper;
    private final Metrics metrics;
    private final Clock clock;

    public Ortb2RequestFactory(boolean enforceValidAccount, double logSamplingRate, List<String> blacklistedAccounts, UidsCookieService uidsCookieService, ActivityInfrastructureCreator activityInfrastructureCreator, RequestValidator requestValidator, TimeoutResolver timeoutResolver, TimeoutFactory timeoutFactory, StoredRequestProcessor storedRequestProcessor, ApplicationSettings applicationSettings, IpAddressHelper ipAddressHelper, HookStageExecutor hookStageExecutor, UserAdditionalInfoService userAdditionalInfoService, PriceFloorProcessor priceFloorProcessor, CountryCodeMapper countryCodeMapper, Metrics metrics, Clock clock) {
        this.enforceValidAccount = enforceValidAccount;
        this.logSamplingRate = logSamplingRate;
        this.blacklistedAccounts = Objects.requireNonNull(blacklistedAccounts);
        this.uidsCookieService = Objects.requireNonNull(uidsCookieService);
        this.activityInfrastructureCreator = Objects.requireNonNull(activityInfrastructureCreator);
        this.requestValidator = Objects.requireNonNull(requestValidator);
        this.timeoutResolver = Objects.requireNonNull(timeoutResolver);
        this.timeoutFactory = Objects.requireNonNull(timeoutFactory);
        this.storedRequestProcessor = Objects.requireNonNull(storedRequestProcessor);
        this.applicationSettings = Objects.requireNonNull(applicationSettings);
        this.ipAddressHelper = Objects.requireNonNull(ipAddressHelper);
        this.hookStageExecutor = Objects.requireNonNull(hookStageExecutor);
        this.userAdditionalInfoService = userAdditionalInfoService;
        this.priceFloorProcessor = Objects.requireNonNull(priceFloorProcessor);
        this.countryCodeMapper = Objects.requireNonNull(countryCodeMapper);
        this.metrics = Objects.requireNonNull(metrics);
        this.clock = Objects.requireNonNull(clock);
    }

    public AuctionContext createAuctionContext(Endpoint endpoint, MetricName requestTypeMetric) {
        return AuctionContext.builder().requestTypeMetric(requestTypeMetric).prebidErrors(new ArrayList()).debugWarnings(new ArrayList()).hookExecutionContext(HookExecutionContext.of((Endpoint)endpoint)).debugContext(DebugContext.empty()).requestRejected(false).txnLog(TxnLog.create()).debugHttpCalls(new HashMap()).bidRejectionTrackers(new TreeMap(String.CASE_INSENSITIVE_ORDER)).build();
    }

    public AuctionContext enrichAuctionContext(AuctionContext auctionContext, HttpRequestContext httpRequest, BidRequest bidRequest, long startTime) {
        return auctionContext.toBuilder().httpRequest(httpRequest).uidsCookie(this.uidsCookieService.parseFromRequest(httpRequest)).bidRequest(bidRequest).startTime(startTime).timeout(this.timeout(bidRequest, startTime)).deepDebugLog(this.createDeepDebugLog(bidRequest)).build();
    }

    public Future<Account> fetchAccountWithoutStoredRequestLookup(AuctionContext auctionContext) {
        return this.fetchAccount(auctionContext, false);
    }

    public Future<Account> fetchAccount(AuctionContext auctionContext) {
        return this.fetchAccount(auctionContext, true);
    }

    private Future<Account> fetchAccount(AuctionContext auctionContext, boolean isLookupStoredRequest) {
        BidRequest bidRequest = auctionContext.getBidRequest();
        Timeout timeout = auctionContext.getTimeout();
        HttpRequestContext httpRequest = auctionContext.getHttpRequest();
        return this.findAccountIdFrom(bidRequest, isLookupStoredRequest).map(arg_0 -> this.validateIfAccountBlacklisted(arg_0)).compose(accountId -> this.loadAccount(timeout, httpRequest, accountId));
    }

    public Future<ActivityInfrastructure> activityInfrastructureFrom(AuctionContext auctionContext) {
        return Future.succeededFuture((Object)this.activityInfrastructureCreator.create(auctionContext.getAccount(), auctionContext.getGppContext(), auctionContext.getDebugContext().getTraceLevel()));
    }

    public Future<BidRequest> validateRequest(BidRequest bidRequest, HttpRequestContext httpRequestContext, List<String> warnings) {
        ValidationResult validationResult = this.requestValidator.validate(bidRequest, httpRequestContext);
        if (validationResult.hasWarnings()) {
            warnings.addAll(validationResult.getWarnings());
        }
        return validationResult.hasErrors() ? Future.failedFuture((Throwable)new InvalidRequestException(validationResult.getErrors())) : Future.succeededFuture((Object)bidRequest);
    }

    public BidRequest enrichBidRequestWithAccountAndPrivacyData(AuctionContext auctionContext) {
        BidRequest bidRequest = auctionContext.getBidRequest();
        Account account = auctionContext.getAccount();
        PrivacyContext privacyContext = auctionContext.getPrivacyContext();
        ExtRequest requestExt = bidRequest.getExt();
        ExtRequest enrichedRequestExt = this.enrichExtRequest(requestExt, account);
        Device device = bidRequest.getDevice();
        Device enrichedDevice = this.enrichDevice(device, privacyContext);
        if (enrichedRequestExt != null || enrichedDevice != null) {
            return bidRequest.toBuilder().ext((ExtRequest)ObjectUtils.defaultIfNull((Object)enrichedRequestExt, (Object)requestExt)).device((Device)ObjectUtils.defaultIfNull((Object)enrichedDevice, (Object)device)).build();
        }
        return bidRequest;
    }

    public Future<HttpRequestContext> executeEntrypointHooks(RoutingContext routingContext, String body, AuctionContext auctionContext) {
        return this.hookStageExecutor.executeEntrypointStage(Ortb2RequestFactory.toCaseInsensitiveMultiMap((MultiMap)routingContext.queryParams()), Ortb2RequestFactory.toCaseInsensitiveMultiMap((MultiMap)routingContext.request().headers()), body, auctionContext.getHookExecutionContext()).map(stageResult -> Ortb2RequestFactory.toHttpRequest((HookStageExecutionResult)stageResult, (RoutingContext)routingContext, (AuctionContext)auctionContext));
    }

    public Future<BidRequest> executeRawAuctionRequestHooks(AuctionContext auctionContext) {
        return this.hookStageExecutor.executeRawAuctionRequestStage(auctionContext).map(stageResult -> Ortb2RequestFactory.toBidRequest((HookStageExecutionResult)stageResult, (AuctionContext)auctionContext));
    }

    public Future<BidRequest> executeProcessedAuctionRequestHooks(AuctionContext auctionContext) {
        return this.hookStageExecutor.executeProcessedAuctionRequestStage(auctionContext).map(stageResult -> Ortb2RequestFactory.toBidRequest((HookStageExecutionResult)stageResult, (AuctionContext)auctionContext));
    }

    public Future<AuctionContext> restoreResultFromRejection(Throwable throwable) {
        if (throwable instanceof RejectedRequestException) {
            AuctionContext auctionContext = ((RejectedRequestException)throwable).getAuctionContext();
            return Future.succeededFuture((Object)auctionContext.withRequestRejected());
        }
        return Future.failedFuture((Throwable)throwable);
    }

    private static HttpRequestContext toHttpRequest(HookStageExecutionResult<EntrypointPayload> stageResult, RoutingContext routingContext, AuctionContext auctionContext) {
        if (stageResult.isShouldReject()) {
            throw new RejectedRequestException(auctionContext);
        }
        return HttpRequestContext.builder().absoluteUri(routingContext.request().absoluteURI()).queryParams(((EntrypointPayload)stageResult.getPayload()).queryParams()).headers(((EntrypointPayload)stageResult.getPayload()).headers()).body(((EntrypointPayload)stageResult.getPayload()).body()).scheme(routingContext.request().scheme()).remoteHost(routingContext.request().remoteAddress().host()).build();
    }

    private static BidRequest toBidRequest(HookStageExecutionResult<AuctionRequestPayload> stageResult, AuctionContext auctionContext) {
        if (stageResult.isShouldReject()) {
            throw new RejectedRequestException(auctionContext);
        }
        return ((AuctionRequestPayload)stageResult.getPayload()).bidRequest();
    }

    public Future<AuctionContext> populateUserAdditionalInfo(AuctionContext auctionContext) {
        return this.userAdditionalInfoService != null ? this.userAdditionalInfoService.populate(auctionContext) : Future.succeededFuture((Object)auctionContext);
    }

    public AuctionContext enrichWithPriceFloors(AuctionContext auctionContext) {
        return this.priceFloorProcessor.enrichWithPriceFloors(auctionContext);
    }

    public AuctionContext updateTimeout(AuctionContext auctionContext, long startTime) {
        Timeout currentTimeout = auctionContext.getTimeout();
        BidRequest bidRequest = auctionContext.getBidRequest();
        BidRequest resolvedBidRequest = this.resolveBidRequest(bidRequest);
        BidRequest effectiveBidRequest = resolvedBidRequest != null ? resolvedBidRequest : bidRequest;
        Timeout requestTimeout = this.timeoutFactory.create(startTime, effectiveBidRequest.getTmax().longValue());
        if (requestTimeout.getDeadline() == currentTimeout.getDeadline()) {
            return resolvedBidRequest != null ? auctionContext.with(resolvedBidRequest) : auctionContext;
        }
        return auctionContext.toBuilder().bidRequest(effectiveBidRequest).timeout(requestTimeout).build();
    }

    private BidRequest resolveBidRequest(BidRequest bidRequest) {
        Long resolvedTmax = this.resolveTmax(bidRequest.getTmax());
        return resolvedTmax != null ? bidRequest.toBuilder().tmax(resolvedTmax).build() : null;
    }

    private Long resolveTmax(Long requestTimeout) {
        long timeout = this.timeoutResolver.limitToMax(requestTimeout);
        return !Objects.equals(requestTimeout, timeout) ? Long.valueOf(timeout) : null;
    }

    private Timeout timeout(BidRequest bidRequest, long startTime) {
        long timeout = this.timeoutResolver.limitToMax(bidRequest.getTmax());
        return this.timeoutFactory.create(startTime, timeout);
    }

    private Future<String> findAccountIdFrom(BidRequest bidRequest, boolean isLookupStoredRequest) {
        String accountId = this.accountIdFrom(bidRequest);
        return StringUtils.isNotBlank((CharSequence)accountId) || !isLookupStoredRequest ? Future.succeededFuture((Object)accountId) : this.storedRequestProcessor.processAuctionRequest(accountId, bidRequest).map(storedAuctionResult -> this.accountIdFrom(storedAuctionResult.bidRequest()));
    }

    private String validateIfAccountBlacklisted(String accountId) {
        if (CollectionUtils.isNotEmpty((Collection)this.blacklistedAccounts) && StringUtils.isNotBlank((CharSequence)accountId) && this.blacklistedAccounts.contains(accountId)) {
            throw new BlacklistedAccountException("Prebid-server has blacklisted Account ID: %s, please reach out to the prebid server host.".formatted(accountId));
        }
        return accountId;
    }

    private Future<Account> loadAccount(Timeout timeout, HttpRequestContext httpRequest, String accountId) {
        Future accountFuture = StringUtils.isBlank((CharSequence)accountId) ? this.responseForEmptyAccount(httpRequest) : this.applicationSettings.getAccountById(accountId, timeout).compose(arg_0 -> this.ensureAccountActive(arg_0), exception -> this.accountFallback(exception, accountId, httpRequest));
        return accountFuture.onFailure(ignored -> this.metrics.updateAccountRequestRejectedByInvalidAccountMetrics(accountId));
    }

    private String accountIdFrom(BidRequest bidRequest) {
        App app = bidRequest.getApp();
        Publisher appPublisher = app != null ? app.getPublisher() : null;
        Site site = bidRequest.getSite();
        Publisher sitePublisher = site != null ? site.getPublisher() : null;
        Dooh dooh = bidRequest.getDooh();
        Publisher doohPublisher = dooh != null ? dooh.getPublisher() : null;
        Publisher publisher = (Publisher)ObjectUtils.firstNonNull((Object[])new Publisher[]{appPublisher, doohPublisher, sitePublisher});
        String publisherId = publisher != null ? this.resolvePublisherId(publisher) : null;
        return (String)ObjectUtils.defaultIfNull((Object)publisherId, (Object)"");
    }

    private String resolvePublisherId(Publisher publisher) {
        String parentAccountId = this.parentAccountIdFromExtPublisher(publisher.getExt());
        return (String)ObjectUtils.defaultIfNull((Object)parentAccountId, (Object)publisher.getId());
    }

    private String parentAccountIdFromExtPublisher(ExtPublisher extPublisher) {
        ExtPublisherPrebid extPublisherPrebid = extPublisher != null ? extPublisher.getPrebid() : null;
        return extPublisherPrebid != null ? StringUtils.stripToNull((String)extPublisherPrebid.getParentAccount()) : null;
    }

    private Future<Account> responseForEmptyAccount(HttpRequestContext httpRequest) {
        EMPTY_ACCOUNT_LOGGER.warn(Ortb2RequestFactory.accountErrorMessage((String)"Account not specified", (HttpRequestContext)httpRequest), this.logSamplingRate);
        return this.responseForUnknownAccount("");
    }

    private static String accountErrorMessage(String message, HttpRequestContext httpRequest) {
        return "%s, Url: %s and Referer: %s".formatted(message, httpRequest.getAbsoluteUri(), httpRequest.getHeaders().get(HttpUtil.REFERER_HEADER));
    }

    private Future<Account> accountFallback(Throwable exception, String accountId, HttpRequestContext httpRequest) {
        if (exception instanceof PreBidException) {
            UNKNOWN_ACCOUNT_LOGGER.warn(Ortb2RequestFactory.accountErrorMessage((String)exception.getMessage(), (HttpRequestContext)httpRequest), 100);
        } else {
            logger.warn((Object)"Error occurred while fetching account: {0}", new Object[]{exception.getMessage()});
            logger.debug((Object)"Error occurred while fetching account", exception);
        }
        return this.responseForUnknownAccount(accountId);
    }

    private Future<Account> responseForUnknownAccount(String accountId) {
        return this.enforceValidAccount ? Future.failedFuture((Throwable)new UnauthorizedAccountException("Unauthorized account id: " + accountId, accountId)) : Future.succeededFuture((Object)Account.empty((String)accountId));
    }

    private Future<Account> ensureAccountActive(Account account) {
        String accountId = account.getId();
        return account.getStatus() == AccountStatus.inactive ? Future.failedFuture((Throwable)new UnauthorizedAccountException("Account %s is inactive".formatted(accountId), accountId)) : Future.succeededFuture((Object)account);
    }

    private ExtRequest enrichExtRequest(ExtRequest ext, Account account) {
        AccountAuctionConfig accountAuctionConfig = account.getAuction();
        if (accountAuctionConfig == null) {
            return null;
        }
        ExtRequestPrebid extPrebid = ext != null ? ext.getPrebid() : null;
        UpdateResult integration = Ortb2RequestFactory.resolveIntegration((ExtRequestPrebid)extPrebid, (AccountAuctionConfig)accountAuctionConfig);
        UpdateResult targeting = Ortb2RequestFactory.resolveExtPrebidTargeting((ExtRequestPrebid)extPrebid, (AccountAuctionConfig)accountAuctionConfig);
        if (!integration.isUpdated() && !targeting.isUpdated()) {
            return null;
        }
        ExtRequestPrebid updatedExtPrebid = Optional.ofNullable(extPrebid).map(ExtRequestPrebid::toBuilder).orElseGet(ExtRequestPrebid::builder).integration((String)integration.getValue()).targeting((ExtRequestTargeting)targeting.getValue()).build();
        ExtRequest updatedExt = ExtRequest.of((ExtRequestPrebid)updatedExtPrebid);
        Optional.ofNullable(ext).map(FlexibleExtension::getProperties).ifPresent(arg_0 -> ((ExtRequest)updatedExt).addProperties(arg_0));
        return updatedExt;
    }

    private static UpdateResult<String> resolveIntegration(ExtRequestPrebid extPrebid, AccountAuctionConfig accountAuctionConfig) {
        String integration;
        String string = integration = extPrebid != null ? extPrebid.getIntegration() : null;
        if (StringUtils.isNotBlank((CharSequence)integration)) {
            return UpdateResult.unaltered((Object)integration);
        }
        String accountIntegration = accountAuctionConfig.getDefaultIntegration();
        return StringUtils.isNotBlank((CharSequence)accountIntegration) ? UpdateResult.updated((Object)accountIntegration) : UpdateResult.unaltered((Object)integration);
    }

    private static UpdateResult<ExtRequestTargeting> resolveExtPrebidTargeting(ExtRequestPrebid extPrebid, AccountAuctionConfig accountAuctionConfig) {
        ExtRequestTargeting targeting = extPrebid != null ? extPrebid.getTargeting() : null;
        AccountTargetingConfig accountTargeting = accountAuctionConfig.getTargeting();
        if (accountTargeting == null) {
            return UpdateResult.unaltered((Object)targeting);
        }
        TargetingValueResolver targetingValueResolver = new TargetingValueResolver(targeting, accountTargeting);
        UpdateResult includeWinners = targetingValueResolver.resolveIncludeWinners();
        UpdateResult includeBidderKeys = targetingValueResolver.resolveIncludeBidderKeys();
        UpdateResult includeFormat = targetingValueResolver.resolveIncludeFormat();
        UpdateResult preferDeals = targetingValueResolver.resolvePreferDeals();
        UpdateResult alwaysIncludeDeals = targetingValueResolver.resolveAlwaysIncludeDeals();
        return includeWinners.isUpdated() || includeBidderKeys.isUpdated() || includeFormat.isUpdated() || preferDeals.isUpdated() || alwaysIncludeDeals.isUpdated() ? UpdateResult.updated((Object)Optional.ofNullable(targeting).map(ExtRequestTargeting::toBuilder).orElseGet(ExtRequestTargeting::builder).includewinners((Boolean)includeWinners.getValue()).includebidderkeys((Boolean)includeBidderKeys.getValue()).includeformat((Boolean)includeFormat.getValue()).preferdeals((Boolean)preferDeals.getValue()).alwaysincludedeals((Boolean)alwaysIncludeDeals.getValue()).build()) : UpdateResult.unaltered((Object)targeting);
    }

    private Device enrichDevice(Device device, PrivacyContext privacyContext) {
        String ipAddress = privacyContext.getIpAddress();
        IpAddress ip = this.ipAddressHelper.toIpAddress(ipAddress);
        String ipV4InRequest = (String)ObjectUtil.getIfNotNull((Object)device, Device::getIp);
        String ipV4 = ip != null && ip.getVersion() == IpAddress.IP.v4 ? ipAddress : null;
        boolean shouldUpdateIpV4 = ipV4 != null && !Objects.equals(ipV4InRequest, ipV4);
        String ipV6InRequest = (String)ObjectUtil.getIfNotNull((Object)device, Device::getIpv6);
        String ipV6 = ip != null && ip.getVersion() == IpAddress.IP.v6 ? ipAddress : null;
        boolean shouldUpdateIpV6 = ipV6 != null && !Objects.equals(ipV6InRequest, ipV6);
        Geo geo = (Geo)ObjectUtil.getIfNotNull((Object)device, Device::getGeo);
        UpdateResult resolvedCountry = this.resolveCountry(geo, privacyContext);
        UpdateResult resolvedRegion = Ortb2RequestFactory.resolveRegion((Geo)geo, (PrivacyContext)privacyContext);
        if (shouldUpdateIpV4 || shouldUpdateIpV6 || resolvedCountry.isUpdated() || resolvedRegion.isUpdated()) {
            Device.DeviceBuilder deviceBuilder;
            Device.DeviceBuilder deviceBuilder2 = deviceBuilder = device != null ? device.toBuilder() : Device.builder();
            if (shouldUpdateIpV4) {
                deviceBuilder.ip(ipV4);
            }
            if (shouldUpdateIpV6) {
                deviceBuilder.ipv6(ipV6);
            }
            if (resolvedCountry.isUpdated() || resolvedRegion.isUpdated()) {
                Geo updatedGeo = Optional.ofNullable(geo).map(Geo::toBuilder).orElseGet(Geo::builder).country((String)resolvedCountry.getValue()).region((String)resolvedRegion.getValue()).build();
                deviceBuilder.geo(updatedGeo);
            }
            return deviceBuilder.build();
        }
        return null;
    }

    private UpdateResult<String> resolveCountry(Geo geo, PrivacyContext privacyContext) {
        String countryInRequest = geo != null ? geo.getCountry() : null;
        GeoInfo geoInfo = privacyContext.getTcfContext().getGeoInfo();
        String alpha2CountryCode = geoInfo != null ? geoInfo.getCountry() : null;
        String alpha3CountryCode = this.countryCodeMapper.mapToAlpha3(alpha2CountryCode);
        return alpha3CountryCode != null && !alpha3CountryCode.equals(countryInRequest) ? UpdateResult.updated((Object)alpha3CountryCode) : UpdateResult.unaltered((Object)countryInRequest);
    }

    private static UpdateResult<String> resolveRegion(Geo geo, PrivacyContext privacyContext) {
        String regionInRequest = geo != null ? geo.getRegion() : null;
        String upperCasedRegionInRequest = StringUtils.upperCase((String)regionInRequest);
        GeoInfo geoInfo = privacyContext.getTcfContext().getGeoInfo();
        String region = geoInfo != null ? geoInfo.getRegion() : null;
        String upperCasedRegion = StringUtils.upperCase((String)region);
        return upperCasedRegion != null && !upperCasedRegion.equals(upperCasedRegionInRequest) ? UpdateResult.updated((Object)upperCasedRegion) : (Objects.equals(regionInRequest, upperCasedRegionInRequest) ? UpdateResult.unaltered((Object)regionInRequest) : UpdateResult.updated((Object)upperCasedRegionInRequest));
    }

    private static CaseInsensitiveMultiMap toCaseInsensitiveMultiMap(MultiMap originalMap) {
        CaseInsensitiveMultiMap.Builder mapBuilder = CaseInsensitiveMultiMap.builder();
        originalMap.entries().forEach(entry -> mapBuilder.add((String)entry.getKey(), (String)entry.getValue()));
        return mapBuilder.build();
    }

    private DeepDebugLog createDeepDebugLog(BidRequest bidRequest) {
        ExtRequest ext = bidRequest.getExt();
        return DeepDebugLog.create((ext != null && Ortb2RequestFactory.isDeepDebugEnabled((ExtRequest)ext) ? 1 : 0) != 0, (Clock)this.clock);
    }

    private static boolean isDeepDebugEnabled(ExtRequest extRequest) {
        ExtRequestPrebid extRequestPrebid = extRequest != null ? extRequest.getPrebid() : null;
        return extRequestPrebid != null && extRequestPrebid.getTrace() == TraceLevel.verbose;
    }
}

