/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.requestfactory;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Publisher;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.Source;
import com.iab.openrtb.request.SupplyChain;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.auction.ImplicitParametersExtractor;
import org.prebid.server.auction.IpAddressHelper;
import org.prebid.server.auction.PriceGranularity;
import org.prebid.server.auction.TimeoutResolver;
import org.prebid.server.auction.model.Endpoint;
import org.prebid.server.auction.model.IpAddress;
import org.prebid.server.auction.requestfactory.Ortb2ImplicitParametersResolver;
import org.prebid.server.exception.BlacklistedAppException;
import org.prebid.server.exception.InvalidRequestException;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.identity.IdGenerator;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.json.JsonMerger;
import org.prebid.server.model.CaseInsensitiveMultiMap;
import org.prebid.server.model.HttpRequestContext;
import org.prebid.server.proto.openrtb.ext.FlexibleExtension;
import org.prebid.server.proto.openrtb.ext.request.ExtDevice;
import org.prebid.server.proto.openrtb.ext.request.ExtMediaTypePriceGranularity;
import org.prebid.server.proto.openrtb.ext.request.ExtPriceGranularity;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidCache;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidCacheBids;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidCacheVastxml;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidChannel;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidServer;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestTargeting;
import org.prebid.server.proto.openrtb.ext.request.ExtSite;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class Ortb2ImplicitParametersResolver {
    private static final Logger logger = LoggerFactory.getLogger(Ortb2ImplicitParametersResolver.class);
    public static final String WEB_CHANNEL = "web";
    public static final String APP_CHANNEL = "app";
    public static final String AMP_CHANNEL = "amp";
    public static final String DOOH_CHANNEL = "dooh";
    private static final String PREBID_EXT = "prebid";
    private static final String BIDDER_EXT = "bidder";
    private static final Set<String> IMP_EXT_NON_BIDDER_FIELDS = Set.of("prebid", "context", "all", "general", "skadn", "data", "gpid", "tid", "ae");
    private static final String OVERRIDE_SOURCE_ID_TEMPLATE = "{{UUID}}";
    private final boolean shouldCacheOnlyWinningBids;
    private final boolean generateBidRequestId;
    private final String adServerCurrency;
    private final List<String> blacklistedApps;
    private final ExtRequestPrebidServer serverInfo;
    private final ImplicitParametersExtractor paramsExtractor;
    private final TimeoutResolver timeoutResolver;
    private final IpAddressHelper ipAddressHelper;
    private final IdGenerator tidGenerator;
    private final JsonMerger jsonMerger;
    private final JacksonMapper mapper;

    public Ortb2ImplicitParametersResolver(boolean shouldCacheOnlyWinningBids, boolean generateBidRequestId, String adServerCurrency, List<String> blacklistedApps, String externalUrl, Integer hostVendorId, String datacenterRegion, ImplicitParametersExtractor paramsExtractor, TimeoutResolver timeoutResolver, IpAddressHelper ipAddressHelper, IdGenerator tidGenerator, JsonMerger jsonMerger, JacksonMapper mapper) {
        this.shouldCacheOnlyWinningBids = shouldCacheOnlyWinningBids;
        this.generateBidRequestId = generateBidRequestId;
        this.adServerCurrency = Ortb2ImplicitParametersResolver.validateCurrency((String)Objects.requireNonNull(adServerCurrency));
        this.blacklistedApps = Objects.requireNonNull(blacklistedApps);
        this.serverInfo = ExtRequestPrebidServer.of((String)externalUrl, (Integer)hostVendorId, (String)datacenterRegion, null);
        this.paramsExtractor = Objects.requireNonNull(paramsExtractor);
        this.timeoutResolver = Objects.requireNonNull(timeoutResolver);
        this.ipAddressHelper = Objects.requireNonNull(ipAddressHelper);
        this.tidGenerator = Objects.requireNonNull(tidGenerator);
        this.jsonMerger = Objects.requireNonNull(jsonMerger);
        this.mapper = Objects.requireNonNull(mapper);
    }

    private static String validateCurrency(String code) {
        try {
            Currency.getInstance(code);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Currency code supplied is not valid: " + code, e);
        }
        return code;
    }

    public BidRequest resolve(BidRequest bidRequest, HttpRequestContext httpRequest, String endpoint, boolean hasStoredBidRequest) {
        this.checkBlacklistedApp(bidRequest);
        Device device = bidRequest.getDevice();
        Device populatedDevice = this.populateDevice(device, bidRequest.getApp(), httpRequest);
        Site site = bidRequest.getSite();
        Site populatedSite = bidRequest.getApp() != null || bidRequest.getDooh() != null ? null : this.populateSite(site, httpRequest);
        List populatedImps = this.populateImps(bidRequest, this.generateBidRequestId, hasStoredBidRequest);
        Integer at = bidRequest.getAt();
        Integer resolvedAt = Ortb2ImplicitParametersResolver.resolveAt((Integer)at);
        List cur = bidRequest.getCur();
        List resolvedCurrencies = this.resolveCurrencies(cur);
        Long tmax = bidRequest.getTmax();
        Long resolvedTmax = this.resolveTmax(tmax);
        ExtRequest ext = bidRequest.getExt();
        List imps = bidRequest.getImp();
        ExtRequest populatedExt = this.populateRequestExt(ext, bidRequest, (List)ObjectUtils.defaultIfNull((Object)populatedImps, (Object)imps), endpoint);
        Source source = bidRequest.getSource();
        Source populatedSource = this.populateSource(source, populatedExt, hasStoredBidRequest);
        return bidRequest.toBuilder().device(populatedDevice != null ? populatedDevice : device).site(populatedSite != null ? populatedSite : site).imp(populatedImps != null ? populatedImps : imps).at(resolvedAt != null ? resolvedAt : at).cur(resolvedCurrencies != null ? resolvedCurrencies : cur).tmax(resolvedTmax != null ? resolvedTmax : tmax).ext(populatedExt).source(populatedSource != null ? populatedSource : source).build();
    }

    public static boolean isImpExtBidder(String field) {
        return !IMP_EXT_NON_BIDDER_FIELDS.contains(field);
    }

    private void checkBlacklistedApp(BidRequest bidRequest) {
        String appId;
        App app = bidRequest.getApp();
        String string = appId = app != null ? app.getId() : null;
        if (StringUtils.isNotBlank((CharSequence)appId) && this.blacklistedApps.contains(appId)) {
            throw new BlacklistedAppException("Prebid-server does not process requests from App ID: " + appId);
        }
    }

    private Device populateDevice(Device device, App app, HttpRequestContext httpRequest) {
        String deviceIp = device != null ? device.getIp() : null;
        String deviceIpv6 = device != null ? device.getIpv6() : null;
        String resolvedIp = this.sanitizeIp(deviceIp, IpAddress.IP.v4);
        String resolvedIpv6 = this.sanitizeIp(deviceIpv6, IpAddress.IP.v6);
        if (resolvedIp == null && resolvedIpv6 == null) {
            IpAddress requestIp = this.findIpFromRequest(httpRequest);
            resolvedIp = Ortb2ImplicitParametersResolver.getIpIfVersionIs((IpAddress)requestIp, (IpAddress.IP)IpAddress.IP.v4);
            resolvedIpv6 = Ortb2ImplicitParametersResolver.getIpIfVersionIs((IpAddress)requestIp, (IpAddress.IP)IpAddress.IP.v6);
        }
        Ortb2ImplicitParametersResolver.logWarnIfNoIp((String)resolvedIp, (String)resolvedIpv6);
        String ua = device != null ? device.getUa() : null;
        Integer dnt = this.resolveDntHeader(httpRequest);
        Integer lmt = Ortb2ImplicitParametersResolver.resolveLmt((Device)device, (App)app);
        if (!Objects.equals(deviceIp, resolvedIp) || !Objects.equals(deviceIpv6, resolvedIpv6) || StringUtils.isBlank((CharSequence)ua) || dnt != null || lmt != null) {
            Device.DeviceBuilder builder;
            Device.DeviceBuilder deviceBuilder = builder = device == null ? Device.builder() : device.toBuilder();
            if (StringUtils.isBlank((CharSequence)ua)) {
                builder.ua(this.paramsExtractor.uaFrom(httpRequest));
            }
            if (dnt != null) {
                builder.dnt(dnt);
            }
            if (lmt != null) {
                builder.lmt(lmt);
            }
            builder.ip(resolvedIp).ipv6(resolvedIpv6);
            return builder.build();
        }
        return null;
    }

    private Integer resolveDntHeader(HttpRequestContext request) {
        String dnt = request.getHeaders().get(HttpUtil.DNT_HEADER.toString());
        return StringUtils.equalsAny((CharSequence)dnt, (CharSequence[])new CharSequence[]{"0", "1"}) ? Integer.valueOf(dnt) : null;
    }

    private String sanitizeIp(String ip, IpAddress.IP version) {
        IpAddress ipAddress = ip != null ? this.ipAddressHelper.toIpAddress(ip) : null;
        return ipAddress != null && ipAddress.getVersion() == version ? ipAddress.getIp() : null;
    }

    private IpAddress findIpFromRequest(HttpRequestContext request) {
        CaseInsensitiveMultiMap headers = request.getHeaders();
        String remoteHost = request.getRemoteHost();
        List requestIps = this.paramsExtractor.ipFrom(headers, remoteHost);
        return requestIps.stream().map(arg_0 -> ((IpAddressHelper)this.ipAddressHelper).toIpAddress(arg_0)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static String getIpIfVersionIs(IpAddress requestIp, IpAddress.IP version) {
        return requestIp != null && requestIp.getVersion() == version ? requestIp.getIp() : null;
    }

    private static void logWarnIfNoIp(String resolvedIp, String resolvedIpv6) {
        if (resolvedIp == null && resolvedIpv6 == null) {
            logger.warn((Object)"No IP address found in OpenRTB request and HTTP request headers.");
        }
    }

    private static Integer resolveLmt(Device device, App app) {
        if (app == null || device == null || !StringUtils.equalsIgnoreCase((CharSequence)device.getOs(), (CharSequence)"ios")) {
            return null;
        }
        String osv = device.getOsv();
        if (osv == null) {
            return null;
        }
        String[] versionParts = StringUtils.split((String)osv, (char)'.');
        if (versionParts.length < 2) {
            return null;
        }
        Integer versionMajor = Ortb2ImplicitParametersResolver.tryParseAsNumber((String)versionParts[0]);
        Integer versionMinor = Ortb2ImplicitParametersResolver.tryParseAsNumber((String)versionParts[1]);
        if (versionMajor == null || versionMinor == null) {
            return null;
        }
        return Ortb2ImplicitParametersResolver.resolveLmtForIos((Device)device, (Integer)versionMajor, (Integer)versionMinor);
    }

    private static Integer tryParseAsNumber(String number) {
        try {
            return Integer.parseUnsignedInt(number);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Integer resolveLmtForIos(Device device, Integer versionMajor, Integer versionMinor) {
        if (versionMajor < 14) {
            return null;
        }
        if (versionMajor == 14 && (versionMinor == 0 || versionMinor == 1)) {
            return Ortb2ImplicitParametersResolver.resolveLmtForIos14Minor0And1((Device)device);
        }
        if (versionMajor > 14 || versionMinor >= 2) {
            return Ortb2ImplicitParametersResolver.resolveLmtForIos14Minor2AndHigher((Device)device);
        }
        return null;
    }

    private static Integer resolveLmtForIos14Minor0And1(Device device) {
        String ifa = device.getIfa();
        Integer lmt = device.getLmt();
        if (StringUtils.isEmpty((CharSequence)ifa) || ifa.equals("00000000-0000-0000-0000-000000000000")) {
            return !Objects.equals(lmt, 1) ? Integer.valueOf(1) : null;
        }
        return !Objects.equals(lmt, 0) ? Integer.valueOf(0) : null;
    }

    private static Integer resolveLmtForIos14Minor2AndHigher(Device device) {
        Integer lmt = device.getLmt();
        Integer atts = (Integer)ObjectUtil.getIfNotNull((Object)device.getExt(), ExtDevice::getAtts);
        if (atts == null) {
            return null;
        }
        if (atts == 3) {
            return !Objects.equals(lmt, 0) ? Integer.valueOf(0) : null;
        }
        if (atts == 0 || atts == 1 || atts == 2) {
            return !Objects.equals(lmt, 1) ? Integer.valueOf(1) : null;
        }
        return null;
    }

    private Site populateSite(Site site, HttpRequestContext httpRequest) {
        ExtSite updatedSiteExt;
        String page = site != null ? StringUtils.trimToNull((String)site.getPage()) : null;
        String updatedPage = page == null ? this.paramsExtractor.refererFrom(httpRequest) : null;
        String domain = site != null ? StringUtils.trimToNull((String)site.getDomain()) : null;
        String updatedDomain = domain == null ? HttpUtil.getHostFromUrl((String)((String)ObjectUtils.defaultIfNull((Object)updatedPage, (Object)page))) : null;
        Publisher publisher = site != null ? site.getPublisher() : null;
        Publisher updatedPublisher = this.populateSitePublisher(publisher, (String)ObjectUtils.defaultIfNull((Object)updatedDomain, (Object)domain));
        ExtSite siteExt = site != null ? site.getExt() : null;
        ExtSite extSite = updatedSiteExt = siteExt == null || siteExt.getAmp() == null ? ExtSite.of((Integer)0, (ObjectNode)((ObjectNode)ObjectUtil.getIfNotNull((Object)siteExt, ExtSite::getData))) : null;
        if (ObjectUtils.anyNotNull((Object[])new Object[]{updatedPage, updatedDomain, updatedPublisher, updatedSiteExt})) {
            boolean domainPresent = publisher != null && publisher.getDomain() != null || updatedPublisher != null && updatedPublisher.getDomain() != null;
            return (site == null ? Site.builder() : site.toBuilder()).page(domainPresent ? (String)ObjectUtils.defaultIfNull((Object)updatedPage, (Object)page) : page).domain((String)ObjectUtils.defaultIfNull((Object)updatedDomain, (Object)domain)).publisher((Publisher)ObjectUtils.defaultIfNull((Object)updatedPublisher, (Object)publisher)).ext((ExtSite)ObjectUtils.defaultIfNull((Object)updatedSiteExt, (Object)siteExt)).build();
        }
        return null;
    }

    private Publisher populateSitePublisher(Publisher publisher, String domain) {
        String updatedPublisherDomain;
        String publisherDomain = publisher != null ? publisher.getDomain() : null;
        String string = updatedPublisherDomain = publisherDomain == null ? this.getDomainOrNull(domain) : null;
        if (updatedPublisherDomain != null) {
            return (publisher == null ? Publisher.builder() : publisher.toBuilder()).domain(updatedPublisherDomain).build();
        }
        return null;
    }

    private String getDomainOrNull(String url) {
        try {
            return this.paramsExtractor.domainFrom(url);
        }
        catch (PreBidException e) {
            logger.warn((Object)"Error occurred while populating bid request: {0}", new Object[]{e.getMessage()});
            return null;
        }
    }

    private Source populateSource(Source source, ExtRequest extRequest, boolean hasStoredBidRequest) {
        SupplyChain supplyChain;
        SupplyChain populatedSupplyChain;
        String tid = source != null ? source.getTid() : null;
        String populatedTid = Ortb2ImplicitParametersResolver.populateTidValue((String)tid, (boolean)this.generateBidRequestId, (boolean)hasStoredBidRequest, (IdGenerator)this.tidGenerator);
        if (ObjectUtils.anyNotNull((Object[])new Object[]{populatedTid, populatedSupplyChain = this.populateSupplyChain(supplyChain = source != null ? source.getSchain() : null, extRequest)})) {
            return (source != null ? source.toBuilder() : Source.builder()).tid(populatedTid != null ? populatedTid : tid).schain(populatedSupplyChain != null ? populatedSupplyChain : supplyChain).build();
        }
        return null;
    }

    private static String populateTidValue(String tid, boolean generateBidRequestId, boolean hasStoredBidRequest, IdGenerator tidGenerator) {
        boolean containsTidMacro = StringUtils.containsIgnoreCase((CharSequence)tid, (CharSequence)"{{UUID}}");
        if (!(!StringUtils.isNotBlank((CharSequence)tid) || containsTidMacro || generateBidRequestId && hasStoredBidRequest)) {
            return null;
        }
        String generatedId = tidGenerator.generateId();
        return StringUtils.isBlank((CharSequence)tid) || generateBidRequestId && hasStoredBidRequest && !containsTidMacro ? generatedId : StringUtils.replaceIgnoreCase((String)tid, (String)"{{UUID}}", (String)generatedId);
    }

    private SupplyChain populateSupplyChain(SupplyChain supplyChain, ExtRequest extRequest) {
        if (supplyChain != null || extRequest == null) {
            return null;
        }
        try {
            return (SupplyChain)this.mapper.mapper().convertValue((Object)extRequest.getProperty("schain"), SupplyChain.class);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private List<Imp> populateImps(BidRequest bidRequest, boolean generateBidRequestId, boolean hasStoredBidRequest) {
        List imps = bidRequest.getImp();
        if (CollectionUtils.isEmpty((Collection)imps)) {
            return null;
        }
        ObjectNode globalBidderParams = Ortb2ImplicitParametersResolver.extractGlobalBidderParams((BidRequest)bidRequest);
        boolean isUniqueIds = Ortb2ImplicitParametersResolver.isUniqueIds((List)imps);
        List<ImpPopulationContext> impPopulationContexts = IntStream.range(0, imps.size()).mapToObj(index -> new ImpPopulationContext((Imp)imps.get(index), globalBidderParams, generateBidRequestId, hasStoredBidRequest, !isUniqueIds ? String.valueOf(index + 1) : null, this.mapper, this.tidGenerator, this.jsonMerger)).toList();
        if (impPopulationContexts.stream().map(ImpPopulationContext::getPopulatedImp).allMatch(Objects::isNull)) {
            return null;
        }
        return impPopulationContexts.stream().map(ImpPopulationContext::getPopulationResult).toList();
    }

    private static ObjectNode extractGlobalBidderParams(BidRequest bidRequest) {
        ExtRequest extRequest = bidRequest.getExt();
        ExtRequestPrebid extBidPrebid = extRequest != null ? extRequest.getPrebid() : null;
        ObjectNode bidderParams = extBidPrebid != null ? extBidPrebid.getBidderparams() : null;
        return Ortb2ImplicitParametersResolver.isObjectNode((JsonNode)bidderParams) ? Ortb2ImplicitParametersResolver.removeNonBidderFields((ObjectNode)bidderParams) : null;
    }

    private static ObjectNode removeNonBidderFields(ObjectNode node) {
        ObjectNode modifiedNode = node.deepCopy();
        IMP_EXT_NON_BIDDER_FIELDS.forEach(arg_0 -> ((ObjectNode)modifiedNode).remove(arg_0));
        return !modifiedNode.isEmpty() ? modifiedNode : null;
    }

    private static boolean isObjectNode(JsonNode node) {
        return node != null && node.isObject();
    }

    private static boolean isUniqueIds(List<Imp> imps) {
        List<String> impIdsList = imps.stream().filter(Objects::nonNull).map(Imp::getId).toList();
        HashSet<String> impIdsSet = new HashSet<String>(impIdsList);
        return impIdsSet.size() == impIdsList.size();
    }

    private ExtRequest populateRequestExt(ExtRequest ext, BidRequest bidRequest, List<Imp> imps, String endpoint) {
        ExtRequestPrebid prebid = (ExtRequestPrebid)ObjectUtil.getIfNotNull((Object)ext, ExtRequest::getPrebid);
        ExtRequestTargeting updatedTargeting = this.targetingOrNull(prebid, imps);
        ExtRequestPrebidCache updatedCache = this.cacheOrNull(prebid);
        ExtRequestPrebidChannel updatedChannel = this.channelOrNull(prebid, bidRequest, endpoint);
        ExtRequestPrebid.ExtRequestPrebidBuilder prebidBuilder = prebid != null ? prebid.toBuilder() : ExtRequestPrebid.builder();
        ExtRequest updatedExt = ExtRequest.of((ExtRequestPrebid)prebidBuilder.targeting((ExtRequestTargeting)ObjectUtils.defaultIfNull((Object)updatedTargeting, (Object)((ExtRequestTargeting)ObjectUtil.getIfNotNull((Object)prebid, ExtRequestPrebid::getTargeting)))).cache((ExtRequestPrebidCache)ObjectUtils.defaultIfNull((Object)updatedCache, (Object)((ExtRequestPrebidCache)ObjectUtil.getIfNotNull((Object)prebid, ExtRequestPrebid::getCache)))).channel((ExtRequestPrebidChannel)ObjectUtils.defaultIfNull((Object)updatedChannel, (Object)((ExtRequestPrebidChannel)ObjectUtil.getIfNotNull((Object)prebid, ExtRequestPrebid::getChannel)))).server(this.serverInfo.with(endpoint)).build());
        Map extProperties = (Map)ObjectUtil.getIfNotNull((Object)ext, FlexibleExtension::getProperties);
        if (extProperties != null) {
            updatedExt.addProperties(extProperties);
        }
        return updatedExt;
    }

    private static Set<BidType> getImpMediaTypes(List<Imp> imps) {
        HashSet<BidType> impMediaTypes = new HashSet<BidType>();
        if (CollectionUtils.isEmpty(imps)) {
            return impMediaTypes;
        }
        for (Imp imp : imps) {
            Ortb2ImplicitParametersResolver.resolveImpMediaTypes((Imp)imp, impMediaTypes);
            if (impMediaTypes.size() < 4) continue;
            break;
        }
        return impMediaTypes;
    }

    private static void resolveImpMediaTypes(Imp imp, Set<BidType> impsMediaTypes) {
        if (imp.getBanner() != null) {
            impsMediaTypes.add(BidType.banner);
        }
        if (imp.getVideo() != null) {
            impsMediaTypes.add(BidType.video);
        }
        if (imp.getAudio() != null) {
            impsMediaTypes.add(BidType.audio);
        }
        if (imp.getXNative() != null) {
            impsMediaTypes.add(BidType.xNative);
        }
    }

    private ExtRequestTargeting targetingOrNull(ExtRequestPrebid prebid, List<Imp> imps) {
        boolean isIncludeBidderKeysNull;
        ExtRequestTargeting targeting = prebid != null ? prebid.getTargeting() : null;
        boolean isTargetingNotNull = targeting != null;
        boolean isPriceGranularityNull = isTargetingNotNull && (targeting.getPricegranularity() == null || targeting.getPricegranularity().isNull());
        boolean isPriceGranularityTextual = isTargetingNotNull && !isPriceGranularityNull && targeting.getPricegranularity().isTextual();
        boolean isIncludeWinnersNull = isTargetingNotNull && targeting.getIncludewinners() == null;
        boolean bl = isIncludeBidderKeysNull = isTargetingNotNull && targeting.getIncludebidderkeys() == null;
        if (isPriceGranularityNull || isPriceGranularityTextual || isIncludeWinnersNull || isIncludeBidderKeysNull) {
            return targeting.toBuilder().pricegranularity(this.resolvePriceGranularity(targeting, isPriceGranularityNull, isPriceGranularityTextual, imps)).includewinners(Boolean.valueOf(isIncludeWinnersNull || targeting.getIncludewinners() != false)).includebidderkeys(Boolean.valueOf(isIncludeBidderKeysNull ? !this.isWinningOnly(prebid.getCache()) : targeting.getIncludebidderkeys())).build();
        }
        return null;
    }

    private boolean isWinningOnly(ExtRequestPrebidCache cache) {
        Boolean cacheWinningOnly = cache != null ? cache.getWinningonly() : null;
        return (Boolean)ObjectUtils.defaultIfNull((Object)cacheWinningOnly, (Object)this.shouldCacheOnlyWinningBids);
    }

    private JsonNode resolvePriceGranularity(ExtRequestTargeting targeting, boolean isPriceGranularityNull, boolean isPriceGranularityTextual, List<Imp> imps) {
        boolean hasAllMediaTypes = Ortb2ImplicitParametersResolver.checkExistingMediaTypes((ExtMediaTypePriceGranularity)targeting.getMediatypepricegranularity()).containsAll(Ortb2ImplicitParametersResolver.getImpMediaTypes(imps));
        if (isPriceGranularityNull && !hasAllMediaTypes) {
            return this.mapper.mapper().valueToTree((Object)ExtPriceGranularity.from((PriceGranularity)PriceGranularity.DEFAULT));
        }
        JsonNode priceGranularityNode = targeting.getPricegranularity();
        if (isPriceGranularityTextual) {
            PriceGranularity priceGranularity;
            try {
                priceGranularity = PriceGranularity.createFromString((String)priceGranularityNode.textValue());
            }
            catch (PreBidException e) {
                throw new InvalidRequestException(e.getMessage());
            }
            return this.mapper.mapper().valueToTree((Object)ExtPriceGranularity.from((PriceGranularity)priceGranularity));
        }
        return priceGranularityNode;
    }

    private static Set<BidType> checkExistingMediaTypes(ExtMediaTypePriceGranularity mediaTypePriceGranularity) {
        ObjectNode xNative;
        ObjectNode video;
        if (mediaTypePriceGranularity == null) {
            return Collections.emptySet();
        }
        HashSet<BidType> priceGranularityTypes = new HashSet<BidType>();
        ObjectNode banner = mediaTypePriceGranularity.getBanner();
        if (banner != null && !banner.isNull()) {
            priceGranularityTypes.add(BidType.banner);
        }
        if ((video = mediaTypePriceGranularity.getVideo()) != null && !video.isNull()) {
            priceGranularityTypes.add(BidType.video);
        }
        if ((xNative = mediaTypePriceGranularity.getXNative()) != null && !xNative.isNull()) {
            priceGranularityTypes.add(BidType.xNative);
        }
        return priceGranularityTypes;
    }

    private ExtRequestPrebidCache cacheOrNull(ExtRequestPrebid prebid) {
        Boolean cacheWinningOnly;
        ExtRequestPrebidCache cache = prebid != null ? prebid.getCache() : null;
        Boolean bl = cacheWinningOnly = cache != null ? cache.getWinningonly() : null;
        if (cacheWinningOnly == null && this.shouldCacheOnlyWinningBids) {
            return ExtRequestPrebidCache.of((ExtRequestPrebidCacheBids)((ExtRequestPrebidCacheBids)ObjectUtil.getIfNotNull((Object)cache, ExtRequestPrebidCache::getBids)), (ExtRequestPrebidCacheVastxml)((ExtRequestPrebidCacheVastxml)ObjectUtil.getIfNotNull((Object)cache, ExtRequestPrebidCache::getVastxml)), (Boolean)true);
        }
        return null;
    }

    private ExtRequestPrebidChannel channelOrNull(ExtRequestPrebid prebid, BidRequest bidRequest, String endpoint) {
        ExtRequestPrebidChannel channel = (ExtRequestPrebidChannel)ObjectUtil.getIfNotNull((Object)prebid, ExtRequestPrebid::getChannel);
        String channelName = (String)ObjectUtil.getIfNotNull((Object)channel, ExtRequestPrebidChannel::getName);
        if (channel != null && StringUtils.isBlank((CharSequence)channelName)) {
            throw new PreBidException("ext.prebid.channel.name can't be empty");
        }
        return channel == null ? Ortb2ImplicitParametersResolver.populateChannel((BidRequest)bidRequest, (String)endpoint) : null;
    }

    private static ExtRequestPrebidChannel populateChannel(BidRequest bidRequest, String endpoint) {
        if (StringUtils.equals((CharSequence)Endpoint.openrtb2_amp.value(), (CharSequence)endpoint)) {
            return ExtRequestPrebidChannel.of((String)"amp");
        }
        if (bidRequest.getApp() != null) {
            return ExtRequestPrebidChannel.of((String)"app");
        }
        if (bidRequest.getSite() != null) {
            return ExtRequestPrebidChannel.of((String)"web");
        }
        if (bidRequest.getDooh() != null) {
            return ExtRequestPrebidChannel.of((String)"dooh");
        }
        return null;
    }

    private static Integer resolveAt(Integer at) {
        return at == null || at == 0 ? Integer.valueOf(1) : null;
    }

    private List<String> resolveCurrencies(List<String> currencies) {
        return CollectionUtils.isEmpty(currencies) ? Collections.singletonList(this.adServerCurrency) : null;
    }

    private Long resolveTmax(Long requestTimeout) {
        long timeout = this.timeoutResolver.limitToMax(requestTimeout);
        return !Objects.equals(requestTimeout, timeout) ? Long.valueOf(timeout) : null;
    }
}

