/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.requestfactory;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Regs;
import io.vertx.core.Future;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.prebid.server.auction.DebugResolver;
import org.prebid.server.auction.ImplicitParametersExtractor;
import org.prebid.server.auction.InterstitialProcessor;
import org.prebid.server.auction.OrtbTypesResolver;
import org.prebid.server.auction.PrivacyEnforcementService;
import org.prebid.server.auction.StoredRequestProcessor;
import org.prebid.server.auction.gpp.AuctionGppService;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.auction.model.AuctionStoredResult;
import org.prebid.server.auction.requestfactory.Ortb2ImplicitParametersResolver;
import org.prebid.server.auction.requestfactory.Ortb2RequestFactory;
import org.prebid.server.auction.versionconverter.BidRequestOrtbVersionConversionManager;
import org.prebid.server.exception.InvalidRequestException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.metric.MetricName;
import org.prebid.server.model.Endpoint;
import org.prebid.server.model.HttpRequestContext;
import org.prebid.server.proto.openrtb.ext.request.ExtRegs;
import org.prebid.server.settings.model.Account;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuctionRequestFactory {
    private final long maxRequestSize;
    private final Ortb2RequestFactory ortb2RequestFactory;
    private final StoredRequestProcessor storedRequestProcessor;
    private final BidRequestOrtbVersionConversionManager ortbVersionConversionManager;
    private final AuctionGppService gppService;
    private final ImplicitParametersExtractor paramsExtractor;
    private final Ortb2ImplicitParametersResolver paramsResolver;
    private final InterstitialProcessor interstitialProcessor;
    private final PrivacyEnforcementService privacyEnforcementService;
    private final DebugResolver debugResolver;
    private final JacksonMapper mapper;
    private final OrtbTypesResolver ortbTypesResolver;
    private static final String ENDPOINT = Endpoint.openrtb2_auction.value();

    public AuctionRequestFactory(long maxRequestSize, Ortb2RequestFactory ortb2RequestFactory, StoredRequestProcessor storedRequestProcessor, BidRequestOrtbVersionConversionManager ortbVersionConversionManager, AuctionGppService gppService, ImplicitParametersExtractor paramsExtractor, Ortb2ImplicitParametersResolver paramsResolver, InterstitialProcessor interstitialProcessor, OrtbTypesResolver ortbTypesResolver, PrivacyEnforcementService privacyEnforcementService, DebugResolver debugResolver, JacksonMapper mapper) {
        this.maxRequestSize = maxRequestSize;
        this.ortb2RequestFactory = Objects.requireNonNull(ortb2RequestFactory);
        this.storedRequestProcessor = Objects.requireNonNull(storedRequestProcessor);
        this.ortbVersionConversionManager = Objects.requireNonNull(ortbVersionConversionManager);
        this.gppService = Objects.requireNonNull(gppService);
        this.paramsExtractor = Objects.requireNonNull(paramsExtractor);
        this.paramsResolver = Objects.requireNonNull(paramsResolver);
        this.interstitialProcessor = Objects.requireNonNull(interstitialProcessor);
        this.ortbTypesResolver = Objects.requireNonNull(ortbTypesResolver);
        this.privacyEnforcementService = Objects.requireNonNull(privacyEnforcementService);
        this.debugResolver = Objects.requireNonNull(debugResolver);
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Future<AuctionContext> fromRequest(RoutingContext routingContext, long startTime) {
        String body;
        try {
            body = this.extractAndValidateBody(routingContext);
        }
        catch (InvalidRequestException e) {
            return Future.failedFuture((Throwable)e);
        }
        AuctionContext initialAuctionContext = this.ortb2RequestFactory.createAuctionContext(Endpoint.openrtb2_auction, MetricName.openrtb2web);
        return this.ortb2RequestFactory.executeEntrypointHooks(routingContext, body, initialAuctionContext).compose(httpRequest -> this.parseBidRequest(httpRequest, initialAuctionContext.getPrebidErrors()).map(bidRequest -> this.ortb2RequestFactory.enrichAuctionContext(initialAuctionContext, httpRequest, bidRequest, startTime).with(AuctionRequestFactory.requestTypeMetric((BidRequest)bidRequest)))).compose(auctionContext -> this.ortb2RequestFactory.fetchAccount(auctionContext).map(arg_0 -> ((AuctionContext)auctionContext).with(arg_0))).map(auctionContext -> auctionContext.with(this.debugResolver.debugContextFrom(auctionContext))).compose(auctionContext -> this.gppService.contextFrom(auctionContext).map(arg_0 -> ((AuctionContext)auctionContext).with(arg_0))).compose(auctionContext -> this.ortb2RequestFactory.activityInfrastructureFrom(auctionContext).map(arg_0 -> ((AuctionContext)auctionContext).with(arg_0))).compose(auctionContext -> this.ortb2RequestFactory.executeRawAuctionRequestHooks(auctionContext).map(arg_0 -> ((AuctionContext)auctionContext).with(arg_0))).compose(auctionContext -> this.updateAndValidateBidRequest(auctionContext).map(arg_0 -> ((AuctionContext)auctionContext).with(arg_0))).compose(auctionContext -> this.privacyEnforcementService.contextFromBidRequest(auctionContext).map(arg_0 -> ((AuctionContext)auctionContext).with(arg_0))).map(auctionContext -> auctionContext.with(this.ortb2RequestFactory.enrichBidRequestWithAccountAndPrivacyData(auctionContext))).compose(auctionContext -> this.ortb2RequestFactory.executeProcessedAuctionRequestHooks(auctionContext).map(arg_0 -> ((AuctionContext)auctionContext).with(arg_0))).compose(arg_0 -> ((Ortb2RequestFactory)this.ortb2RequestFactory).populateUserAdditionalInfo(arg_0)).map(arg_0 -> ((Ortb2RequestFactory)this.ortb2RequestFactory).enrichWithPriceFloors(arg_0)).map(auctionContext -> this.ortb2RequestFactory.updateTimeout(auctionContext, startTime)).recover(arg_0 -> ((Ortb2RequestFactory)this.ortb2RequestFactory).restoreResultFromRejection(arg_0));
    }

    private String extractAndValidateBody(RoutingContext routingContext) {
        String body = routingContext.getBodyAsString();
        if (body == null) {
            throw new InvalidRequestException("Incoming request has no body");
        }
        if ((long)body.length() > this.maxRequestSize) {
            throw new InvalidRequestException("Request size exceeded max size of %d bytes.".formatted(this.maxRequestSize));
        }
        return body;
    }

    private Future<BidRequest> parseBidRequest(HttpRequestContext httpRequest, List<String> errors) {
        try {
            JsonNode bidRequestNode = this.bodyAsJsonNode(httpRequest.getBody());
            String referer = this.paramsExtractor.refererFrom(httpRequest);
            this.ortbTypesResolver.normalizeBidRequest(bidRequestNode, errors, referer);
            return Future.succeededFuture((Object)this.jsonNodeAsBidRequest(bidRequestNode)).map(bidRequest -> this.fillWithValuesFromHttpRequest(bidRequest, httpRequest));
        }
        catch (Exception e) {
            return Future.failedFuture((Throwable)e);
        }
    }

    private JsonNode bodyAsJsonNode(String body) {
        try {
            return this.mapper.mapper().readTree(body);
        }
        catch (IOException e) {
            throw new InvalidRequestException("Error decoding bidRequest: " + e.getMessage());
        }
    }

    private BidRequest jsonNodeAsBidRequest(JsonNode bidRequestNode) {
        try {
            return (BidRequest)this.mapper.mapper().treeToValue((TreeNode)bidRequestNode, BidRequest.class);
        }
        catch (JsonProcessingException e) {
            throw new InvalidRequestException("Error decoding bidRequest: " + e.getMessage());
        }
    }

    private BidRequest fillWithValuesFromHttpRequest(BidRequest bidRequest, HttpRequestContext httpRequest) {
        return !this.containsRegsExtGpc(bidRequest) ? bidRequest.toBuilder().regs(this.fillRegsWithValuesFromHttpRequest(bidRequest.getRegs(), httpRequest)).build() : bidRequest;
    }

    private boolean containsRegsExtGpc(BidRequest bidRequest) {
        return Optional.ofNullable(bidRequest.getRegs()).map(Regs::getExt).map(ExtRegs::getGpc).isPresent();
    }

    private Regs fillRegsWithValuesFromHttpRequest(Regs regs, HttpRequestContext httpRequest) {
        String gpc = this.paramsExtractor.gpcFrom(httpRequest);
        if (gpc == null) {
            return regs;
        }
        ExtRegs extRegs = regs != null ? regs.getExt() : null;
        return (regs != null ? regs.toBuilder() : Regs.builder()).ext(ExtRegs.of((Integer)(extRegs != null ? extRegs.getGdpr() : null), (String)(extRegs != null ? extRegs.getUsPrivacy() : null), (String)gpc)).build();
    }

    private Future<BidRequest> updateAndValidateBidRequest(AuctionContext auctionContext) {
        Account account = auctionContext.getAccount();
        List debugWarnings = auctionContext.getDebugWarnings();
        return this.storedRequestProcessor.processAuctionRequest(account.getId(), auctionContext.getBidRequest()).compose(auctionStoredResult -> this.updateBidRequest(auctionStoredResult, auctionContext)).compose(bidRequest -> this.ortb2RequestFactory.validateRequest(bidRequest, auctionContext.getHttpRequest(), debugWarnings)).map(arg_0 -> ((InterstitialProcessor)this.interstitialProcessor).process(arg_0));
    }

    private Future<BidRequest> updateBidRequest(AuctionStoredResult auctionStoredResult, AuctionContext auctionContext) {
        boolean hasStoredBidRequest = auctionStoredResult.hasStoredBidRequest();
        return Future.succeededFuture((Object)auctionStoredResult.bidRequest()).map(arg_0 -> ((BidRequestOrtbVersionConversionManager)this.ortbVersionConversionManager).convertToAuctionSupportedVersion(arg_0)).map(bidRequest -> this.gppService.updateBidRequest(bidRequest, auctionContext)).map(bidRequest -> this.paramsResolver.resolve(bidRequest, auctionContext.getHttpRequest(), ENDPOINT, hasStoredBidRequest));
    }

    private static MetricName requestTypeMetric(BidRequest bidRequest) {
        if (bidRequest.getApp() != null) {
            return MetricName.openrtb2app;
        }
        if (bidRequest.getDooh() != null) {
            return MetricName.openrtb2dooh;
        }
        return MetricName.openrtb2web;
    }
}

