/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.requestfactory;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Publisher;
import com.iab.openrtb.request.Regs;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.User;
import io.vertx.core.Future;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.auction.DebugResolver;
import org.prebid.server.auction.FpdResolver;
import org.prebid.server.auction.ImplicitParametersExtractor;
import org.prebid.server.auction.OrtbTypesResolver;
import org.prebid.server.auction.PriceGranularity;
import org.prebid.server.auction.StoredRequestProcessor;
import org.prebid.server.auction.gpp.AmpGppService;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.auction.model.ConsentType;
import org.prebid.server.auction.privacycontextfactory.AmpPrivacyContextFactory;
import org.prebid.server.auction.requestfactory.AmpRequestFactory;
import org.prebid.server.auction.requestfactory.Ortb2ImplicitParametersResolver;
import org.prebid.server.auction.requestfactory.Ortb2RequestFactory;
import org.prebid.server.auction.versionconverter.BidRequestOrtbVersionConversionManager;
import org.prebid.server.exception.InvalidRequestException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.metric.MetricName;
import org.prebid.server.model.CaseInsensitiveMultiMap;
import org.prebid.server.model.Endpoint;
import org.prebid.server.model.HttpRequestContext;
import org.prebid.server.privacy.ccpa.Ccpa;
import org.prebid.server.privacy.gdpr.TcfDefinerService;
import org.prebid.server.proto.openrtb.ext.request.ConsentedProvidersSettings;
import org.prebid.server.proto.openrtb.ext.request.ExtMediaTypePriceGranularity;
import org.prebid.server.proto.openrtb.ext.request.ExtPriceGranularity;
import org.prebid.server.proto.openrtb.ext.request.ExtRegs;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidAmp;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidCache;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidCacheBids;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidCacheVastxml;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestTargeting;
import org.prebid.server.proto.openrtb.ext.request.ExtSite;
import org.prebid.server.proto.openrtb.ext.request.ExtStoredRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtUser;
import org.prebid.server.proto.request.Targeting;
import org.prebid.server.settings.model.Account;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class AmpRequestFactory {
    private static final String TAG_ID_REQUEST_PARAM = "tag_id";
    private static final String TARGETING_REQUEST_PARAM = "targeting";
    private static final String DEBUG_REQUEST_PARAM = "debug";
    private static final String OW_REQUEST_PARAM = "ow";
    private static final String OH_REQUEST_PARAM = "oh";
    private static final String W_REQUEST_PARAM = "w";
    private static final String H_REQUEST_PARAM = "h";
    private static final String MS_REQUEST_PARAM = "ms";
    private static final String CURL_REQUEST_PARAM = "curl";
    private static final String ACCOUNT_REQUEST_PARAM = "account";
    private static final String SLOT_REQUEST_PARAM = "slot";
    private static final String TIMEOUT_REQUEST_PARAM = "timeout";
    private static final String GDPR_CONSENT_PARAM = "gdpr_consent";
    private static final String CONSENT_STRING_PARAM = "consent_string";
    private static final String GDPR_APPLIES_PARAM = "gdpr_applies";
    private static final String CONSENT_TYPE_PARAM = "consent_type";
    private static final String ADDTL_CONSENT_PARAM = "addtl_consent";
    private static final String GPP_SID_PARAM = "gpp_sid";
    private static final int NO_LIMIT_SPLIT_MODE = -1;
    private static final String ENDPOINT = Endpoint.openrtb2_amp.value();
    private final Ortb2RequestFactory ortb2RequestFactory;
    private final StoredRequestProcessor storedRequestProcessor;
    private final BidRequestOrtbVersionConversionManager ortbVersionConversionManager;
    private final AmpGppService gppService;
    private final OrtbTypesResolver ortbTypesResolver;
    private final ImplicitParametersExtractor implicitParametersExtractor;
    private final Ortb2ImplicitParametersResolver paramsResolver;
    private final FpdResolver fpdResolver;
    private final AmpPrivacyContextFactory ampPrivacyContextFactory;
    private final DebugResolver debugResolver;
    private final JacksonMapper mapper;

    public AmpRequestFactory(Ortb2RequestFactory ortb2RequestFactory, StoredRequestProcessor storedRequestProcessor, BidRequestOrtbVersionConversionManager ortbVersionConversionManager, AmpGppService gppService, OrtbTypesResolver ortbTypesResolver, ImplicitParametersExtractor implicitParametersExtractor, Ortb2ImplicitParametersResolver paramsResolver, FpdResolver fpdResolver, AmpPrivacyContextFactory ampPrivacyContextFactory, DebugResolver debugResolver, JacksonMapper mapper) {
        this.ortb2RequestFactory = Objects.requireNonNull(ortb2RequestFactory);
        this.storedRequestProcessor = Objects.requireNonNull(storedRequestProcessor);
        this.ortbVersionConversionManager = Objects.requireNonNull(ortbVersionConversionManager);
        this.gppService = Objects.requireNonNull(gppService);
        this.ortbTypesResolver = Objects.requireNonNull(ortbTypesResolver);
        this.implicitParametersExtractor = Objects.requireNonNull(implicitParametersExtractor);
        this.paramsResolver = Objects.requireNonNull(paramsResolver);
        this.fpdResolver = Objects.requireNonNull(fpdResolver);
        this.debugResolver = Objects.requireNonNull(debugResolver);
        this.ampPrivacyContextFactory = Objects.requireNonNull(ampPrivacyContextFactory);
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Future<AuctionContext> fromRequest(RoutingContext routingContext, long startTime) {
        String body = routingContext.getBodyAsString();
        AuctionContext initialAuctionContext = this.ortb2RequestFactory.createAuctionContext(Endpoint.openrtb2_amp, MetricName.amp);
        return this.ortb2RequestFactory.executeEntrypointHooks(routingContext, body, initialAuctionContext).compose(httpRequest -> this.parseBidRequest(initialAuctionContext, httpRequest).map(bidRequest -> this.ortb2RequestFactory.enrichAuctionContext(initialAuctionContext, httpRequest, bidRequest, startTime))).compose(auctionContext -> this.ortb2RequestFactory.fetchAccount(auctionContext).map(arg_0 -> ((AuctionContext)auctionContext).with(arg_0))).map(auctionContext -> auctionContext.with(this.debugResolver.debugContextFrom(auctionContext))).compose(auctionContext -> this.gppService.contextFrom(auctionContext).map(arg_0 -> ((AuctionContext)auctionContext).with(arg_0))).compose(auctionContext -> this.ortb2RequestFactory.activityInfrastructureFrom(auctionContext).map(arg_0 -> ((AuctionContext)auctionContext).with(arg_0))).compose(auctionContext -> this.updateBidRequest(auctionContext).map(arg_0 -> ((AuctionContext)auctionContext).with(arg_0))).compose(auctionContext -> this.ampPrivacyContextFactory.contextFrom(auctionContext).map(arg_0 -> ((AuctionContext)auctionContext).with(arg_0))).map(auctionContext -> auctionContext.with(this.ortb2RequestFactory.enrichBidRequestWithAccountAndPrivacyData(auctionContext))).compose(auctionContext -> this.ortb2RequestFactory.executeProcessedAuctionRequestHooks(auctionContext).map(arg_0 -> ((AuctionContext)auctionContext).with(arg_0))).compose(arg_0 -> ((Ortb2RequestFactory)this.ortb2RequestFactory).populateUserAdditionalInfo(arg_0)).map(arg_0 -> ((Ortb2RequestFactory)this.ortb2RequestFactory).enrichWithPriceFloors(arg_0)).map(auctionContext -> this.ortb2RequestFactory.updateTimeout(auctionContext, startTime)).recover(arg_0 -> ((Ortb2RequestFactory)this.ortb2RequestFactory).restoreResultFromRejection(arg_0));
    }

    private Future<BidRequest> parseBidRequest(AuctionContext auctionContext, HttpRequestContext httpRequest) {
        String tagId = httpRequest.getQueryParams().get("tag_id");
        if (StringUtils.isBlank((CharSequence)tagId)) {
            return Future.failedFuture((Throwable)new InvalidRequestException("AMP requests require an AMP tag_id"));
        }
        ConsentParam consentParam = AmpRequestFactory.consentParamFromQueryStringParams((HttpRequestContext)httpRequest);
        List consentParamValidationErrors = this.validateConsentParam(consentParam);
        auctionContext.getPrebidErrors().addAll(consentParamValidationErrors);
        String addtlConsent = AmpRequestFactory.addtlConsentFromQueryStringParams((HttpRequestContext)httpRequest);
        Integer gdpr = AmpRequestFactory.gdprFromQueryStringParams((HttpRequestContext)httpRequest);
        GppSidExtraction gppSidExtraction = AmpRequestFactory.gppSidFromQueryStringParams((HttpRequestContext)httpRequest);
        String gpc = this.implicitParametersExtractor.gpcFrom(httpRequest);
        Integer debug = AmpRequestFactory.debugFromQueryStringParam((HttpRequestContext)httpRequest);
        Long timeout = AmpRequestFactory.timeoutFromQueryString((HttpRequestContext)httpRequest);
        BidRequest bidRequest = BidRequest.builder().site(AmpRequestFactory.createSite((HttpRequestContext)httpRequest)).user(AmpRequestFactory.createUser((ConsentParam)consentParam, (String)addtlConsent)).regs(AmpRequestFactory.createRegs((ConsentParam)consentParam, (GppSidExtraction)gppSidExtraction, (Integer)gdpr, (String)gpc)).test(debug).tmax(timeout).ext(AmpRequestFactory.createExt((HttpRequestContext)httpRequest, (String)tagId, (Integer)debug)).build();
        return Future.succeededFuture((Object)bidRequest);
    }

    private static ConsentParam consentParamFromQueryStringParams(HttpRequestContext httpRequest) {
        ConsentType specifiedConsentType = ConsentType.from((String)httpRequest.getQueryParams().get("consent_type"));
        CaseInsensitiveMultiMap queryParams = httpRequest.getQueryParams();
        String consentStringParam = queryParams.get("consent_string");
        String gdprConsentParam = queryParams.get("gdpr_consent");
        return StringUtils.isNotBlank((CharSequence)consentStringParam) ? AmpRequestFactory.toConsentParam((String)consentStringParam, (String)"consent_string", (ConsentType)specifiedConsentType) : AmpRequestFactory.toConsentParam((String)gdprConsentParam, (String)"gdpr_consent", (ConsentType)specifiedConsentType);
    }

    private static ConsentParam toConsentParam(String consent, String fromParam, ConsentType specifiedConsentType) {
        return ConsentParam.of((String)consent, (String)fromParam, (ConsentType)specifiedConsentType, (boolean)TcfDefinerService.isConsentStringValid((String)consent), (boolean)Ccpa.isValid((String)consent));
    }

    private List<String> validateConsentParam(ConsentParam consentParam) {
        ArrayList<String> errors = new ArrayList<String>();
        if (consentParam.getSpecifiedType() == ConsentType.UNKNOWN) {
            errors.add("Invalid consent_type param passed");
        }
        if (!consentParam.isValid() && consentParam.isConsentStringPresent()) {
            errors.add("Amp request parameter " + consentParam.getSourceParam() + " has invalid format: " + consentParam.getConsentString());
        }
        return errors;
    }

    private static Site createSite(HttpRequestContext httpRequest) {
        String accountId = StringUtils.trimToNull((String)httpRequest.getQueryParams().get("account"));
        String canonicalUrl = StringUtils.trimToNull((String)AmpRequestFactory.canonicalUrl((HttpRequestContext)httpRequest));
        String domain = StringUtils.trimToNull((String)HttpUtil.getHostFromUrl((String)canonicalUrl));
        return !StringUtils.isAllBlank((CharSequence[])new CharSequence[]{accountId, canonicalUrl, domain}) ? Site.builder().publisher(Publisher.builder().id(accountId).build()).page(canonicalUrl).domain(domain).build() : null;
    }

    private static User createUser(ConsentParam consentParam, String addtlConsent) {
        String consent;
        String string = consent = consentParam.isTcfCompatible() ? consentParam.getConsentString() : null;
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{addtlConsent, consent})) {
            return null;
        }
        ConsentedProvidersSettings consentedProvidersSettings = StringUtils.isNotBlank((CharSequence)addtlConsent) ? ConsentedProvidersSettings.of((String)addtlConsent) : null;
        ExtUser extUser = consentedProvidersSettings != null ? ExtUser.builder().consentedProvidersSettings(consentedProvidersSettings).build() : null;
        return User.builder().consent(consent).ext(extUser).build();
    }

    private static Regs createRegs(ConsentParam consentParam, GppSidExtraction gppSidExtraction, Integer gdpr, String gpc) {
        String gpp;
        String usPrivacy = consentParam.isCcpaCompatible() ? consentParam.getConsentString() : null;
        boolean isSuccessGppSidExtraction = gppSidExtraction.isSuccessExtraction();
        List gppSid = isSuccessGppSidExtraction ? gppSidExtraction.getGppSid() : null;
        String string = gpp = isSuccessGppSidExtraction && consentParam.isGppCompatible() ? consentParam.getConsentString() : null;
        return gdpr != null || usPrivacy != null || gppSid != null || gpp != null || gpc != null ? Regs.builder().gdpr(gdpr).usPrivacy(usPrivacy).gppSid(gppSid).gpp(gpp).ext(gpc != null ? ExtRegs.of(null, null, (String)gpc) : null).build() : null;
    }

    private static ExtRequest createExt(HttpRequestContext httpRequest, String tagId, Integer debug) {
        return ExtRequest.of((ExtRequestPrebid)ExtRequestPrebid.builder().storedrequest(ExtStoredRequest.of((String)tagId)).amp(ExtRequestPrebidAmp.of((Map)AmpRequestFactory.ampDataFromQueryString((HttpRequestContext)httpRequest))).debug(debug).build());
    }

    private static Integer debugFromQueryStringParam(HttpRequestContext httpRequest) {
        String debug = httpRequest.getQueryParams().get("debug");
        return Objects.equals(debug, "1") ? Integer.valueOf(1) : (Objects.equals(debug, "0") ? Integer.valueOf(0) : null);
    }

    private static String canonicalUrl(HttpRequestContext httpRequest) {
        try {
            return HttpUtil.decodeUrl((String)httpRequest.getQueryParams().get("curl"));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static String addtlConsentFromQueryStringParams(HttpRequestContext httpRequest) {
        return httpRequest.getQueryParams().get("addtl_consent");
    }

    private static Integer gdprFromQueryStringParams(HttpRequestContext httpRequest) {
        String gdprAppliesParam = httpRequest.getQueryParams().get("gdpr_applies");
        if (StringUtils.equals((CharSequence)gdprAppliesParam, (CharSequence)"true")) {
            return 1;
        }
        if (StringUtils.equals((CharSequence)gdprAppliesParam, (CharSequence)"false")) {
            return 0;
        }
        return null;
    }

    private static GppSidExtraction gppSidFromQueryStringParams(HttpRequestContext httpRequest) {
        String gppSidParam = httpRequest.getQueryParams().get("gpp_sid");
        try {
            List<Integer> gppSid = StringUtils.isNotBlank((CharSequence)gppSidParam) ? Arrays.stream(gppSidParam.split(",")).map(Integer::valueOf).toList() : null;
            return GppSidExtraction.success(gppSid);
        }
        catch (IllegalArgumentException e) {
            return GppSidExtraction.failed();
        }
    }

    private static Long timeoutFromQueryString(HttpRequestContext httpRequest) {
        long timeout;
        String timeoutQueryParam = httpRequest.getQueryParams().get("timeout");
        if (timeoutQueryParam == null) {
            return null;
        }
        try {
            timeout = Long.parseLong(timeoutQueryParam);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return timeout > 0L ? Long.valueOf(timeout) : null;
    }

    private static Map<String, String> ampDataFromQueryString(HttpRequestContext httpRequest) {
        return httpRequest.getQueryParams().entries().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (value1, value2) -> value1));
    }

    private Future<BidRequest> updateBidRequest(AuctionContext auctionContext) {
        BidRequest receivedBidRequest = auctionContext.getBidRequest();
        String storedRequestId = AmpRequestFactory.storedRequestId((BidRequest)receivedBidRequest);
        if (StringUtils.isBlank((CharSequence)storedRequestId)) {
            return Future.failedFuture((Throwable)new InvalidRequestException("AMP requests require the stored request id in AMP tag_id"));
        }
        Account account = auctionContext.getAccount();
        String accountId = account != null ? account.getId() : null;
        HttpRequestContext httpRequest = auctionContext.getHttpRequest();
        return this.storedRequestProcessor.processAmpRequest(accountId, storedRequestId, receivedBidRequest).map(arg_0 -> ((BidRequestOrtbVersionConversionManager)this.ortbVersionConversionManager).convertToAuctionSupportedVersion(arg_0)).map(bidRequest -> this.gppService.updateBidRequest(bidRequest, auctionContext)).map(bidRequest -> AmpRequestFactory.validateStoredBidRequest((String)storedRequestId, (BidRequest)bidRequest)).map(arg_0 -> this.fillExplicitParameters(arg_0)).map(bidRequest -> this.overrideParameters(bidRequest, httpRequest, auctionContext.getPrebidErrors())).map(bidRequest -> this.paramsResolver.resolve(bidRequest, httpRequest, ENDPOINT, true)).compose(resolvedBidRequest -> this.ortb2RequestFactory.validateRequest(resolvedBidRequest, auctionContext.getHttpRequest(), auctionContext.getDebugWarnings()));
    }

    private static String storedRequestId(BidRequest receivedBidRequest) {
        ExtRequest requestExt = receivedBidRequest != null ? receivedBidRequest.getExt() : null;
        ExtRequestPrebid prebid = requestExt != null ? requestExt.getPrebid() : null;
        ExtStoredRequest storedRequest = prebid != null ? prebid.getStoredrequest() : null;
        return storedRequest != null ? storedRequest.getId() : null;
    }

    private static BidRequest validateStoredBidRequest(String tagId, BidRequest bidRequest) {
        List imps = bidRequest.getImp();
        if (CollectionUtils.isEmpty((Collection)imps)) {
            throw new InvalidRequestException("data for tag_id='%s' does not define the required imp array.".formatted(tagId));
        }
        int impSize = imps.size();
        if (impSize > 1) {
            throw new InvalidRequestException("data for tag_id '%s' includes %d imp elements. Only one is allowed".formatted(tagId, impSize));
        }
        if (bidRequest.getApp() != null) {
            throw new InvalidRequestException("request.app must not exist in AMP stored requests.");
        }
        if (bidRequest.getDooh() != null) {
            throw new InvalidRequestException("request.dooh must not exist in AMP stored requests.");
        }
        return bidRequest;
    }

    private BidRequest fillExplicitParameters(BidRequest bidRequest) {
        boolean setDefaultCache;
        boolean setDefaultTargeting;
        List<Imp> imps = bidRequest.getImp();
        Imp imp = (Imp)imps.get(0);
        Integer secure = imp.getSecure();
        boolean setSecure = secure == null || secure != 1;
        ExtRequestPrebid prebid = bidRequest.getExt().getPrebid();
        if (prebid == null) {
            setDefaultTargeting = true;
            setDefaultCache = true;
        } else {
            ExtRequestTargeting targeting = prebid.getTargeting();
            setDefaultTargeting = targeting == null || targeting.getIncludewinners() == null || targeting.getIncludebidderkeys() == null || targeting.getPricegranularity() == null || targeting.getPricegranularity().isNull();
            ExtRequestPrebidCache cache = prebid.getCache();
            boolean bl = setDefaultCache = cache == null || cache.equals((Object)ExtRequestPrebidCache.EMPTY);
        }
        BidRequest result = setSecure || setDefaultTargeting || setDefaultCache ? bidRequest.toBuilder().imp((List)(setSecure ? Collections.singletonList(((Imp)imps.get(0)).toBuilder().secure(Integer.valueOf(1)).build()) : imps)).ext(this.extRequest(bidRequest, setDefaultTargeting, setDefaultCache)).build() : bidRequest;
        return result;
    }

    private BidRequest overrideParameters(BidRequest bidRequest, HttpRequestContext httpRequest, List<String> errors) {
        String requestTargeting = httpRequest.getQueryParams().get("targeting");
        ObjectNode targetingNode = this.readTargeting(requestTargeting);
        this.ortbTypesResolver.normalizeTargeting((JsonNode)targetingNode, errors, this.implicitParametersExtractor.refererFrom(httpRequest));
        Targeting targeting = this.parseTargeting(targetingNode);
        Site updatedSite = this.overrideSite(bidRequest.getSite());
        Imp updatedImp = this.overrideImp((Imp)bidRequest.getImp().get(0), httpRequest, targetingNode);
        ExtRequest updatedExtBidRequest = this.overrideExtBidRequest(bidRequest.getExt(), targeting);
        if (ObjectUtils.anyNotNull((Object[])new Object[]{updatedSite, updatedImp, updatedExtBidRequest})) {
            return bidRequest.toBuilder().site(updatedSite != null ? updatedSite : bidRequest.getSite()).imp(updatedImp != null ? Collections.singletonList(updatedImp) : bidRequest.getImp()).ext(updatedExtBidRequest != null ? updatedExtBidRequest : bidRequest.getExt()).build();
        }
        return bidRequest;
    }

    private ObjectNode readTargeting(String jsonTargeting) {
        try {
            String decodedJsonTargeting = HttpUtil.decodeUrl((String)jsonTargeting);
            JsonNode jsonNodeTargeting = decodedJsonTargeting != null ? this.mapper.mapper().readTree(decodedJsonTargeting) : null;
            return jsonNodeTargeting != null ? this.validateAndGetTargeting(jsonNodeTargeting) : null;
        }
        catch (JsonProcessingException | IllegalArgumentException e) {
            throw new InvalidRequestException("Error reading targeting json " + e.getMessage());
        }
    }

    private ObjectNode validateAndGetTargeting(JsonNode jsonNodeTargeting) {
        if (jsonNodeTargeting.isObject()) {
            return (ObjectNode)jsonNodeTargeting;
        }
        throw new InvalidRequestException("Error decoding targeting, expected type is `object` but was " + jsonNodeTargeting.getNodeType().name());
    }

    private Targeting parseTargeting(ObjectNode targetingNode) {
        try {
            return targetingNode == null ? Targeting.empty() : (Targeting)this.mapper.mapper().treeToValue((TreeNode)targetingNode, Targeting.class);
        }
        catch (JsonProcessingException e) {
            throw new InvalidRequestException("Error decoding targeting from url: " + e.getMessage());
        }
    }

    private Site overrideSite(Site site) {
        boolean shouldSetExtAmp;
        boolean hasSite = site != null;
        ExtSite siteExt = hasSite ? site.getExt() : null;
        boolean bl = shouldSetExtAmp = siteExt == null || siteExt.getAmp() == null;
        if (shouldSetExtAmp) {
            Site.SiteBuilder siteBuilder = hasSite ? site.toBuilder() : Site.builder();
            ObjectNode data = siteExt != null ? siteExt.getData() : null;
            siteBuilder.ext(ExtSite.of((Integer)1, (ObjectNode)data));
            return siteBuilder.build();
        }
        return null;
    }

    private Imp overrideImp(Imp imp, HttpRequestContext httpRequest, ObjectNode targetingNode) {
        List overwrittenFormats;
        String tagId = httpRequest.getQueryParams().get("slot");
        Banner banner = imp.getBanner();
        List list = overwrittenFormats = banner != null ? AmpRequestFactory.createOverrideBannerFormats((HttpRequestContext)httpRequest, (List)banner.getFormat()) : null;
        if (StringUtils.isNotBlank((CharSequence)tagId) || CollectionUtils.isNotEmpty((Collection)overwrittenFormats) || targetingNode != null) {
            return imp.toBuilder().tagid(StringUtils.isNotBlank((CharSequence)tagId) ? tagId : imp.getTagid()).banner(AmpRequestFactory.overrideBanner((Banner)imp.getBanner(), (List)overwrittenFormats)).ext(this.fpdResolver.resolveImpExt(imp.getExt(), targetingNode)).build();
        }
        return null;
    }

    private static List<Format> createOverrideBannerFormats(HttpRequestContext httpRequest, List<Format> formats) {
        int overrideWidth = AmpRequestFactory.parseIntParamOrZero((HttpRequestContext)httpRequest, (String)"ow");
        int width = AmpRequestFactory.parseIntParamOrZero((HttpRequestContext)httpRequest, (String)"w");
        int overrideHeight = AmpRequestFactory.parseIntParamOrZero((HttpRequestContext)httpRequest, (String)"oh");
        int height = AmpRequestFactory.parseIntParamOrZero((HttpRequestContext)httpRequest, (String)"h");
        String multiSizeParam = httpRequest.getQueryParams().get("ms");
        List paramsFormats = AmpRequestFactory.createFormatsFromParams((Integer)overrideWidth, (Integer)width, (Integer)overrideHeight, (Integer)height, (String)multiSizeParam);
        return CollectionUtils.isNotEmpty((Collection)paramsFormats) ? paramsFormats : AmpRequestFactory.updateFormatsFromParams(formats, (Integer)width, (Integer)height);
    }

    private static Integer parseIntParamOrZero(HttpRequestContext httpRequest, String name) {
        return AmpRequestFactory.parseIntOrZero((String)httpRequest.getQueryParams().get(name));
    }

    private static Integer parseIntOrZero(String param) {
        try {
            return Integer.parseInt(param);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static List<Format> createFormatsFromParams(Integer overrideWidth, Integer width, Integer overrideHeight, Integer height, String multiSizeParam) {
        List multiSizeFormats;
        ArrayList<Format> formats = new ArrayList<Format>();
        if (overrideWidth != 0 && overrideHeight != 0) {
            formats.add(Format.builder().w(overrideWidth).h(overrideHeight).build());
        } else if (overrideWidth != 0 && height != 0) {
            formats.add(Format.builder().w(overrideWidth).h(height).build());
        } else if (width != 0 && overrideHeight != 0) {
            formats.add(Format.builder().w(width).h(overrideHeight).build());
        } else if (width != 0 && height != 0) {
            formats.add(Format.builder().w(width).h(height).build());
        }
        List list = multiSizeFormats = StringUtils.isNotBlank((CharSequence)multiSizeParam) ? AmpRequestFactory.parseMultiSizeParam((String)multiSizeParam) : Collections.emptyList();
        if (!multiSizeFormats.isEmpty()) {
            formats.addAll(multiSizeFormats);
        }
        return formats;
    }

    private static List<Format> updateFormatsFromParams(List<Format> formats, Integer width, Integer height) {
        List<Format> updatedFormats = width != 0 ? formats.stream().map(format -> Format.builder().w(width).h(format.getH()).build()).toList() : (height != 0 ? formats.stream().map(format -> Format.builder().w(format.getW()).h(height).build()).toList() : Collections.emptyList());
        return updatedFormats;
    }

    private static Banner overrideBanner(Banner banner, List<Format> formats) {
        return banner != null && CollectionUtils.isNotEmpty(formats) ? banner.toBuilder().format(formats).build() : banner;
    }

    private ExtRequest overrideExtBidRequest(ExtRequest extRequest, Targeting targeting) {
        return this.fpdResolver.resolveBidRequestExt(extRequest, targeting);
    }

    private static List<Format> parseMultiSizeParam(String ms) {
        String[] formatStrings = ms.split(",", -1);
        ArrayList<Format> formats = new ArrayList<Format>();
        for (String format : formatStrings) {
            String[] widthHeight = format.split("x", -1);
            if (widthHeight.length != 2) {
                return Collections.emptyList();
            }
            Integer width = AmpRequestFactory.parseIntOrZero((String)widthHeight[0]);
            Integer height = AmpRequestFactory.parseIntOrZero((String)widthHeight[1]);
            if (width == 0 && height == 0) {
                return Collections.emptyList();
            }
            formats.add(Format.builder().w(width).h(height).build());
        }
        return formats;
    }

    private ExtRequest extRequest(BidRequest bidRequest, boolean setDefaultTargeting, boolean setDefaultCache) {
        ExtRequest result;
        if (setDefaultTargeting || setDefaultCache) {
            ExtRequestPrebid.ExtRequestPrebidBuilder prebidBuilder;
            ExtRequest requestExt = bidRequest.getExt();
            ExtRequestPrebid prebid = requestExt != null ? requestExt.getPrebid() : null;
            ExtRequestPrebid.ExtRequestPrebidBuilder extRequestPrebidBuilder = prebidBuilder = prebid != null ? prebid.toBuilder() : ExtRequestPrebid.builder();
            if (setDefaultTargeting) {
                prebidBuilder.targeting(this.createTargetingWithDefaults(prebid));
            }
            if (setDefaultCache) {
                prebidBuilder.cache(ExtRequestPrebidCache.of((ExtRequestPrebidCacheBids)ExtRequestPrebidCacheBids.of(null, null), (ExtRequestPrebidCacheVastxml)ExtRequestPrebidCacheVastxml.of(null, null), null));
            }
            ExtRequest updatedExt = ExtRequest.of((ExtRequestPrebid)prebidBuilder.build());
            if (requestExt != null) {
                updatedExt.addProperties(requestExt.getProperties());
            }
            result = updatedExt;
        } else {
            result = bidRequest.getExt();
        }
        return result;
    }

    private ExtRequestTargeting createTargetingWithDefaults(ExtRequestPrebid prebid) {
        ExtRequestTargeting targeting = prebid != null ? prebid.getTargeting() : null;
        boolean isTargetingNull = targeting == null;
        JsonNode priceGranularityNode = isTargetingNull ? null : targeting.getPricegranularity();
        boolean isPriceGranularityNull = priceGranularityNode == null || priceGranularityNode.isNull();
        JsonNode outgoingPriceGranularityNode = isPriceGranularityNull ? this.mapper.mapper().valueToTree((Object)ExtPriceGranularity.from((PriceGranularity)PriceGranularity.DEFAULT)) : priceGranularityNode;
        ExtMediaTypePriceGranularity mediaTypePriceGranularity = isTargetingNull ? null : targeting.getMediatypepricegranularity();
        boolean includeWinners = isTargetingNull || targeting.getIncludewinners() == null || targeting.getIncludewinners() != false;
        boolean includeBidderKeys = isTargetingNull || targeting.getIncludebidderkeys() == null || targeting.getIncludebidderkeys() != false;
        Boolean includeFormat = !isTargetingNull ? targeting.getIncludeformat() : null;
        return (isTargetingNull ? ExtRequestTargeting.builder() : targeting.toBuilder()).pricegranularity(outgoingPriceGranularityNode).mediatypepricegranularity(mediaTypePriceGranularity).includewinners(Boolean.valueOf(includeWinners)).includebidderkeys(Boolean.valueOf(includeBidderKeys)).includeformat(includeFormat).build();
    }
}

