/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.model;

import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Deal;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import org.prebid.server.auction.model.BidderRequest;
import org.prebid.server.auction.versionconverter.OrtbVersion;

public final class BidderRequest {
    private final String bidder;
    private final OrtbVersion ortbVersion;
    private final String storedResponse;
    private final Map<String, List<Deal>> impIdToDeals;
    private final BidRequest bidRequest;

    public BidderRequest with(BidRequest bidRequest) {
        return this.toBuilder().bidRequest(bidRequest).build();
    }

    @ConstructorProperties(value={"bidder", "ortbVersion", "storedResponse", "impIdToDeals", "bidRequest"})
    BidderRequest(String bidder, OrtbVersion ortbVersion, String storedResponse, Map<String, List<Deal>> impIdToDeals, BidRequest bidRequest) {
        this.bidder = bidder;
        this.ortbVersion = ortbVersion;
        this.storedResponse = storedResponse;
        this.impIdToDeals = impIdToDeals;
        this.bidRequest = bidRequest;
    }

    public static BidderRequestBuilder builder() {
        return new BidderRequestBuilder();
    }

    public BidderRequestBuilder toBuilder() {
        return new BidderRequestBuilder().bidder(this.bidder).ortbVersion(this.ortbVersion).storedResponse(this.storedResponse).impIdToDeals(this.impIdToDeals).bidRequest(this.bidRequest);
    }

    public String getBidder() {
        return this.bidder;
    }

    public OrtbVersion getOrtbVersion() {
        return this.ortbVersion;
    }

    public String getStoredResponse() {
        return this.storedResponse;
    }

    public Map<String, List<Deal>> getImpIdToDeals() {
        return this.impIdToDeals;
    }

    public BidRequest getBidRequest() {
        return this.bidRequest;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BidderRequest)) {
            return false;
        }
        BidderRequest other = (BidderRequest)o;
        String this$bidder = this.getBidder();
        String other$bidder = other.getBidder();
        if (this$bidder == null ? other$bidder != null : !this$bidder.equals(other$bidder)) {
            return false;
        }
        OrtbVersion this$ortbVersion = this.getOrtbVersion();
        OrtbVersion other$ortbVersion = other.getOrtbVersion();
        if (this$ortbVersion == null ? other$ortbVersion != null : !this$ortbVersion.equals(other$ortbVersion)) {
            return false;
        }
        String this$storedResponse = this.getStoredResponse();
        String other$storedResponse = other.getStoredResponse();
        if (this$storedResponse == null ? other$storedResponse != null : !this$storedResponse.equals(other$storedResponse)) {
            return false;
        }
        Map this$impIdToDeals = this.getImpIdToDeals();
        Map other$impIdToDeals = other.getImpIdToDeals();
        if (this$impIdToDeals == null ? other$impIdToDeals != null : !((Object)this$impIdToDeals).equals(other$impIdToDeals)) {
            return false;
        }
        BidRequest this$bidRequest = this.getBidRequest();
        BidRequest other$bidRequest = other.getBidRequest();
        return !(this$bidRequest == null ? other$bidRequest != null : !this$bidRequest.equals(other$bidRequest));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $bidder = this.getBidder();
        result = result * 59 + ($bidder == null ? 43 : $bidder.hashCode());
        OrtbVersion $ortbVersion = this.getOrtbVersion();
        result = result * 59 + ($ortbVersion == null ? 43 : $ortbVersion.hashCode());
        String $storedResponse = this.getStoredResponse();
        result = result * 59 + ($storedResponse == null ? 43 : $storedResponse.hashCode());
        Map $impIdToDeals = this.getImpIdToDeals();
        result = result * 59 + ($impIdToDeals == null ? 43 : ((Object)$impIdToDeals).hashCode());
        BidRequest $bidRequest = this.getBidRequest();
        result = result * 59 + ($bidRequest == null ? 43 : $bidRequest.hashCode());
        return result;
    }

    public String toString() {
        return "BidderRequest(bidder=" + this.getBidder() + ", ortbVersion=" + this.getOrtbVersion() + ", storedResponse=" + this.getStoredResponse() + ", impIdToDeals=" + this.getImpIdToDeals() + ", bidRequest=" + this.getBidRequest() + ")";
    }
}

