/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.response.BidResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import org.prebid.server.activity.infrastructure.ActivityInfrastructure;
import org.prebid.server.auction.gpp.model.GppContext;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.auction.model.AuctionParticipation;
import org.prebid.server.auction.model.BidRejectionTracker;
import org.prebid.server.auction.model.CachedDebugLog;
import org.prebid.server.auction.model.debug.DebugContext;
import org.prebid.server.cache.model.DebugHttpCall;
import org.prebid.server.cookie.UidsCookie;
import org.prebid.server.deals.model.DeepDebugLog;
import org.prebid.server.deals.model.TxnLog;
import org.prebid.server.execution.Timeout;
import org.prebid.server.geolocation.model.GeoInfo;
import org.prebid.server.hooks.execution.model.HookExecutionContext;
import org.prebid.server.metric.MetricName;
import org.prebid.server.model.HttpRequestContext;
import org.prebid.server.privacy.model.PrivacyContext;
import org.prebid.server.settings.model.Account;

public final class AuctionContext {
    private final HttpRequestContext httpRequest;
    @JsonIgnore
    private final UidsCookie uidsCookie;
    private final BidRequest bidRequest;
    @JsonIgnore
    private final BidResponse bidResponse;
    @JsonIgnore
    private final List<AuctionParticipation> auctionParticipations;
    @JsonIgnore
    private final long startTime;
    @JsonIgnore
    private final Timeout timeout;
    private final Account account;
    private final MetricName requestTypeMetric;
    private final List<String> prebidErrors;
    private final List<String> debugWarnings;
    private final Map<String, List<DebugHttpCall>> debugHttpCalls;
    private final Map<String, BidRejectionTracker> bidRejectionTrackers;
    private final GppContext gppContext;
    private final PrivacyContext privacyContext;
    private final ActivityInfrastructure activityInfrastructure;
    private final GeoInfo geoInfo;
    private final HookExecutionContext hookExecutionContext;
    private final DebugContext debugContext;
    private final boolean requestRejected;
    @JsonIgnore
    private final TxnLog txnLog;
    @JsonIgnore
    private final DeepDebugLog deepDebugLog;
    private final CachedDebugLog cachedDebugLog;

    public AuctionContext with(Account account) {
        return this.toBuilder().account(account).build();
    }

    public AuctionContext with(BidRequest bidRequest) {
        return this.toBuilder().bidRequest(bidRequest).build();
    }

    public AuctionContext with(BidResponse bidResponse) {
        return this.toBuilder().bidResponse(bidResponse).build();
    }

    public AuctionContext with(List<AuctionParticipation> auctionParticipations) {
        return this.toBuilder().auctionParticipations(auctionParticipations).build();
    }

    public AuctionContext with(MetricName requestTypeMetric) {
        return this.toBuilder().requestTypeMetric(requestTypeMetric).build();
    }

    public AuctionContext with(GppContext gppContext) {
        return this.toBuilder().gppContext(gppContext).build();
    }

    public AuctionContext with(PrivacyContext privacyContext) {
        return this.toBuilder().privacyContext(privacyContext).geoInfo(privacyContext.getTcfContext().getGeoInfo()).build();
    }

    public AuctionContext with(ActivityInfrastructure activityInfrastructure) {
        return this.toBuilder().activityInfrastructure(activityInfrastructure).build();
    }

    public AuctionContext with(DebugContext debugContext) {
        return this.toBuilder().debugContext(debugContext).build();
    }

    public AuctionContext withRequestRejected() {
        return this.toBuilder().requestRejected(true).build();
    }

    @ConstructorProperties(value={"httpRequest", "uidsCookie", "bidRequest", "bidResponse", "auctionParticipations", "startTime", "timeout", "account", "requestTypeMetric", "prebidErrors", "debugWarnings", "debugHttpCalls", "bidRejectionTrackers", "gppContext", "privacyContext", "activityInfrastructure", "geoInfo", "hookExecutionContext", "debugContext", "requestRejected", "txnLog", "deepDebugLog", "cachedDebugLog"})
    AuctionContext(HttpRequestContext httpRequest, UidsCookie uidsCookie, BidRequest bidRequest, BidResponse bidResponse, List<AuctionParticipation> auctionParticipations, long startTime, Timeout timeout, Account account, MetricName requestTypeMetric, List<String> prebidErrors, List<String> debugWarnings, Map<String, List<DebugHttpCall>> debugHttpCalls, Map<String, BidRejectionTracker> bidRejectionTrackers, GppContext gppContext, PrivacyContext privacyContext, ActivityInfrastructure activityInfrastructure, GeoInfo geoInfo, HookExecutionContext hookExecutionContext, DebugContext debugContext, boolean requestRejected, TxnLog txnLog, DeepDebugLog deepDebugLog, CachedDebugLog cachedDebugLog) {
        this.httpRequest = httpRequest;
        this.uidsCookie = uidsCookie;
        this.bidRequest = bidRequest;
        this.bidResponse = bidResponse;
        this.auctionParticipations = auctionParticipations;
        this.startTime = startTime;
        this.timeout = timeout;
        this.account = account;
        this.requestTypeMetric = requestTypeMetric;
        this.prebidErrors = prebidErrors;
        this.debugWarnings = debugWarnings;
        this.debugHttpCalls = debugHttpCalls;
        this.bidRejectionTrackers = bidRejectionTrackers;
        this.gppContext = gppContext;
        this.privacyContext = privacyContext;
        this.activityInfrastructure = activityInfrastructure;
        this.geoInfo = geoInfo;
        this.hookExecutionContext = hookExecutionContext;
        this.debugContext = debugContext;
        this.requestRejected = requestRejected;
        this.txnLog = txnLog;
        this.deepDebugLog = deepDebugLog;
        this.cachedDebugLog = cachedDebugLog;
    }

    public static AuctionContextBuilder builder() {
        return new AuctionContextBuilder();
    }

    public AuctionContextBuilder toBuilder() {
        return new AuctionContextBuilder().httpRequest(this.httpRequest).uidsCookie(this.uidsCookie).bidRequest(this.bidRequest).bidResponse(this.bidResponse).auctionParticipations(this.auctionParticipations).startTime(this.startTime).timeout(this.timeout).account(this.account).requestTypeMetric(this.requestTypeMetric).prebidErrors(this.prebidErrors).debugWarnings(this.debugWarnings).debugHttpCalls(this.debugHttpCalls).bidRejectionTrackers(this.bidRejectionTrackers).gppContext(this.gppContext).privacyContext(this.privacyContext).activityInfrastructure(this.activityInfrastructure).geoInfo(this.geoInfo).hookExecutionContext(this.hookExecutionContext).debugContext(this.debugContext).requestRejected(this.requestRejected).txnLog(this.txnLog).deepDebugLog(this.deepDebugLog).cachedDebugLog(this.cachedDebugLog);
    }

    public HttpRequestContext getHttpRequest() {
        return this.httpRequest;
    }

    public UidsCookie getUidsCookie() {
        return this.uidsCookie;
    }

    public BidRequest getBidRequest() {
        return this.bidRequest;
    }

    public BidResponse getBidResponse() {
        return this.bidResponse;
    }

    public List<AuctionParticipation> getAuctionParticipations() {
        return this.auctionParticipations;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Timeout getTimeout() {
        return this.timeout;
    }

    public Account getAccount() {
        return this.account;
    }

    public MetricName getRequestTypeMetric() {
        return this.requestTypeMetric;
    }

    public List<String> getPrebidErrors() {
        return this.prebidErrors;
    }

    public List<String> getDebugWarnings() {
        return this.debugWarnings;
    }

    public Map<String, List<DebugHttpCall>> getDebugHttpCalls() {
        return this.debugHttpCalls;
    }

    public Map<String, BidRejectionTracker> getBidRejectionTrackers() {
        return this.bidRejectionTrackers;
    }

    public GppContext getGppContext() {
        return this.gppContext;
    }

    public PrivacyContext getPrivacyContext() {
        return this.privacyContext;
    }

    public ActivityInfrastructure getActivityInfrastructure() {
        return this.activityInfrastructure;
    }

    public GeoInfo getGeoInfo() {
        return this.geoInfo;
    }

    public HookExecutionContext getHookExecutionContext() {
        return this.hookExecutionContext;
    }

    public DebugContext getDebugContext() {
        return this.debugContext;
    }

    public boolean isRequestRejected() {
        return this.requestRejected;
    }

    public TxnLog getTxnLog() {
        return this.txnLog;
    }

    public DeepDebugLog getDeepDebugLog() {
        return this.deepDebugLog;
    }

    public CachedDebugLog getCachedDebugLog() {
        return this.cachedDebugLog;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuctionContext)) {
            return false;
        }
        AuctionContext other = (AuctionContext)o;
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        if (this.isRequestRejected() != other.isRequestRejected()) {
            return false;
        }
        HttpRequestContext this$httpRequest = this.getHttpRequest();
        HttpRequestContext other$httpRequest = other.getHttpRequest();
        if (this$httpRequest == null ? other$httpRequest != null : !this$httpRequest.equals(other$httpRequest)) {
            return false;
        }
        UidsCookie this$uidsCookie = this.getUidsCookie();
        UidsCookie other$uidsCookie = other.getUidsCookie();
        if (this$uidsCookie == null ? other$uidsCookie != null : !this$uidsCookie.equals(other$uidsCookie)) {
            return false;
        }
        BidRequest this$bidRequest = this.getBidRequest();
        BidRequest other$bidRequest = other.getBidRequest();
        if (this$bidRequest == null ? other$bidRequest != null : !this$bidRequest.equals(other$bidRequest)) {
            return false;
        }
        BidResponse this$bidResponse = this.getBidResponse();
        BidResponse other$bidResponse = other.getBidResponse();
        if (this$bidResponse == null ? other$bidResponse != null : !this$bidResponse.equals(other$bidResponse)) {
            return false;
        }
        List this$auctionParticipations = this.getAuctionParticipations();
        List other$auctionParticipations = other.getAuctionParticipations();
        if (this$auctionParticipations == null ? other$auctionParticipations != null : !((Object)this$auctionParticipations).equals(other$auctionParticipations)) {
            return false;
        }
        Timeout this$timeout = this.getTimeout();
        Timeout other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !this$timeout.equals(other$timeout)) {
            return false;
        }
        Account this$account = this.getAccount();
        Account other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        MetricName this$requestTypeMetric = this.getRequestTypeMetric();
        MetricName other$requestTypeMetric = other.getRequestTypeMetric();
        if (this$requestTypeMetric == null ? other$requestTypeMetric != null : !this$requestTypeMetric.equals(other$requestTypeMetric)) {
            return false;
        }
        List this$prebidErrors = this.getPrebidErrors();
        List other$prebidErrors = other.getPrebidErrors();
        if (this$prebidErrors == null ? other$prebidErrors != null : !((Object)this$prebidErrors).equals(other$prebidErrors)) {
            return false;
        }
        List this$debugWarnings = this.getDebugWarnings();
        List other$debugWarnings = other.getDebugWarnings();
        if (this$debugWarnings == null ? other$debugWarnings != null : !((Object)this$debugWarnings).equals(other$debugWarnings)) {
            return false;
        }
        Map this$debugHttpCalls = this.getDebugHttpCalls();
        Map other$debugHttpCalls = other.getDebugHttpCalls();
        if (this$debugHttpCalls == null ? other$debugHttpCalls != null : !((Object)this$debugHttpCalls).equals(other$debugHttpCalls)) {
            return false;
        }
        Map this$bidRejectionTrackers = this.getBidRejectionTrackers();
        Map other$bidRejectionTrackers = other.getBidRejectionTrackers();
        if (this$bidRejectionTrackers == null ? other$bidRejectionTrackers != null : !((Object)this$bidRejectionTrackers).equals(other$bidRejectionTrackers)) {
            return false;
        }
        GppContext this$gppContext = this.getGppContext();
        GppContext other$gppContext = other.getGppContext();
        if (this$gppContext == null ? other$gppContext != null : !this$gppContext.equals(other$gppContext)) {
            return false;
        }
        PrivacyContext this$privacyContext = this.getPrivacyContext();
        PrivacyContext other$privacyContext = other.getPrivacyContext();
        if (this$privacyContext == null ? other$privacyContext != null : !this$privacyContext.equals(other$privacyContext)) {
            return false;
        }
        ActivityInfrastructure this$activityInfrastructure = this.getActivityInfrastructure();
        ActivityInfrastructure other$activityInfrastructure = other.getActivityInfrastructure();
        if (this$activityInfrastructure == null ? other$activityInfrastructure != null : !this$activityInfrastructure.equals(other$activityInfrastructure)) {
            return false;
        }
        GeoInfo this$geoInfo = this.getGeoInfo();
        GeoInfo other$geoInfo = other.getGeoInfo();
        if (this$geoInfo == null ? other$geoInfo != null : !this$geoInfo.equals(other$geoInfo)) {
            return false;
        }
        HookExecutionContext this$hookExecutionContext = this.getHookExecutionContext();
        HookExecutionContext other$hookExecutionContext = other.getHookExecutionContext();
        if (this$hookExecutionContext == null ? other$hookExecutionContext != null : !this$hookExecutionContext.equals(other$hookExecutionContext)) {
            return false;
        }
        DebugContext this$debugContext = this.getDebugContext();
        DebugContext other$debugContext = other.getDebugContext();
        if (this$debugContext == null ? other$debugContext != null : !this$debugContext.equals(other$debugContext)) {
            return false;
        }
        TxnLog this$txnLog = this.getTxnLog();
        TxnLog other$txnLog = other.getTxnLog();
        if (this$txnLog == null ? other$txnLog != null : !this$txnLog.equals(other$txnLog)) {
            return false;
        }
        DeepDebugLog this$deepDebugLog = this.getDeepDebugLog();
        DeepDebugLog other$deepDebugLog = other.getDeepDebugLog();
        if (this$deepDebugLog == null ? other$deepDebugLog != null : !this$deepDebugLog.equals(other$deepDebugLog)) {
            return false;
        }
        CachedDebugLog this$cachedDebugLog = this.getCachedDebugLog();
        CachedDebugLog other$cachedDebugLog = other.getCachedDebugLog();
        return !(this$cachedDebugLog == null ? other$cachedDebugLog != null : !this$cachedDebugLog.equals(other$cachedDebugLog));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        result = result * 59 + (this.isRequestRejected() ? 79 : 97);
        HttpRequestContext $httpRequest = this.getHttpRequest();
        result = result * 59 + ($httpRequest == null ? 43 : $httpRequest.hashCode());
        UidsCookie $uidsCookie = this.getUidsCookie();
        result = result * 59 + ($uidsCookie == null ? 43 : $uidsCookie.hashCode());
        BidRequest $bidRequest = this.getBidRequest();
        result = result * 59 + ($bidRequest == null ? 43 : $bidRequest.hashCode());
        BidResponse $bidResponse = this.getBidResponse();
        result = result * 59 + ($bidResponse == null ? 43 : $bidResponse.hashCode());
        List $auctionParticipations = this.getAuctionParticipations();
        result = result * 59 + ($auctionParticipations == null ? 43 : ((Object)$auctionParticipations).hashCode());
        Timeout $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : $timeout.hashCode());
        Account $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        MetricName $requestTypeMetric = this.getRequestTypeMetric();
        result = result * 59 + ($requestTypeMetric == null ? 43 : $requestTypeMetric.hashCode());
        List $prebidErrors = this.getPrebidErrors();
        result = result * 59 + ($prebidErrors == null ? 43 : ((Object)$prebidErrors).hashCode());
        List $debugWarnings = this.getDebugWarnings();
        result = result * 59 + ($debugWarnings == null ? 43 : ((Object)$debugWarnings).hashCode());
        Map $debugHttpCalls = this.getDebugHttpCalls();
        result = result * 59 + ($debugHttpCalls == null ? 43 : ((Object)$debugHttpCalls).hashCode());
        Map $bidRejectionTrackers = this.getBidRejectionTrackers();
        result = result * 59 + ($bidRejectionTrackers == null ? 43 : ((Object)$bidRejectionTrackers).hashCode());
        GppContext $gppContext = this.getGppContext();
        result = result * 59 + ($gppContext == null ? 43 : $gppContext.hashCode());
        PrivacyContext $privacyContext = this.getPrivacyContext();
        result = result * 59 + ($privacyContext == null ? 43 : $privacyContext.hashCode());
        ActivityInfrastructure $activityInfrastructure = this.getActivityInfrastructure();
        result = result * 59 + ($activityInfrastructure == null ? 43 : $activityInfrastructure.hashCode());
        GeoInfo $geoInfo = this.getGeoInfo();
        result = result * 59 + ($geoInfo == null ? 43 : $geoInfo.hashCode());
        HookExecutionContext $hookExecutionContext = this.getHookExecutionContext();
        result = result * 59 + ($hookExecutionContext == null ? 43 : $hookExecutionContext.hashCode());
        DebugContext $debugContext = this.getDebugContext();
        result = result * 59 + ($debugContext == null ? 43 : $debugContext.hashCode());
        TxnLog $txnLog = this.getTxnLog();
        result = result * 59 + ($txnLog == null ? 43 : $txnLog.hashCode());
        DeepDebugLog $deepDebugLog = this.getDeepDebugLog();
        result = result * 59 + ($deepDebugLog == null ? 43 : $deepDebugLog.hashCode());
        CachedDebugLog $cachedDebugLog = this.getCachedDebugLog();
        result = result * 59 + ($cachedDebugLog == null ? 43 : $cachedDebugLog.hashCode());
        return result;
    }

    public String toString() {
        return "AuctionContext(httpRequest=" + this.getHttpRequest() + ", uidsCookie=" + this.getUidsCookie() + ", bidRequest=" + this.getBidRequest() + ", bidResponse=" + this.getBidResponse() + ", auctionParticipations=" + this.getAuctionParticipations() + ", startTime=" + this.getStartTime() + ", timeout=" + this.getTimeout() + ", account=" + this.getAccount() + ", requestTypeMetric=" + this.getRequestTypeMetric() + ", prebidErrors=" + this.getPrebidErrors() + ", debugWarnings=" + this.getDebugWarnings() + ", debugHttpCalls=" + this.getDebugHttpCalls() + ", bidRejectionTrackers=" + this.getBidRejectionTrackers() + ", gppContext=" + this.getGppContext() + ", privacyContext=" + this.getPrivacyContext() + ", activityInfrastructure=" + this.getActivityInfrastructure() + ", geoInfo=" + this.getGeoInfo() + ", hookExecutionContext=" + this.getHookExecutionContext() + ", debugContext=" + this.getDebugContext() + ", requestRejected=" + this.isRequestRejected() + ", txnLog=" + this.getTxnLog() + ", deepDebugLog=" + this.getDeepDebugLog() + ", cachedDebugLog=" + this.getCachedDebugLog() + ")";
    }
}

