/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.gpp.processor.uspv1;

import com.iab.gpp.encoder.GppModel;
import com.iab.gpp.encoder.error.EncodingException;
import com.iab.gpp.encoder.section.UspV1;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.prebid.server.auction.gpp.model.GppContext;
import org.prebid.server.auction.gpp.model.GppContextWrapper;
import org.prebid.server.auction.gpp.model.privacy.Privacy;
import org.prebid.server.auction.gpp.model.privacy.UspV1Privacy;
import org.prebid.server.auction.gpp.processor.GppContextProcessor;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.model.UpdateResult;

/*
 * Exception performing whole class analysis ignored.
 */
public class UspV1ContextProcessor
implements GppContextProcessor {
    public GppContextWrapper process(GppContext gppContext) {
        ArrayList errors = new ArrayList();
        return GppContextWrapper.of((GppContext)UspV1ContextProcessor.process((GppContext)gppContext, errors), errors);
    }

    private static GppContext process(GppContext gppContext, List<String> errors) {
        GppContext.Scope scope = gppContext.scope();
        UspV1Privacy uspV1Privacy = gppContext.regions().getUspV1Privacy();
        UpdateResult resolvedUsPrivacy = UspV1ContextProcessor.resolveUsPrivacy((String)(uspV1Privacy != null ? uspV1Privacy.getUsPrivacy() : null), (GppModel)scope.getGppModel(), (Set)scope.getSectionsIds(), errors);
        return resolvedUsPrivacy.isUpdated() ? gppContext.with((Privacy)UspV1Privacy.of((String)((String)resolvedUsPrivacy.getValue()))) : gppContext;
    }

    private static UpdateResult<String> resolveUsPrivacy(String usPrivacy, GppModel gppModel, Set<Integer> sectionsIds, List<String> errors) {
        if (!UspV1ContextProcessor.isValidScope((GppModel)gppModel, sectionsIds)) {
            return UpdateResult.unaltered((Object)usPrivacy);
        }
        if (usPrivacy == null) {
            return UpdateResult.updated((Object)UspV1ContextProcessor.usPrivacyFromGpp((GppModel)gppModel));
        }
        try {
            UspV1ContextProcessor.validateExistingUsPrivacy((String)usPrivacy, (GppModel)gppModel);
        }
        catch (PreBidException e) {
            errors.add(e.getMessage());
        }
        return UpdateResult.unaltered((Object)usPrivacy);
    }

    private static boolean isValidScope(GppModel gppModel, Set<Integer> sectionsIds) {
        return sectionsIds != null && sectionsIds.contains(UspV1.ID) && gppModel != null && gppModel.hasSection(UspV1.ID);
    }

    private static String usPrivacyFromGpp(GppModel gppModel) {
        try {
            return gppModel.encodeSection(UspV1.ID);
        }
        catch (EncodingException e) {
            return null;
        }
    }

    private static void validateExistingUsPrivacy(String usPrivacy, GppModel gppModel) {
        if (!usPrivacy.equals(UspV1ContextProcessor.usPrivacyFromGpp((GppModel)gppModel))) {
            throw new PreBidException("USP string does not match regs.us_privacy");
        }
    }
}

