/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.gpp;

import java.util.List;
import java.util.Objects;
import org.prebid.server.auction.gpp.GppService;
import org.prebid.server.auction.gpp.model.GppContext;
import org.prebid.server.auction.gpp.model.GppContextCreator;
import org.prebid.server.auction.gpp.model.GppContextWrapper;
import org.prebid.server.auction.gpp.model.privacy.Privacy;
import org.prebid.server.auction.gpp.model.privacy.TcfEuV2Privacy;
import org.prebid.server.auction.gpp.model.privacy.UspV1Privacy;
import org.prebid.server.cookie.model.CookieSyncContext;
import org.prebid.server.model.UpdateResult;
import org.prebid.server.proto.request.CookieSyncRequest;

/*
 * Exception performing whole class analysis ignored.
 */
public class CookieSyncGppService {
    private final GppService gppService;

    public CookieSyncGppService(GppService gppService) {
        this.gppService = Objects.requireNonNull(gppService);
    }

    public GppContext contextFrom(CookieSyncContext cookieSyncContext) {
        GppContextWrapper initialGppContextWrapper = CookieSyncGppService.contextFrom((CookieSyncRequest)cookieSyncContext.getCookieSyncRequest());
        GppContextWrapper gppContextWrapper = this.gppService.processContext(initialGppContextWrapper);
        CookieSyncGppService.enrichWithErrors((CookieSyncContext)cookieSyncContext, (List)gppContextWrapper.getErrors());
        return gppContextWrapper.getGppContext();
    }

    private static GppContextWrapper contextFrom(CookieSyncRequest cookieSyncRequest) {
        String gpp = cookieSyncRequest.getGpp();
        List gppSid = cookieSyncRequest.getGppSid();
        Integer gdpr = cookieSyncRequest.getGdpr();
        String consent = cookieSyncRequest.getGdprConsent();
        String usPrivacy = cookieSyncRequest.getUsPrivacy();
        return GppContextCreator.from((String)gpp, (List)gppSid).with((Privacy)TcfEuV2Privacy.of((Integer)gdpr, (String)consent)).with((Privacy)UspV1Privacy.of((String)usPrivacy)).build();
    }

    private static void enrichWithErrors(CookieSyncContext cookieSyncContext, List<String> errors) {
        if (cookieSyncContext.isDebug()) {
            cookieSyncContext.getWarnings().addAll(errors);
        }
    }

    public CookieSyncRequest updateCookieSyncRequest(CookieSyncRequest cookieSyncRequest, CookieSyncContext cookieSyncContext) {
        GppContext gppContext = cookieSyncContext.getGppContext();
        GppContext.Regions regions = gppContext.regions();
        TcfEuV2Privacy tcfEuV2Privacy = regions.getTcfEuV2Privacy();
        UspV1Privacy uspV1Privacy = regions.getUspV1Privacy();
        UpdateResult updatedGdpr = CookieSyncGppService.updateResult((Object)cookieSyncRequest.getGdpr(), (Object)(tcfEuV2Privacy != null ? tcfEuV2Privacy.getGdpr() : null));
        UpdateResult updatedConsent = CookieSyncGppService.updateResult((Object)cookieSyncRequest.getGdprConsent(), (Object)(tcfEuV2Privacy != null ? tcfEuV2Privacy.getConsent() : null));
        UpdateResult updatedUsPrivacy = CookieSyncGppService.updateResult((Object)cookieSyncRequest.getUsPrivacy(), (Object)(uspV1Privacy != null ? uspV1Privacy.getUsPrivacy() : null));
        return updatedGdpr.isUpdated() || updatedConsent.isUpdated() || updatedUsPrivacy.isUpdated() ? cookieSyncRequest.toBuilder().gdpr((Integer)updatedGdpr.getValue()).gdprConsent((String)updatedConsent.getValue()).usPrivacy((String)updatedUsPrivacy.getValue()).build() : cookieSyncRequest;
    }

    private static <T> UpdateResult<T> updateResult(T original, T gpp) {
        return original == null && gpp != null ? UpdateResult.updated(gpp) : UpdateResult.unaltered(original);
    }
}

