/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.categorymapping;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.auction.CpmRange;
import org.prebid.server.auction.PriceGranularity;
import org.prebid.server.auction.categorymapping.BasicCategoryMappingService;
import org.prebid.server.auction.categorymapping.CategoryMappingService;
import org.prebid.server.auction.model.BidderResponse;
import org.prebid.server.auction.model.CategoryMappingResult;
import org.prebid.server.auction.requestfactory.Ortb2ImplicitParametersResolver;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderSeatBid;
import org.prebid.server.exception.InvalidRequestException;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.execution.Timeout;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtIncludeBrandCategory;
import org.prebid.server.proto.openrtb.ext.request.ExtDealTier;
import org.prebid.server.proto.openrtb.ext.request.ExtImp;
import org.prebid.server.proto.openrtb.ext.request.ExtImpPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtMediaTypePriceGranularity;
import org.prebid.server.proto.openrtb.ext.request.ExtPriceGranularity;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestTargeting;
import org.prebid.server.proto.openrtb.ext.response.ExtBidPrebid;
import org.prebid.server.proto.openrtb.ext.response.ExtBidPrebidVideo;
import org.prebid.server.settings.ApplicationSettings;
import org.prebid.server.util.ObjectUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class BasicCategoryMappingService
implements CategoryMappingService {
    private static final TypeReference<Map<String, DealTierContainer>> EXT_IMP_DEAL_TIER_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final String FREEWHEEL_AD_SERVER = "freewheel";
    private static final String DFP_AD_SERVER = "dfp";
    private final ApplicationSettings applicationSettings;
    private final JacksonMapper jacksonMapper;

    public BasicCategoryMappingService(ApplicationSettings applicationSettings, JacksonMapper jacksonMapper) {
        this.applicationSettings = Objects.requireNonNull(applicationSettings);
        this.jacksonMapper = Objects.requireNonNull(jacksonMapper);
    }

    public Future<CategoryMappingResult> createCategoryMapping(List<BidderResponse> bidderResponses, BidRequest bidRequest, Timeout timeout) {
        ExtRequestTargeting targeting = BasicCategoryMappingService.targeting((BidRequest)bidRequest);
        ExtIncludeBrandCategory includeBrandCategory = (ExtIncludeBrandCategory)ObjectUtil.getIfNotNull((Object)targeting, ExtRequestTargeting::getIncludebrandcategory);
        if (includeBrandCategory == null) {
            return Future.succeededFuture((Object)CategoryMappingResult.of(bidderResponses));
        }
        boolean withCategory = BooleanUtils.toBooleanDefaultIfNull((Boolean)includeBrandCategory.getWithCategory(), (boolean)false);
        boolean translateCategories = BooleanUtils.toBooleanDefaultIfNull((Boolean)includeBrandCategory.getTranslateCategories(), (boolean)true);
        String primaryAdServer = withCategory && translateCategories ? BasicCategoryMappingService.getPrimaryAdServer((Integer)includeBrandCategory.getPrimaryAdserver()) : null;
        String publisher = withCategory && translateCategories ? includeBrandCategory.getPublisher() : null;
        ArrayList rejectedBids = new ArrayList();
        return this.makeBidderToBidCategory(bidderResponses, withCategory, translateCategories, primaryAdServer, publisher, rejectedBids, timeout).map(categoryBidContexts -> this.resolveBidsCategoriesDurations(bidderResponses, categoryBidContexts, bidRequest, targeting, withCategory, rejectedBids));
    }

    private static ExtRequestTargeting targeting(BidRequest bidRequest) {
        ExtRequest ext = bidRequest.getExt();
        ExtRequestPrebid prebid = ext != null ? ext.getPrebid() : null;
        return prebid != null ? prebid.getTargeting() : null;
    }

    private static String getPrimaryAdServer(Integer primaryAdServer) {
        if (primaryAdServer == null) {
            throw new InvalidRequestException("Primary ad server required but was not defined when translate category is enabled");
        }
        return switch (primaryAdServer) {
            case 1 -> "freewheel";
            case 2 -> "dfp";
            default -> throw new InvalidRequestException("Primary ad server `%s` is not recognized".formatted(primaryAdServer));
        };
    }

    private Future<List<CategoryBidContext>> makeBidderToBidCategory(List<BidderResponse> bidderResponses, boolean withCategory, boolean translateCategories, String primaryAdServer, String publisher, List<RejectedBid> rejectedBids, Timeout timeout) {
        Promise categoryBidContextsPromise = Promise.promise();
        CompositeFuture compositeFuture = CompositeFuture.join(bidderResponses.stream().flatMap(bidderResponse -> this.makeFetchCategoryFutures(bidderResponse, primaryAdServer, publisher, timeout, withCategory, translateCategories)).collect(Collectors.toList()));
        compositeFuture.onComplete(ignored -> BasicCategoryMappingService.collectCategoryFetchResults((CompositeFuture)compositeFuture, (Promise)categoryBidContextsPromise, (List)rejectedBids));
        return categoryBidContextsPromise.future();
    }

    private Stream<Future<CategoryBidContext>> makeFetchCategoryFutures(BidderResponse bidderResponse, String primaryAdServer, String publisher, Timeout timeout, boolean withCategory, boolean translateCategories) {
        List bidderBids = bidderResponse.getSeatBid().getBids();
        String bidder = bidderResponse.getBidder();
        return bidderBids.stream().map(bidderBid -> this.resolveCategory(primaryAdServer, publisher, bidderBid, bidder, timeout, withCategory, translateCategories));
    }

    private Future<CategoryBidContext> resolveCategory(String primaryAdServer, String publisher, BidderBid bidderBid, String bidder, Timeout timeout, boolean withCategory, boolean translateCategories) {
        String category;
        Bid bid = bidderBid.getBid();
        String videoPrimaryCategory = this.getVideoBidPrimaryCategory(bidderBid);
        if (StringUtils.isNotBlank((CharSequence)videoPrimaryCategory)) {
            return Future.succeededFuture((Object)CategoryBidContext.of((BidderBid)bidderBid, (String)bidder, (String)videoPrimaryCategory));
        }
        if (!withCategory) {
            return Future.succeededFuture((Object)CategoryBidContext.of((BidderBid)bidderBid, (String)bidder, null));
        }
        List iabCategories = ListUtils.emptyIfNull((List)bid.getCat());
        if (iabCategories.size() > 1) {
            return Future.failedFuture((Throwable)new RejectedBidException(bid.getId(), bidder, "Bid has more than one category"));
        }
        String string = category = CollectionUtils.isNotEmpty((Collection)iabCategories) ? (String)iabCategories.get(0) : null;
        if (StringUtils.isBlank((CharSequence)category)) {
            return Future.failedFuture((Throwable)new RejectedBidException(bid.getId(), bidder, "Bid did not contain a category"));
        }
        return translateCategories ? this.fetchCategory(bidderBid, bidder, primaryAdServer, publisher, category, timeout) : Future.succeededFuture((Object)CategoryBidContext.of((BidderBid)bidderBid, (String)bidder, (String)category));
    }

    private String getVideoBidPrimaryCategory(BidderBid bidderBid) {
        String wrapperVideoPrimaryCategory = (String)ObjectUtil.getIfNotNull((Object)bidderBid.getVideoInfo(), ExtBidPrebidVideo::getPrimaryCategory);
        if (wrapperVideoPrimaryCategory != null) {
            return wrapperVideoPrimaryCategory;
        }
        ObjectNode bidExt = bidderBid.getBid().getExt();
        ExtBidPrebid extPrebid = bidExt != null ? this.toExtBidPrebid(bidExt) : null;
        ExtBidPrebidVideo extVideo = extPrebid != null ? extPrebid.getVideo() : null;
        return extVideo != null ? extVideo.getPrimaryCategory() : null;
    }

    private ExtBidPrebid toExtBidPrebid(ObjectNode ext) {
        try {
            return (ExtBidPrebid)this.jacksonMapper.mapper().treeToValue((TreeNode)ext, ExtBidPrebid.class);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    private Future<CategoryBidContext> fetchCategory(BidderBid bidderBid, String bidder, String primaryAdServer, String publisher, String category, Timeout timeout) {
        String bidId = bidderBid.getBid().getId();
        return this.applicationSettings.getCategories(primaryAdServer, publisher, timeout).map(fetchedCategories -> BasicCategoryMappingService.findAndValidateCategory((Map)fetchedCategories, (String)category, (String)bidId, (String)bidder, (String)primaryAdServer, (String)publisher)).recover(throwable -> this.wrapWithRejectedBidException(bidId, bidder, throwable)).map(fetchedCategory -> CategoryBidContext.of((BidderBid)bidderBid, (String)bidder, (String)fetchedCategory));
    }

    private static String findAndValidateCategory(Map<String, String> fetchedCategories, String category, String bidId, String bidder, String primaryAdServer, String publisher) {
        if (MapUtils.isEmpty(fetchedCategories)) {
            throw new RejectedBidException(bidId, bidder, "Category mapping data for primary ad server: '%s', publisher: '%s' not found".formatted(primaryAdServer, publisher));
        }
        String categoryId = fetchedCategories.get(category);
        if (StringUtils.isEmpty((CharSequence)categoryId)) {
            throw new RejectedBidException(bidId, bidder, "Category mapping data for primary ad server: '%s', publisher: '%s' does not contain category for cat = '%s'".formatted(primaryAdServer, publisher, category));
        }
        return categoryId;
    }

    private Future<String> wrapWithRejectedBidException(String bidId, String bidder, Throwable throwable) {
        return Future.failedFuture((Throwable)new RejectedBidException(bidId, bidder, throwable.getMessage()));
    }

    private static void collectCategoryFetchResults(CompositeFuture compositeFuture, Promise<List<CategoryBidContext>> resultPromise, List<RejectedBid> rejectedBids) {
        ArrayList<CategoryBidContext> categoryBidContexts = new ArrayList<CategoryBidContext>();
        for (int i = 0; i < compositeFuture.list().size(); ++i) {
            Object o = compositeFuture.resultAt(i);
            if (o != null) {
                categoryBidContexts.add((CategoryBidContext)o);
                continue;
            }
            RejectedBidException rejectedBidException = (RejectedBidException)compositeFuture.cause(i);
            rejectedBids.add(rejectedBidException.getBid());
        }
        resultPromise.complete(categoryBidContexts);
    }

    private CategoryMappingResult resolveBidsCategoriesDurations(List<BidderResponse> bidderResponses, List<CategoryBidContext> categoryBidContexts, BidRequest bidRequest, ExtRequestTargeting targeting, boolean withCategory, List<RejectedBid> rejectedBids) {
        PriceGranularity priceGranularity = this.resolvePriceGranularity(targeting);
        List durations = ListUtils.emptyIfNull((List)targeting.getDurationrangesec()).stream().sorted().toList();
        ArrayList<String> errors = new ArrayList<String>();
        Map impIdToBiddersDealTear = BasicCategoryMappingService.isSupportedForDeals((BidRequest)bidRequest) ? this.extractDealTierPerImpAndBidder(bidRequest.getImp(), errors) : Collections.emptyMap();
        boolean appendBidderNames = BooleanUtils.toBooleanDefaultIfNull((Boolean)targeting.getAppendbiddernames(), (boolean)false);
        Map uniqueCatKeysToCategoryBids = categoryBidContexts.stream().map(categoryBidContext -> this.enrichCategoryBidContext(categoryBidContext, durations, priceGranularity, withCategory, appendBidderNames, impIdToBiddersDealTear, rejectedBids)).filter(Objects::nonNull).collect(Collectors.groupingBy(CategoryBidContext::getCategoryUniqueKey, Collectors.mapping(Function.identity(), Collectors.toSet())));
        rejectedBids.addAll(BasicCategoryMappingService.collectRejectedDuplicatedBids(uniqueCatKeysToCategoryBids));
        errors.addAll(rejectedBids.stream().map(RejectedBid::getErrorMessage).toList());
        return CategoryMappingResult.of((Map)BasicCategoryMappingService.makeBidderToBidCategoryDuration(uniqueCatKeysToCategoryBids, rejectedBids), (Map)this.makeBidsSatisfiedPriority(uniqueCatKeysToCategoryBids), (List)BasicCategoryMappingService.removeRejectedBids(bidderResponses, rejectedBids), errors);
    }

    private PriceGranularity resolvePriceGranularity(ExtRequestTargeting targeting) {
        PriceGranularity videoPriceGranularity = this.resolveVideoMediaTypePriceGranularity(targeting);
        return videoPriceGranularity != null ? videoPriceGranularity : this.createPriceGranularity(targeting.getPricegranularity(), "pricegranularity");
    }

    private PriceGranularity resolveVideoMediaTypePriceGranularity(ExtRequestTargeting targeting) {
        ExtMediaTypePriceGranularity extMediaTypePriceGranularity = targeting.getMediatypepricegranularity();
        return extMediaTypePriceGranularity != null ? this.createPriceGranularity((JsonNode)extMediaTypePriceGranularity.getVideo(), "mediatypepricegranularity.video") : null;
    }

    private PriceGranularity createPriceGranularity(JsonNode nodePriceGranularity, String path) {
        ExtPriceGranularity extPriceGranularity = nodePriceGranularity != null && !nodePriceGranularity.isNull() ? this.parsePriceGranularity(nodePriceGranularity, path) : null;
        return extPriceGranularity != null ? PriceGranularity.createFromExtPriceGranularity(extPriceGranularity) : null;
    }

    private ExtPriceGranularity parsePriceGranularity(JsonNode priceGranularity, String path) {
        try {
            return (ExtPriceGranularity)this.jacksonMapper.mapper().treeToValue((TreeNode)priceGranularity, ExtPriceGranularity.class);
        }
        catch (JsonProcessingException e) {
            throw new PreBidException("Error decoding bidRequest.prebid.targeting.%s: %s".formatted(path, e.getMessage()), (Throwable)e);
        }
    }

    private static boolean isSupportedForDeals(BidRequest bidRequest) {
        ExtRequestPrebid prebid = (ExtRequestPrebid)ObjectUtil.getIfNotNull((Object)bidRequest.getExt(), ExtRequest::getPrebid);
        return prebid != null && BooleanUtils.toBooleanDefaultIfNull((Boolean)prebid.getSupportdeals(), (boolean)false);
    }

    private Map<String, Map<String, ExtDealTier>> extractDealTierPerImpAndBidder(List<Imp> imps, List<String> errors) {
        return imps.stream().collect(Collectors.toMap(Imp::getId, imp -> this.extractBidderToDealTiers(imp, errors)));
    }

    private Map<String, ExtDealTier> extractBidderToDealTiers(Imp imp, List<String> errors) {
        ObjectNode impExt = imp.getExt();
        Map bidderToImpExtDealTier = (Map)this.jacksonMapper.mapper().convertValue((Object)impExt, EXT_IMP_DEAL_TIER_REFERENCE);
        ExtImp extImp = this.parseImpExt(impExt);
        ExtImpPrebid extImpPrebid = extImp != null ? extImp.getPrebid() : null;
        ObjectNode bidders = extImpPrebid != null ? extImpPrebid.getBidder() : null;
        Map bidderToImpExtPrebidDealTier = bidders != null ? (Map)this.jacksonMapper.mapper().convertValue((Object)bidders, EXT_IMP_DEAL_TIER_REFERENCE) : Collections.emptyMap();
        bidderToImpExtPrebidDealTier.forEach((bidder, dealTierContainer) -> bidderToImpExtDealTier.merge(bidder, dealTierContainer, (value1, value2) -> value2));
        return bidderToImpExtDealTier.entrySet().stream().filter(entry -> BasicCategoryMappingService.isValidBidder((String)((String)entry.getKey()))).filter(entry -> BasicCategoryMappingService.isValidExtDealTier((DealTierContainer)((DealTierContainer)entry.getValue()), (String)((String)entry.getKey()), (String)imp.getId(), (List)errors)).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((DealTierContainer)entry.getValue()).getDealTier()));
    }

    private ExtImp parseImpExt(ObjectNode impExt) {
        try {
            return (ExtImp)this.jacksonMapper.mapper().treeToValue((TreeNode)impExt, ExtImp.class);
        }
        catch (JsonProcessingException e) {
            throw new PreBidException("Failed to decode imp.ext");
        }
    }

    private static boolean isValidBidder(String bidder) {
        return Ortb2ImplicitParametersResolver.isImpExtBidder((String)bidder);
    }

    private static boolean isValidExtDealTier(DealTierContainer dealTierContainer, String bidder, String impId, List<String> errors) {
        ExtDealTier dealTier = (ExtDealTier)ObjectUtil.getIfNotNull((Object)dealTierContainer, DealTierContainer::getDealTier);
        if (dealTier == null) {
            errors.add("DealTier configuration not defined for bidder '%s', imp ID '%s'".formatted(bidder, impId));
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dealTier.getPrefix())) {
            errors.add("DealTier configuration not valid for bidder '%s', imp ID '%s' with a reason: dealTier.prefix empty string or null".formatted(bidder, impId));
            return false;
        }
        Integer minDealTier = dealTier.getMinDealTier();
        if (minDealTier == null || minDealTier <= 0) {
            errors.add("DealTier configuration not valid for bidder '%s', imp ID '%s' with a reason: dealTier.minDealTier should be larger than 0, but was %s".formatted(bidder, impId, minDealTier));
            return false;
        }
        return true;
    }

    private static boolean isNotRejected(String bidId, String bidder, List<RejectedBid> rejectedBids) {
        return rejectedBids.stream().noneMatch(rejectedBid -> rejectedBid.getBidId().equals(bidId) && rejectedBid.getBidder().equals(bidder));
    }

    private CategoryBidContext enrichCategoryBidContext(CategoryBidContext categoryBidContext, List<Integer> durations, PriceGranularity priceGranularity, boolean withCategory, boolean appendBidderName, Map<String, Map<String, ExtDealTier>> impToBiddersDealTier, List<RejectedBid> rejectedBids) {
        int duration;
        BidderBid bidderBid = categoryBidContext.getBidderBid();
        Bid bid = bidderBid.getBid();
        String bidder = categoryBidContext.getBidder();
        try {
            duration = this.resolveDuration(durations, bidderBid, bidder);
        }
        catch (RejectedBidException e) {
            rejectedBids.add(e.getBid());
            return null;
        }
        BigDecimal price = CpmRange.fromCpmAsNumber((BigDecimal)bid.getPrice(), (PriceGranularity)priceGranularity);
        String rowPrice = CpmRange.format((BigDecimal)price, (Integer)priceGranularity.getPrecision());
        String category = categoryBidContext.getCategory();
        String categoryUniqueKey = this.createCategoryUniqueKey(withCategory, category, rowPrice, duration);
        Map<String, ExtDealTier> impsDealTiers = impToBiddersDealTier.get(bid.getImpid());
        ExtDealTier dealTier = impsDealTiers != null ? impsDealTiers.get(bidder) : null;
        int dealPriority = bidderBid.getDealPriority() != null ? bidderBid.getDealPriority() : 0;
        boolean satisfiedPriority = dealTier != null && dealPriority >= dealTier.getMinDealTier();
        String categoryDuration = BasicCategoryMappingService.createCategoryDuration((String)rowPrice, (String)category, (int)duration, (boolean)satisfiedPriority, (ExtDealTier)dealTier, (boolean)withCategory, (boolean)appendBidderName, (String)bidder);
        return categoryBidContext.toBuilder().categoryUniqueKey(categoryUniqueKey).satisfiedPriority(satisfiedPriority).categoryDuration(categoryDuration).price(price).build();
    }

    private Integer resolveDuration(List<Integer> durations, BidderBid bidderBid, String bidder) {
        int duration;
        ExtBidPrebidVideo video = bidderBid.getVideoInfo();
        Integer videoDuration = video != null ? video.getDuration() : null;
        int n = duration = videoDuration != null ? videoDuration : 0;
        if (CollectionUtils.isEmpty(durations)) {
            return duration;
        }
        String bidId = bidderBid.getBid().getId();
        int maxDuration = durations.get(durations.size() - 1);
        if (duration > maxDuration) {
            throw new RejectedBidException(bidId, bidder, "Bid duration '%s' exceeds maximum '%s'".formatted(duration, maxDuration));
        }
        return durations.stream().filter(targetingDuration -> duration <= targetingDuration).findFirst().orElseThrow(() -> new RejectedBidException(bidId, bidder, "Duration is not in targeting range"));
    }

    private String createCategoryUniqueKey(boolean withCategory, String category, String price, int duration) {
        return withCategory ? category : "%s_%ds".formatted(price, duration);
    }

    private static String createCategoryDuration(String price, String category, int duration, boolean satisfiedPriority, ExtDealTier dealTier, boolean withCategory, boolean appendBidderName, String bidder) {
        String categoryPrefix = dealTier != null && satisfiedPriority ? dealTier.getPrefix() + dealTier.getMinDealTier() : price;
        String categoryDuration = withCategory ? "%s_%s_%ds".formatted(categoryPrefix, category, duration) : "%s_%ds".formatted(categoryPrefix, duration);
        return appendBidderName ? "%s_%s".formatted(categoryDuration, bidder) : categoryDuration;
    }

    private static Set<RejectedBid> collectRejectedDuplicatedBids(Map<String, Set<CategoryBidContext>> categoryToDuplicatedCategoryBids) {
        return categoryToDuplicatedCategoryBids.values().stream().filter(categoryBids -> categoryBids.size() > 1).flatMap(BasicCategoryMappingService::getDuplicatedForCategory).map(categoryBidContext -> RejectedBid.of((String)BasicCategoryMappingService.extractBidId((CategoryBidContext)categoryBidContext), (String)categoryBidContext.getBidder(), (String)"Bid was deduplicated")).collect(Collectors.toSet());
    }

    private static Map<Bid, String> makeBidderToBidCategoryDuration(Map<String, Set<CategoryBidContext>> categoryToBidsWithBidder, List<RejectedBid> rejectedBids) {
        return categoryToBidsWithBidder.values().stream().flatMap(Collection::stream).filter(categoryBidContext -> BasicCategoryMappingService.isNotRejected((String)BasicCategoryMappingService.extractBidId((CategoryBidContext)categoryBidContext), (String)categoryBidContext.getBidder(), (List)rejectedBids)).collect(Collectors.toMap(categoryBidContext -> categoryBidContext.getBidderBid().getBid(), CategoryBidContext::getCategoryDuration));
    }

    private Map<Bid, Boolean> makeBidsSatisfiedPriority(Map<String, Set<CategoryBidContext>> uniqueCatKeysToCategoryBids) {
        return uniqueCatKeysToCategoryBids.values().stream().flatMap(Collection::stream).collect(Collectors.toMap(categoryBidContext -> categoryBidContext.getBidderBid().getBid(), CategoryBidContext::isSatisfiedPriority));
    }

    private static List<BidderResponse> removeRejectedBids(List<BidderResponse> bidderResponses, List<RejectedBid> rejectedBids) {
        Map bidderToRejectedBidIds = rejectedBids.stream().collect(Collectors.groupingBy(RejectedBid::getBidder, Collectors.mapping(RejectedBid::getBidId, Collectors.toList())));
        return bidderResponses.stream().map(bidderResponse -> bidderToRejectedBidIds.containsKey(bidderResponse.getBidder()) ? BasicCategoryMappingService.removeRejectedBids((BidderResponse)bidderResponse, (List)((List)bidderToRejectedBidIds.get(bidderResponse.getBidder()))) : bidderResponse).toList();
    }

    private static BidderResponse removeRejectedBids(BidderResponse bidderResponse, List<String> rejectedBidIds) {
        String bidder = bidderResponse.getBidder();
        BidderSeatBid bidderSeatBid = bidderResponse.getSeatBid();
        List<BidderBid> survivedBidderBids = bidderSeatBid.getBids().stream().filter(bidderBid -> !rejectedBidIds.contains(bidderBid.getBid().getId())).toList();
        return BidderResponse.of((String)bidder, (BidderSeatBid)bidderSeatBid.with(survivedBidderBids), (int)bidderResponse.getResponseTime());
    }

    private static Stream<CategoryBidContext> getDuplicatedForCategory(Set<CategoryBidContext> categoryBidContexts) {
        CategoryBidContext highestPriceBid = categoryBidContexts.stream().max(Comparator.comparing(CategoryBidContext::getPrice)).orElseThrow(() -> new PreBidException("Can't find bid with highest price."));
        return categoryBidContexts.stream().filter(categoryBidContext -> ObjectUtils.notEqual((Object)highestPriceBid, (Object)categoryBidContext));
    }

    private static String extractBidId(CategoryBidContext categoryBidContext) {
        return categoryBidContext.getBidderBid().getBid().getId();
    }
}

