/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.adjustment;

import java.math.BigDecimal;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestBidAdjustmentFactors;
import org.prebid.server.proto.openrtb.ext.request.ImpMediaType;

public class BidAdjustmentFactorResolver {
    public BigDecimal resolve(ImpMediaType impMediaType, ExtRequestBidAdjustmentFactors adjustmentFactors, String bidder) {
        EnumMap adjustmentFactorsByMediaTypes = adjustmentFactors.getMediatypes();
        BigDecimal effectiveBidderAdjustmentFactor = Optional.ofNullable(adjustmentFactors.getAdjustments()).map(factors -> (BigDecimal)factors.get(bidder)).orElse(BigDecimal.ONE);
        if (MapUtils.isEmpty((Map)adjustmentFactorsByMediaTypes)) {
            return effectiveBidderAdjustmentFactor;
        }
        return Optional.ofNullable(impMediaType).map(adjustmentFactorsByMediaTypes::get).flatMap(factors -> factors.entrySet().stream().filter(entry -> StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)entry.getKey()), (CharSequence)bidder)).map(Map.Entry::getValue).findFirst()).orElse(effectiveBidderAdjustmentFactor);
    }
}

