/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction;

import com.fasterxml.jackson.databind.JsonNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.response.Bid;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidAdservertargetingRule;

/*
 * Exception performing whole class analysis ignored.
 */
public class TargetingKeywordsResolver {
    public static final String IMP_PREFIX = "imp.";
    public static final String SEATBID_BID_PREFIX = "seatbid.bid.";
    public static final String BIDDER_MACRO = "{{BIDDER}}";
    private final BidRequest bidRequest;
    private final JacksonMapper mapper;
    private final Map<String, String> staticAndRequestKeywords;
    private final List<ExtRequestPrebidAdservertargetingRule> impRequestRules;
    private final List<ExtRequestPrebidAdservertargetingRule> responseRules;

    private TargetingKeywordsResolver(BidRequest bidRequest, JacksonMapper mapper) {
        this.bidRequest = Objects.requireNonNull(bidRequest);
        this.mapper = Objects.requireNonNull(mapper);
        Map rulesBySource = this.rulesBySource();
        this.impRequestRules = TargetingKeywordsResolver.impRequestRules((Map)rulesBySource);
        this.responseRules = TargetingKeywordsResolver.responseRules((Map)rulesBySource);
        this.staticAndRequestKeywords = this.resolveStaticAndRequestKeywords(rulesBySource);
    }

    public static TargetingKeywordsResolver create(BidRequest bidRequest, JacksonMapper mapper) {
        return new TargetingKeywordsResolver(bidRequest, mapper);
    }

    public Map<String, String> resolve(Bid bid, String bidder) {
        HashMap<String, String> result = new HashMap<String, String>(this.staticAndRequestKeywords);
        result.putAll(this.resolveImpRequestKeywords(bid));
        result.putAll(this.resolveResponseKeywords(bid, bidder));
        return result;
    }

    private Map<ExtRequestPrebidAdservertargetingRule.Source, List<ExtRequestPrebidAdservertargetingRule>> rulesBySource() {
        ExtRequest extRequest = this.bidRequest.getExt();
        List rules = (List)TargetingKeywordsResolver.get((Object)((ExtRequestPrebid)TargetingKeywordsResolver.get((Object)extRequest, ExtRequest::getPrebid)), ExtRequestPrebid::getAdservertargeting);
        return ((List)ObjectUtils.defaultIfNull((Object)rules, Collections.emptyList())).stream().filter(TargetingKeywordsResolver::isValid).collect(Collectors.groupingBy(ExtRequestPrebidAdservertargetingRule::getSource));
    }

    private static List<ExtRequestPrebidAdservertargetingRule> impRequestRules(Map<ExtRequestPrebidAdservertargetingRule.Source, List<ExtRequestPrebidAdservertargetingRule>> rulesBySource) {
        return rulesBySource.getOrDefault(ExtRequestPrebidAdservertargetingRule.Source.bidrequest, Collections.emptyList()).stream().filter(TargetingKeywordsResolver::hasImpPath).toList();
    }

    private static List<ExtRequestPrebidAdservertargetingRule> responseRules(Map<ExtRequestPrebidAdservertargetingRule.Source, List<ExtRequestPrebidAdservertargetingRule>> rulesBySource) {
        return rulesBySource.getOrDefault(ExtRequestPrebidAdservertargetingRule.Source.bidresponse, Collections.emptyList()).stream().filter(TargetingKeywordsResolver::hasSeatbidBidPath).toList();
    }

    private Map<String, String> resolveStaticAndRequestKeywords(Map<ExtRequestPrebidAdservertargetingRule.Source, List<ExtRequestPrebidAdservertargetingRule>> rulesBySource) {
        HashMap<String, String> result = new HashMap<String, String>(TargetingKeywordsResolver.resolveStaticKeywords(rulesBySource));
        result.putAll(this.resolveRequestKeywords(rulesBySource));
        return result;
    }

    private static Map<String, String> resolveStaticKeywords(Map<ExtRequestPrebidAdservertargetingRule.Source, List<ExtRequestPrebidAdservertargetingRule>> rulesBySource) {
        return rulesBySource.getOrDefault(ExtRequestPrebidAdservertargetingRule.Source.xStatic, Collections.emptyList()).stream().collect(Collectors.toMap(ExtRequestPrebidAdservertargetingRule::getKey, ExtRequestPrebidAdservertargetingRule::getValue, (value1, value2) -> value2));
    }

    private Map<String, String> resolveRequestKeywords(Map<ExtRequestPrebidAdservertargetingRule.Source, List<ExtRequestPrebidAdservertargetingRule>> rulesBySource) {
        List requestRules = TargetingKeywordsResolver.requestRules(rulesBySource);
        if (!requestRules.isEmpty()) {
            return TargetingKeywordsResolver.lookupValues((JsonNode)this.mapper.mapper().valueToTree((Object)this.bidRequest), (List)requestRules, Function.identity(), Function.identity());
        }
        return Collections.emptyMap();
    }

    private static List<ExtRequestPrebidAdservertargetingRule> requestRules(Map<ExtRequestPrebidAdservertargetingRule.Source, List<ExtRequestPrebidAdservertargetingRule>> rulesBySource) {
        return rulesBySource.getOrDefault(ExtRequestPrebidAdservertargetingRule.Source.bidrequest, Collections.emptyList()).stream().filter(rule -> !TargetingKeywordsResolver.hasImpPath((ExtRequestPrebidAdservertargetingRule)rule)).toList();
    }

    private Map<String, String> resolveImpRequestKeywords(Bid bid) {
        JsonNode impNode;
        if (!this.impRequestRules.isEmpty() && (impNode = this.locateImp(bid)) != null) {
            return TargetingKeywordsResolver.lookupValues((JsonNode)impNode, (List)this.impRequestRules, (T value) -> StringUtils.substringAfter((String)value, (String)"imp."), Function.identity());
        }
        return Collections.emptyMap();
    }

    private JsonNode locateImp(Bid bid) {
        String impid = bid.getImpid();
        if (StringUtils.isBlank((CharSequence)impid)) {
            return null;
        }
        return this.bidRequest.getImp().stream().filter(imp -> Objects.equals(imp.getId(), impid)).findFirst().map(imp -> this.mapper.mapper().valueToTree(imp)).orElse(null);
    }

    private Map<String, String> resolveResponseKeywords(Bid bid, String bidder) {
        if (!this.responseRules.isEmpty()) {
            return TargetingKeywordsResolver.lookupValues((JsonNode)this.mapper.mapper().valueToTree((Object)bid), (List)this.responseRules, (T value) -> StringUtils.substringAfter((String)value, (String)"seatbid.bid."), (T key) -> StringUtils.replace((String)key, (String)"{{BIDDER}}", (String)bidder));
        }
        return Collections.emptyMap();
    }

    private static boolean isValid(ExtRequestPrebidAdservertargetingRule rule) {
        return StringUtils.isNotBlank((CharSequence)rule.getKey()) && StringUtils.isNotBlank((CharSequence)rule.getValue()) && rule.getSource() != null;
    }

    private static boolean hasImpPath(ExtRequestPrebidAdservertargetingRule rule) {
        return rule.getValue().startsWith("imp.");
    }

    private static boolean hasSeatbidBidPath(ExtRequestPrebidAdservertargetingRule rule) {
        return rule.getValue().startsWith("seatbid.bid.");
    }

    private static Map<String, String> lookupValues(JsonNode node, List<ExtRequestPrebidAdservertargetingRule> rules, Function<String, String> pathValueMapper, Function<String, String> keyMapper) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (ExtRequestPrebidAdservertargetingRule rule : rules) {
            String lookupResult = TargetingKeywordsResolver.lookupValue((JsonNode)node, (String)pathValueMapper.apply(rule.getValue()));
            if (!StringUtils.isNotBlank((CharSequence)lookupResult)) continue;
            result.put(keyMapper.apply(rule.getKey()), lookupResult);
        }
        return result;
    }

    private static String lookupValue(JsonNode impNode, String value) {
        return impNode.at(TargetingKeywordsResolver.toPath((String)value)).asText();
    }

    private static String toPath(String value) {
        return "/" + value.replaceAll("\\.", "/");
    }

    private static <T, U> U get(T target, Function<T, U> getter) {
        return target != null ? (U)getter.apply(target) : null;
    }
}

