/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Video;
import io.vertx.core.Future;
import io.vertx.core.file.FileSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.auction.model.AuctionStoredResult;
import org.prebid.server.exception.InvalidRequestException;
import org.prebid.server.exception.InvalidStoredImpException;
import org.prebid.server.exception.InvalidStoredRequestException;
import org.prebid.server.execution.Timeout;
import org.prebid.server.execution.TimeoutFactory;
import org.prebid.server.identity.IdGenerator;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.json.JsonMerger;
import org.prebid.server.metric.Metrics;
import org.prebid.server.proto.openrtb.ext.request.ExtImp;
import org.prebid.server.proto.openrtb.ext.request.ExtImpPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtStoredRequest;
import org.prebid.server.settings.ApplicationSettings;
import org.prebid.server.settings.model.StoredDataResult;
import org.prebid.server.settings.model.VideoStoredDataResult;
import org.prebid.server.util.ObjectUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class StoredRequestProcessor {
    private static final String OVERRIDE_BID_REQUEST_ID_TEMPLATE = "{{UUID}}";
    private final long defaultTimeout;
    private final BidRequest defaultBidRequest;
    private final boolean generateBidRequestId;
    private final ApplicationSettings applicationSettings;
    private final IdGenerator idGenerator;
    private final Metrics metrics;
    private final TimeoutFactory timeoutFactory;
    private final JacksonMapper mapper;
    private final JsonMerger jsonMerger;

    public StoredRequestProcessor(long defaultTimeout, String defaultBidRequestPath, boolean generateBidRequestId, FileSystem fileSystem, ApplicationSettings applicationSettings, IdGenerator idGenerator, Metrics metrics, TimeoutFactory timeoutFactory, JacksonMapper mapper, JsonMerger jsonMerger) {
        this.defaultTimeout = defaultTimeout;
        this.defaultBidRequest = StoredRequestProcessor.readBidRequest((String)defaultBidRequestPath, (FileSystem)Objects.requireNonNull(fileSystem), (JacksonMapper)Objects.requireNonNull(mapper));
        this.generateBidRequestId = generateBidRequestId;
        this.applicationSettings = Objects.requireNonNull(applicationSettings);
        this.idGenerator = Objects.requireNonNull(idGenerator);
        this.metrics = Objects.requireNonNull(metrics);
        this.timeoutFactory = Objects.requireNonNull(timeoutFactory);
        this.mapper = Objects.requireNonNull(mapper);
        this.jsonMerger = Objects.requireNonNull(jsonMerger);
    }

    public Future<AuctionStoredResult> processAuctionRequest(String accountId, BidRequest bidRequest) {
        return this.processAuctionStoredRequest(accountId, bidRequest).onFailure(cause -> this.updateInvalidStoredResultMetrics(accountId, cause)).recover(StoredRequestProcessor::stripToInvalidRequestException);
    }

    private Future<AuctionStoredResult> processAuctionStoredRequest(String accountId, BidRequest bidRequest) {
        Map impToStoredRequestId;
        Map bidRequestToStoredRequestId;
        try {
            bidRequestToStoredRequestId = StoredRequestProcessor.mapStoredRequestHolderToStoredRequestId(Collections.singletonList(bidRequest), StoredRequestProcessor::getStoredRequestIdFromBidRequest);
            impToStoredRequestId = StoredRequestProcessor.mapStoredRequestHolderToStoredRequestId((List)bidRequest.getImp(), arg_0 -> this.getStoredRequestIdFromImp(arg_0));
        }
        catch (InvalidStoredImpException | InvalidStoredRequestException e) {
            return Future.failedFuture((Throwable)e);
        }
        HashSet requestIds = new HashSet(bidRequestToStoredRequestId.values());
        HashSet impIds = new HashSet(impToStoredRequestId.values());
        if (requestIds.isEmpty() && impIds.isEmpty()) {
            return Future.succeededFuture((Object)AuctionStoredResult.of((boolean)false, (BidRequest)bidRequest));
        }
        Future storedDataFuture = this.applicationSettings.getStoredData(accountId, requestIds, impIds, this.timeout(bidRequest)).onSuccess(storedDataResult -> this.updateStoredResultMetrics(storedDataResult, requestIds, impIds));
        return this.storedRequestsToBidRequest(storedDataFuture, bidRequest, (String)bidRequestToStoredRequestId.get(bidRequest), impToStoredRequestId).map(arg_0 -> this.generateBidRequestIdForApp(arg_0)).map(resolvedRequest -> AuctionStoredResult.of((boolean)true, (BidRequest)resolvedRequest));
    }

    public Future<BidRequest> processAmpRequest(String accountId, String ampRequestId, BidRequest bidRequest) {
        return this.processAmpStoredRequest(accountId, ampRequestId, bidRequest).onFailure(cause -> this.updateInvalidStoredResultMetrics(accountId, cause)).recover(StoredRequestProcessor::stripToInvalidRequestException);
    }

    private Future<BidRequest> processAmpStoredRequest(String accountId, String ampRequestId, BidRequest bidRequest) {
        Future ampStoredDataFuture = this.applicationSettings.getAmpStoredData(accountId, Collections.singleton(ampRequestId), Collections.emptySet(), this.timeout(bidRequest)).onSuccess(storedDataResult -> this.updateStoredResultMetrics(storedDataResult, Collections.singleton(ampRequestId), Collections.emptySet()));
        return this.storedRequestsToBidRequest(ampStoredDataFuture, bidRequest, ampRequestId, Collections.emptyMap()).map(arg_0 -> this.generateBidRequestId(arg_0));
    }

    Future<VideoStoredDataResult> videoStoredDataResult(String accountId, List<Imp> imps, List<String> errors, Timeout timeout) {
        return this.videoStoredDataResultInternal(accountId, imps, errors, timeout).onFailure(cause -> this.updateInvalidStoredResultMetrics(accountId, cause)).recover(StoredRequestProcessor::stripToInvalidRequestException);
    }

    private Future<VideoStoredDataResult> videoStoredDataResultInternal(String accountId, List<Imp> imps, List<String> errors, Timeout timeout) {
        Map impToStoredRequestId;
        try {
            impToStoredRequestId = StoredRequestProcessor.mapStoredRequestHolderToStoredRequestId(imps, arg_0 -> this.getStoredRequestIdFromImp(arg_0));
        }
        catch (InvalidStoredImpException e) {
            return Future.failedFuture((Throwable)e);
        }
        Map<String, String> storedIdToImpId = impToStoredRequestId.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, impIdToStoredId -> ((Imp)impIdToStoredId.getKey()).getId()));
        return this.applicationSettings.getStoredData(accountId, Collections.emptySet(), storedIdToImpId.keySet(), timeout).map(storedDataResult -> this.makeVideoStoredDataResult(storedDataResult, storedIdToImpId, errors));
    }

    private void updateInvalidStoredResultMetrics(String accountId, Throwable cause) {
        if (cause instanceof InvalidStoredRequestException) {
            this.metrics.updateAccountRequestRejectedByInvalidStoredRequestMetrics(accountId);
        } else if (cause instanceof InvalidStoredImpException) {
            this.metrics.updateAccountRequestRejectedByInvalidStoredImpMetrics(accountId);
        }
    }

    private static <T> Future<T> stripToInvalidRequestException(Throwable cause) {
        return Future.failedFuture((Throwable)new InvalidRequestException("Stored request processing failed: " + cause.getMessage()));
    }

    private void updateStoredResultMetrics(StoredDataResult storedDataResult, Set<String> requestIds, Set<String> impIds) {
        requestIds.forEach(id -> this.metrics.updateStoredRequestMetric(storedDataResult.getStoredIdToRequest().containsKey(id)));
        impIds.forEach(id -> this.metrics.updateStoredImpsMetric(storedDataResult.getStoredIdToImp().containsKey(id)));
    }

    private static BidRequest readBidRequest(String defaultBidRequestPath, FileSystem fileSystem, JacksonMapper mapper) {
        return StringUtils.isNotBlank((CharSequence)defaultBidRequestPath) ? (BidRequest)mapper.decodeValue(fileSystem.readFileBlocking(defaultBidRequestPath), BidRequest.class) : null;
    }

    private VideoStoredDataResult makeVideoStoredDataResult(StoredDataResult storedDataResult, Map<String, String> storedIdToImpId, List<String> errors) {
        Map storedIdToStoredImp = storedDataResult.getStoredIdToImp();
        HashMap<String, Video> impIdToStoredVideo = new HashMap<String, Video>();
        for (Map.Entry<String, String> storedIdToImpIdEntry : storedIdToImpId.entrySet()) {
            String storedId = storedIdToImpIdEntry.getKey();
            String storedImp = (String)storedIdToStoredImp.get(storedId);
            if (storedImp == null) {
                errors.add("No stored Imp for stored id " + storedId);
                continue;
            }
            String impId = storedIdToImpIdEntry.getValue();
            Video video = this.parseVideoFromImp(storedImp);
            if (video == null) {
                errors.add("No stored video found for Imp with id " + impId);
                continue;
            }
            impIdToStoredVideo.put(impId, video);
        }
        return VideoStoredDataResult.of(impIdToStoredVideo, errors);
    }

    private Video parseVideoFromImp(String storedJson) {
        if (StringUtils.isNotBlank((CharSequence)storedJson)) {
            try {
                Imp imp = (Imp)this.mapper.mapper().readValue(storedJson, Imp.class);
                return imp.getVideo();
            }
            catch (JsonProcessingException e) {
                return null;
            }
        }
        return null;
    }

    private Future<BidRequest> storedRequestsToBidRequest(Future<StoredDataResult> storedDataFuture, BidRequest bidRequest, String storedBidRequestId, Map<Imp, String> impsToStoredRequestId) {
        return storedDataFuture.compose(result -> !result.getErrors().isEmpty() ? Future.failedFuture((Throwable)new InvalidStoredRequestException(result.getErrors())) : Future.succeededFuture((Object)result)).map(result -> this.mergeBidRequestAndImps(bidRequest, storedBidRequestId, impsToStoredRequestId, result));
    }

    private BidRequest mergeBidRequestAndImps(BidRequest bidRequest, String storedRequestId, Map<Imp, String> impToStoredId, StoredDataResult storedDataResult) {
        BidRequest mergedWithStoredRequest = this.mergeBidRequest(bidRequest, storedRequestId, storedDataResult);
        BidRequest mergedWithDefaultRequest = this.mergeDefaultRequest(mergedWithStoredRequest);
        return this.mergeImps(mergedWithDefaultRequest, impToStoredId, storedDataResult);
    }

    private BidRequest mergeDefaultRequest(BidRequest bidRequest) {
        return (BidRequest)this.jsonMerger.merge((Object)bidRequest, (Object)this.defaultBidRequest, BidRequest.class);
    }

    private BidRequest mergeBidRequest(BidRequest originalRequest, String storedRequestId, StoredDataResult storedDataResult) {
        String storedRequest = (String)storedDataResult.getStoredIdToRequest().get(storedRequestId);
        return StringUtils.isNotBlank((CharSequence)storedRequestId) ? (BidRequest)this.jsonMerger.merge((Object)originalRequest, storedRequest, storedRequestId, BidRequest.class) : originalRequest;
    }

    private BidRequest mergeImps(BidRequest bidRequest, Map<Imp, String> impToStoredId, StoredDataResult storedDataResult) {
        if (impToStoredId.isEmpty()) {
            return bidRequest;
        }
        ArrayList<Imp> mergedImps = new ArrayList<Imp>(bidRequest.getImp());
        for (int i = 0; i < mergedImps.size(); ++i) {
            Imp imp = (Imp)mergedImps.get(i);
            String storedRequestId = impToStoredId.get(imp);
            if (storedRequestId == null) continue;
            String storedImp = (String)storedDataResult.getStoredIdToImp().get(storedRequestId);
            Imp mergedImp = (Imp)this.jsonMerger.merge((Object)imp, storedImp, storedRequestId, Imp.class);
            mergedImps.set(i, mergedImp);
        }
        return bidRequest.toBuilder().imp(mergedImps).build();
    }

    private BidRequest generateBidRequestIdForApp(BidRequest bidRequest) {
        return bidRequest.getApp() != null ? this.generateBidRequestId(bidRequest) : bidRequest;
    }

    private BidRequest generateBidRequestId(BidRequest bidRequest) {
        return this.generateBidRequestId || Objects.equals(bidRequest.getId(), "{{UUID}}") ? bidRequest.toBuilder().id(this.idGenerator.generateId()).build() : bidRequest;
    }

    private static <K> Map<K, String> mapStoredRequestHolderToStoredRequestId(List<K> storedRequestHolders, Function<K, String> storedRequestIdExtractor) {
        if (CollectionUtils.isEmpty(storedRequestHolders)) {
            return Collections.emptyMap();
        }
        HashMap<K, String> holderToPreBidRequest = new HashMap<K, String>();
        for (K storedRequestHolder : storedRequestHolders) {
            String storedRequestId = storedRequestIdExtractor.apply(storedRequestHolder);
            if (storedRequestId == null) continue;
            holderToPreBidRequest.put(storedRequestHolder, storedRequestId);
        }
        return holderToPreBidRequest;
    }

    private static String getStoredRequestIdFromBidRequest(BidRequest bidRequest) {
        ExtRequestPrebid prebid = (ExtRequestPrebid)ObjectUtil.getIfNotNull((Object)bidRequest.getExt(), ExtRequest::getPrebid);
        ExtStoredRequest extStoredRequest = (ExtStoredRequest)ObjectUtil.getIfNotNull((Object)prebid, ExtRequestPrebid::getStoredrequest);
        if (extStoredRequest == null) {
            return null;
        }
        String storedRequestId = extStoredRequest.getId();
        if (storedRequestId == null) {
            throw new InvalidStoredRequestException("Id is not found in storedRequest");
        }
        return storedRequestId;
    }

    private String getStoredRequestIdFromImp(Imp imp) {
        ExtImp extImp;
        if (imp.getExt() == null) {
            return null;
        }
        try {
            extImp = (ExtImp)this.mapper.mapper().treeToValue((TreeNode)imp.getExt(), ExtImp.class);
        }
        catch (JsonProcessingException e) {
            throw new InvalidStoredImpException("Incorrect Imp extension format for Imp with id " + imp.getId() + ": " + e.getMessage());
        }
        ExtStoredRequest extStoredRequest = (ExtStoredRequest)ObjectUtil.getIfNotNull((Object)extImp.getPrebid(), ExtImpPrebid::getStoredrequest);
        if (extStoredRequest == null) {
            return null;
        }
        String storedRequestId = extStoredRequest.getId();
        if (storedRequestId == null) {
            throw new InvalidStoredImpException("Id is not found in storedRequest");
        }
        return storedRequestId;
    }

    private Timeout timeout(BidRequest bidRequest) {
        Long tmax = bidRequest.getTmax();
        return this.timeoutFactory.create(tmax != null && tmax > 0L ? tmax : this.defaultTimeout);
    }
}

