/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction;

import inet.ipaddr.AddressStringException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.IPAddressStringParameters;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.util.InetAddressUtils;
import org.prebid.server.auction.model.IpAddress;

/*
 * Exception performing whole class analysis ignored.
 */
public class IpAddressHelper {
    private static final Logger logger = LoggerFactory.getLogger(IpAddressHelper.class);
    private static final IPAddressStringParameters IP_ADDRESS_VALIDATION_OPTIONS = IPAddressString.DEFAULT_VALIDATION_OPTIONS.toBuilder().allowSingleSegment(false).allowEmpty(false).toParams();
    private final IPAddress ipv6AlwaysMaskAddress;
    private final IPAddress ipv6AnonLeftMaskAddress;
    private final List<IPAddress> ipv6LocalNetworkMaskAddresses;

    public IpAddressHelper(int ipv6AlwaysMaskBits, int ipv6AnonLeftMaskBits, List<String> ipv6LocalNetworks) {
        this.ipv6AlwaysMaskAddress = this.toAddress("::/" + IpAddressHelper.validateIpv6AlwaysMaskBits((int)ipv6AlwaysMaskBits)).getNetworkMask();
        this.ipv6AnonLeftMaskAddress = this.toAddress("::/" + IpAddressHelper.validateIpv6AnonLeftMaskBits((int)ipv6AnonLeftMaskBits)).getNetworkMask();
        this.ipv6LocalNetworkMaskAddresses = ipv6LocalNetworks.stream().map(arg_0 -> this.toAddress(arg_0)).toList();
    }

    public String anonymizeIpv6(String ip) {
        try {
            IPAddressString ipAddressString = new IPAddressString(ip);
            return ipAddressString.isIPv6() ? ipAddressString.toAddress().mask(this.ipv6AnonLeftMaskAddress).toCanonicalString() : null;
        }
        catch (AddressStringException e) {
            logger.debug((Object)"Exception occurred while anonymizing IPv6 address: {0}", new Object[]{e.getMessage()});
            return null;
        }
    }

    public IpAddress toIpAddress(String ip) {
        IpAddress.IP version;
        IPAddress ipAddress = IpAddressHelper.toIpAddressInternal((String)ip);
        if (ipAddress == null) {
            return null;
        }
        if (ipAddress.isIPv4()) {
            version = IpAddress.IP.v4;
        } else if (ipAddress.isIPv6()) {
            version = IpAddress.IP.v6;
        } else {
            return null;
        }
        if (this.isIpPublic(ipAddress)) {
            String sanitizedIp = version == IpAddress.IP.v6 ? this.maskIpv6(ipAddress) : ip;
            return IpAddress.of((String)sanitizedIp, (IpAddress.IP)version);
        }
        return null;
    }

    public String maskIpv4(String ip) {
        if (StringUtils.isBlank((CharSequence)ip) || !InetAddressUtils.isIPv4Address((String)ip)) {
            return ip;
        }
        String maskedIp = ip;
        int lastDotIndex = maskedIp.lastIndexOf(".");
        if (lastDotIndex == -1) {
            return ip;
        }
        maskedIp = maskedIp.substring(0, lastDotIndex);
        return maskedIp + ".0";
    }

    private String maskIpv6(IPAddress ipAddress) {
        return ipAddress.mask(this.ipv6AlwaysMaskAddress).toCanonicalString();
    }

    private static int validateIpv6AlwaysMaskBits(int ipv6AlwaysMaskBits) {
        if (ipv6AlwaysMaskBits < 1 || ipv6AlwaysMaskBits > 128) {
            throw new IllegalArgumentException("IPv6 always mask bits should be between 1 and 128 inclusive");
        }
        return ipv6AlwaysMaskBits;
    }

    private static int validateIpv6AnonLeftMaskBits(int ipv6AnonLeftMaskBits) {
        if (ipv6AnonLeftMaskBits < 1 || ipv6AnonLeftMaskBits > 128 || ipv6AnonLeftMaskBits > 32 && ipv6AnonLeftMaskBits < 56) {
            throw new IllegalArgumentException("IPv6 anonymize mask bits should be between 1 and 32 or 56 and 128 inclusive");
        }
        return ipv6AnonLeftMaskBits;
    }

    private IPAddress toAddress(String address) {
        try {
            return new IPAddressString(address).toAddress();
        }
        catch (AddressStringException e) {
            throw new IllegalArgumentException("Unable to process IPv6-related configuration", e);
        }
    }

    private static IPAddress toIpAddressInternal(String ip) {
        try {
            return new IPAddressString(ip, IP_ADDRESS_VALIDATION_OPTIONS).toAddress();
        }
        catch (AddressStringException e) {
            return null;
        }
    }

    private boolean isIpPublic(IPAddress ipAddress) {
        return ipAddress != null && !ipAddress.isLocal() && !ipAddress.isLoopback() && !ipAddress.isMulticast() && !ipAddress.isMax() && this.ipv6LocalNetworkMaskAddresses.stream().noneMatch(network -> network.contains(ipAddress));
    }
}

