/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction;

import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.auction.InterstitialProcessor;
import org.prebid.server.exception.InvalidRequestException;
import org.prebid.server.proto.openrtb.ext.request.ExtDevice;
import org.prebid.server.proto.openrtb.ext.request.ExtDeviceInt;
import org.prebid.server.proto.openrtb.ext.request.ExtDevicePrebid;

/*
 * Exception performing whole class analysis ignored.
 */
public class InterstitialProcessor {
    private static final int MAX_SIZES_COUNT = 10;

    public BidRequest process(BidRequest bidRequest) {
        if (bidRequest.getImp().stream().anyMatch(arg_0 -> this.isInterstitial(arg_0))) {
            bidRequest = this.processBidRequest(bidRequest);
        }
        return bidRequest;
    }

    private boolean isInterstitial(Imp imp) {
        return Objects.equals(imp.getInstl(), 1);
    }

    private BidRequest processBidRequest(BidRequest bidRequest) {
        Device device = bidRequest.getDevice();
        ExtDeviceInt extDeviceInt = this.getExtDeviceInt(device);
        if (extDeviceInt != null) {
            int minWidthPerc = extDeviceInt.getMinWidthPerc();
            int minHeightPerc = extDeviceInt.getMinHeightPerc();
            List<Imp> updatedImps = bidRequest.getImp().stream().map(imp -> this.processInterstitialImp(imp, device, minWidthPerc, minHeightPerc)).toList();
            bidRequest = bidRequest.toBuilder().imp(updatedImps).build();
        }
        return bidRequest;
    }

    private Imp processInterstitialImp(Imp imp, Device device, int minWidthPerc, int minHeightPerc) {
        Integer maxWidth;
        if (!this.isInterstitial(imp)) {
            return imp;
        }
        Banner banner = imp.getBanner();
        if (banner == null) {
            return imp;
        }
        List formats = banner.getFormat();
        Format firstFormat = CollectionUtils.isEmpty((Collection)formats) ? null : (Format)formats.get(0);
        Integer maxHeight = firstFormat != null ? firstFormat.getH() : null;
        Integer n = maxWidth = firstFormat != null ? firstFormat.getW() : null;
        if (maxHeight == null || maxWidth == null || maxHeight == 1 && maxWidth == 1) {
            maxHeight = device.getH();
            maxWidth = device.getW();
        }
        if (maxHeight == null || maxWidth == null) {
            throw new InvalidRequestException("Unable to read max interstitial size for Imp id=%s (No Device sizes and no Format objects)".formatted(imp.getId()));
        }
        double minHeight = (double)maxHeight.intValue() / 100.0 * (double)minHeightPerc;
        double minWidth = (double)maxWidth.intValue() / 100.0 * (double)minWidthPerc;
        List<Format> interstitialFormats = InterstitialSize.getNestedSizes((double)minWidth, (double)minHeight, (double)maxWidth.intValue(), (double)maxHeight.intValue(), (int)10).stream().map(interstitialSize -> Format.builder().w(interstitialSize.w).h(interstitialSize.h).build()).toList();
        if (CollectionUtils.isEmpty(interstitialFormats)) {
            return imp;
        }
        return imp.toBuilder().banner(banner.toBuilder().format(interstitialFormats).build()).build();
    }

    private ExtDeviceInt getExtDeviceInt(Device device) {
        ExtDevice extDevice = device != null ? device.getExt() : null;
        ExtDevicePrebid extDevicePrebid = extDevice != null ? extDevice.getPrebid() : null;
        return extDevicePrebid != null ? extDevicePrebid.getInterstitial() : null;
    }
}

