/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.activity.utils;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.prebid.server.activity.Activity;
import org.prebid.server.settings.model.Account;
import org.prebid.server.settings.model.AccountPrivacyConfig;
import org.prebid.server.settings.model.activity.AccountActivityConfiguration;
import org.prebid.server.settings.model.activity.rule.AccountActivityComponentRuleConfig;
import org.prebid.server.settings.model.activity.rule.AccountActivityGeoRuleConfig;
import org.prebid.server.settings.model.activity.rule.AccountActivityRuleConfig;

/*
 * Exception performing whole class analysis ignored.
 */
public class AccountActivitiesConfigurationUtils {
    private AccountActivitiesConfigurationUtils() {
    }

    public static boolean isInvalidActivitiesConfiguration(Account account) {
        return Optional.ofNullable(account).map(Account::getPrivacy).map(AccountPrivacyConfig::getActivities).stream().map(Map::values).flatMap(Collection::stream).anyMatch(AccountActivitiesConfigurationUtils::containsInvalidRule);
    }

    private static boolean containsInvalidRule(AccountActivityConfiguration accountActivityConfiguration) {
        return Optional.ofNullable(accountActivityConfiguration).map(AccountActivityConfiguration::getRules).stream().flatMap(Collection::stream).anyMatch(AccountActivitiesConfigurationUtils::isInvalidConditionRule);
    }

    private static boolean isInvalidConditionRule(AccountActivityRuleConfig rule) {
        if (rule instanceof AccountActivityComponentRuleConfig) {
            AccountActivityComponentRuleConfig conditionRule = (AccountActivityComponentRuleConfig)rule;
            AccountActivityComponentRuleConfig.Condition condition = conditionRule.getCondition();
            return condition != null && AccountActivitiesConfigurationUtils.isInvalidCondition((AccountActivityComponentRuleConfig.Condition)condition);
        }
        if (rule instanceof AccountActivityGeoRuleConfig) {
            AccountActivityGeoRuleConfig geoRule = (AccountActivityGeoRuleConfig)rule;
            AccountActivityGeoRuleConfig.Condition condition = geoRule.getCondition();
            return condition != null && AccountActivitiesConfigurationUtils.isInvalidCondition((AccountActivityGeoRuleConfig.Condition)condition);
        }
        return false;
    }

    private static boolean isInvalidCondition(AccountActivityComponentRuleConfig.Condition condition) {
        return AccountActivitiesConfigurationUtils.isEmptyNotNull((Collection)condition.getComponentTypes()) || AccountActivitiesConfigurationUtils.isEmptyNotNull((Collection)condition.getComponentNames());
    }

    private static boolean isInvalidCondition(AccountActivityGeoRuleConfig.Condition condition) {
        return AccountActivitiesConfigurationUtils.isEmptyNotNull((Collection)condition.getComponentTypes()) || AccountActivitiesConfigurationUtils.isEmptyNotNull((Collection)condition.getComponentNames());
    }

    private static <E> boolean isEmptyNotNull(Collection<E> collection) {
        return collection != null && collection.isEmpty();
    }

    public static Map<Activity, AccountActivityConfiguration> removeInvalidRules(Map<Activity, AccountActivityConfiguration> activitiesConfiguration) {
        return activitiesConfiguration.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> AccountActivitiesConfigurationUtils.removeInvalidRules((AccountActivityConfiguration)((AccountActivityConfiguration)entry.getValue()))));
    }

    private static AccountActivityConfiguration removeInvalidRules(AccountActivityConfiguration activityConfiguration) {
        if (!AccountActivitiesConfigurationUtils.containsInvalidRule((AccountActivityConfiguration)activityConfiguration)) {
            return activityConfiguration;
        }
        return AccountActivityConfiguration.of((Boolean)activityConfiguration.getAllow(), activityConfiguration.getRules().stream().map(rule -> !AccountActivitiesConfigurationUtils.isInvalidConditionRule((AccountActivityRuleConfig)rule) ? rule : null).filter(Objects::nonNull).toList());
    }
}

