/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.activity.infrastructure.privacy.usnat.reader;

import com.iab.gpp.encoder.GppModel;
import com.iab.gpp.encoder.section.UspCaV1;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.prebid.server.activity.infrastructure.privacy.uscustomlogic.USCustomLogicGppReader;
import org.prebid.server.activity.infrastructure.privacy.usnat.USNatGppReader;
import org.prebid.server.util.ObjectUtil;

public class USMappedCaliforniaGppReader
implements USNatGppReader,
USCustomLogicGppReader {
    private static final List<Integer> DEFAULT_SENSITIVE_DATA = Collections.nCopies(12, null);
    private static final List<Integer> CHILD_SENSITIVE_DATA = List.of(Integer.valueOf(1), Integer.valueOf(1));
    private final UspCaV1 consent;

    public USMappedCaliforniaGppReader(GppModel gppModel) {
        this.consent = gppModel != null ? gppModel.getUspCaV1Section() : null;
    }

    public Integer getVersion() {
        return (Integer)ObjectUtil.getIfNotNull((Object)this.consent, UspCaV1::getVersion);
    }

    public Boolean getGpc() {
        return (Boolean)ObjectUtil.getIfNotNull((Object)this.consent, UspCaV1::getGpc);
    }

    public Boolean getGpcSegmentType() {
        return null;
    }

    public Boolean getGpcSegmentIncluded() {
        return (Boolean)ObjectUtil.getIfNotNull((Object)this.consent, UspCaV1::getGpcSegmentIncluded);
    }

    public Integer getSaleOptOut() {
        return (Integer)ObjectUtil.getIfNotNull((Object)this.consent, UspCaV1::getSaleOptOut);
    }

    public Integer getSaleOptOutNotice() {
        return (Integer)ObjectUtil.getIfNotNull((Object)this.consent, UspCaV1::getSaleOptOutNotice);
    }

    public Integer getSharingNotice() {
        return null;
    }

    public Integer getSharingOptOut() {
        return (Integer)ObjectUtil.getIfNotNull((Object)this.consent, UspCaV1::getSharingOptOut);
    }

    public Integer getSharingOptOutNotice() {
        return (Integer)ObjectUtil.getIfNotNull((Object)this.consent, UspCaV1::getSharingOptOutNotice);
    }

    public Integer getTargetedAdvertisingOptOut() {
        return null;
    }

    public Integer getTargetedAdvertisingOptOutNotice() {
        return null;
    }

    public Integer getSensitiveDataLimitUseNotice() {
        return (Integer)ObjectUtil.getIfNotNull((Object)this.consent, UspCaV1::getSensitiveDataLimitUseNotice);
    }

    public List<Integer> getSensitiveDataProcessing() {
        List originalData = this.consent != null ? this.consent.getSensitiveDataProcessing() : DEFAULT_SENSITIVE_DATA;
        ArrayList<Integer> data = new ArrayList<Integer>(DEFAULT_SENSITIVE_DATA);
        data.set(0, (Integer)originalData.get(3));
        data.set(1, (Integer)originalData.get(3));
        data.set(2, (Integer)originalData.get(7));
        data.set(3, (Integer)originalData.get(8));
        data.set(5, (Integer)originalData.get(5));
        data.set(6, (Integer)originalData.get(6));
        data.set(7, (Integer)originalData.get(2));
        data.set(8, (Integer)originalData.get(0));
        data.set(9, (Integer)originalData.get(1));
        data.set(11, (Integer)originalData.get(4));
        return Collections.unmodifiableList(data);
    }

    public Integer getSensitiveDataProcessingOptOutNotice() {
        return null;
    }

    public List<Integer> getKnownChildSensitiveDataConsents() {
        List data = this.consent != null ? this.consent.getKnownChildSensitiveDataConsents() : null;
        return data != null && (Integer)data.get(0) == 0 && (Integer)data.get(1) == 0 ? data : CHILD_SENSITIVE_DATA;
    }

    public Integer getPersonalDataConsents() {
        return (Integer)ObjectUtil.getIfNotNull((Object)this.consent, UspCaV1::getPersonalDataConsents);
    }

    public Integer getMspaCoveredTransaction() {
        return (Integer)ObjectUtil.getIfNotNull((Object)this.consent, UspCaV1::getMspaCoveredTransaction);
    }

    public Integer getMspaServiceProviderMode() {
        return (Integer)ObjectUtil.getIfNotNull((Object)this.consent, UspCaV1::getMspaServiceProviderMode);
    }

    public Integer getMspaOptOutOptionMode() {
        return (Integer)ObjectUtil.getIfNotNull((Object)this.consent, UspCaV1::getMspaOptOutOptionMode);
    }
}

