/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.activity.infrastructure.privacy.usnat.inner;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Objects;
import org.prebid.server.activity.infrastructure.debug.Loggable;
import org.prebid.server.activity.infrastructure.payload.ActivityInvocationPayload;
import org.prebid.server.activity.infrastructure.privacy.PrivacyModule;
import org.prebid.server.activity.infrastructure.privacy.usnat.USNatGppReader;
import org.prebid.server.activity.infrastructure.privacy.usnat.debug.USNatModuleLogEntry;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.Gpc;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.KnownChildSensitiveDataConsent;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.MspaServiceProviderMode;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.PersonalDataConsents;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.SensitiveDataLimitUseNotice;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.SensitiveDataProcessing;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.SensitiveDataProcessingOptOutNotice;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.USNatField;
import org.prebid.server.activity.infrastructure.rule.Rule;

/*
 * Exception performing whole class analysis ignored.
 */
public class USNatTransmitGeo
implements PrivacyModule,
Loggable {
    private final USNatGppReader gppReader;
    private final Rule.Result result;

    public USNatTransmitGeo(USNatGppReader gppReader) {
        this.gppReader = gppReader;
        this.result = USNatTransmitGeo.disallow((USNatGppReader)gppReader) ? Rule.Result.DISALLOW : Rule.Result.ALLOW;
    }

    public Rule.Result proceed(ActivityInvocationPayload activityInvocationPayload) {
        return this.result;
    }

    public static boolean disallow(USNatGppReader gppReader) {
        return USNatTransmitGeo.equals((Object)gppReader.getMspaServiceProviderMode(), (USNatField)MspaServiceProviderMode.YES) || USNatTransmitGeo.equals((Object)gppReader.getGpc(), (USNatField)Gpc.TRUE) || USNatTransmitGeo.checkSensitiveData((USNatGppReader)gppReader) || USNatTransmitGeo.checkKnownChildSensitiveDataConsents((USNatGppReader)gppReader) || USNatTransmitGeo.equals((Object)gppReader.getPersonalDataConsents(), (USNatField)PersonalDataConsents.CONSENT);
    }

    private static boolean checkSensitiveData(USNatGppReader gppReader) {
        Integer sensitiveDataProcessingOptOutNotice = gppReader.getSensitiveDataProcessingOptOutNotice();
        Integer sensitiveDataLimitUseNotice = gppReader.getSensitiveDataLimitUseNotice();
        List sensitiveDataProcessing = gppReader.getSensitiveDataProcessing();
        return USNatTransmitGeo.equals((Object)sensitiveDataProcessingOptOutNotice, (USNatField)SensitiveDataProcessingOptOutNotice.NO) || USNatTransmitGeo.equals((Object)sensitiveDataLimitUseNotice, (USNatField)SensitiveDataLimitUseNotice.NO) || (USNatTransmitGeo.equals((Object)sensitiveDataProcessingOptOutNotice, (USNatField)SensitiveDataProcessingOptOutNotice.NOT_APPLICABLE) || USNatTransmitGeo.equals((Object)sensitiveDataLimitUseNotice, (USNatField)SensitiveDataLimitUseNotice.NOT_APPLICABLE)) && USNatTransmitGeo.equalsAtIndex((USNatField)SensitiveDataProcessing.CONSENT, (List)sensitiveDataProcessing, (int)7) || USNatTransmitGeo.equalsAtIndex((USNatField)SensitiveDataProcessing.NO_CONSENT, (List)sensitiveDataProcessing, (int)7);
    }

    private static boolean checkKnownChildSensitiveDataConsents(USNatGppReader gppReader) {
        List knownChildSensitiveDataConsents = gppReader.getKnownChildSensitiveDataConsents();
        return USNatTransmitGeo.equalsAtIndex((USNatField)KnownChildSensitiveDataConsent.NO_CONSENT, (List)knownChildSensitiveDataConsents, (int)0) || USNatTransmitGeo.equalsAtIndex((USNatField)KnownChildSensitiveDataConsent.NO_CONSENT, (List)knownChildSensitiveDataConsents, (int)1) || USNatTransmitGeo.equalsAtIndex((USNatField)KnownChildSensitiveDataConsent.CONSENT, (List)knownChildSensitiveDataConsents, (int)1);
    }

    private static <T> boolean equalsAtIndex(USNatField<T> expectedValue, List<T> list, int index) {
        return list != null && list.size() > index && USNatTransmitGeo.equals(list.get(index), expectedValue);
    }

    private static <T> boolean equals(T providedValue, USNatField<T> expectedValue) {
        return Objects.equals(providedValue, expectedValue.value());
    }

    public JsonNode asLogEntry(ObjectMapper mapper) {
        return USNatModuleLogEntry.from((PrivacyModule)this, (USNatGppReader)this.gppReader, (Rule.Result)this.result);
    }
}

