/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.activity.infrastructure;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.prebid.server.activity.Activity;
import org.prebid.server.activity.infrastructure.ActivityController;
import org.prebid.server.activity.infrastructure.debug.ActivityInfrastructureDebug;
import org.prebid.server.activity.infrastructure.payload.ActivityInvocationPayload;
import org.prebid.server.proto.openrtb.ext.response.ExtTraceActivityInfrastructure;

/*
 * Exception performing whole class analysis ignored.
 */
public class ActivityInfrastructure {
    public static final boolean ALLOW_ACTIVITY_BY_DEFAULT = true;
    private final Map<Activity, ActivityController> activitiesControllers;
    private final ActivityInfrastructureDebug debug;

    public ActivityInfrastructure(Map<Activity, ActivityController> activitiesControllers, ActivityInfrastructureDebug debug) {
        ActivityInfrastructure.validate(activitiesControllers);
        this.activitiesControllers = activitiesControllers;
        this.debug = Objects.requireNonNull(debug);
    }

    private static void validate(Map<Activity, ActivityController> activitiesControllers) {
        if (activitiesControllers == null || activitiesControllers.size() != Activity.values().length) {
            throw new AssertionError((Object)"Activities controllers must include all possible activities.");
        }
    }

    public boolean isAllowed(Activity activity, ActivityInvocationPayload activityInvocationPayload) {
        this.debug.emitActivityInvocation(activity, activityInvocationPayload);
        boolean result = ((ActivityController)this.activitiesControllers.get(activity)).isAllowed(activityInvocationPayload);
        this.debug.emitActivityInvocationResult(activity, activityInvocationPayload, result);
        return result;
    }

    public List<ExtTraceActivityInfrastructure> debugTrace() {
        return this.debug.trace();
    }
}

