/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.vertx;

import io.vertx.circuitbreaker.CircuitBreakerOptions;
import io.vertx.circuitbreaker.CircuitBreakerState;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.time.Clock;
import java.util.Objects;

public class CircuitBreaker {
    private static final Logger logger = LoggerFactory.getLogger(CircuitBreaker.class);
    private final io.vertx.circuitbreaker.CircuitBreaker breaker;
    private final Vertx vertx;
    private final long openingIntervalMs;
    private final Clock clock;
    private volatile long lastFailureTime;

    public CircuitBreaker(String name, Vertx vertx, int openingThreshold, long openingIntervalMs, long closingIntervalMs, Clock clock) {
        this.breaker = io.vertx.circuitbreaker.CircuitBreaker.create((String)Objects.requireNonNull(name), (Vertx)Objects.requireNonNull(vertx), (CircuitBreakerOptions)new CircuitBreakerOptions().setNotificationPeriod(0L).setMaxFailures(openingThreshold).setResetTimeout(closingIntervalMs));
        this.vertx = vertx;
        this.openingIntervalMs = openingIntervalMs;
        this.clock = Objects.requireNonNull(clock);
    }

    public <T> Future<T> execute(Handler<Promise<T>> command) {
        return this.breaker.execute(promise -> this.execute(command, (Promise)promise));
    }

    private <T> void execute(Handler<Promise<T>> command, Promise<T> promise) {
        Promise passedPromise = Promise.promise();
        command.handle((Object)passedPromise);
        passedPromise.future().compose(response -> CircuitBreaker.succeedBreaker(response, promise)).recover(exception -> this.failBreaker((Throwable)exception, promise));
    }

    private static <T> Future<T> succeedBreaker(T result, Promise<T> promise) {
        promise.complete(result);
        return promise.future();
    }

    private <T> Future<T> failBreaker(Throwable exception, Promise<T> promise) {
        Promise ensureStatePromise = Promise.promise();
        this.vertx.executeBlocking(this::ensureState, false, (Handler)ensureStatePromise);
        return ensureStatePromise.future().recover(throwable -> {
            logger.warn((Object)"Resetting circuit breaker state failed", throwable);
            promise.fail(throwable);
            return promise.future();
        }).compose(ignored -> {
            promise.fail(exception);
            return promise.future();
        });
    }

    private <T> void ensureState(Promise<T> executeBlockingPromise) {
        long currentTime = this.clock.millis();
        if (this.breaker.state() == CircuitBreakerState.CLOSED && this.lastFailureTime > 0L && currentTime - this.lastFailureTime > this.openingIntervalMs) {
            this.breaker.reset();
        }
        this.lastFailureTime = currentTime;
        executeBlockingPromise.complete();
    }

    public CircuitBreaker openHandler(Handler<Void> handler) {
        this.breaker.openHandler(handler);
        return this;
    }

    public CircuitBreaker halfOpenHandler(Handler<Void> handler) {
        this.breaker.halfOpenHandler(handler);
        return this;
    }

    public CircuitBreaker closeHandler(Handler<Void> handler) {
        this.breaker.closeHandler(handler);
        return this;
    }

    public boolean isOpen() {
        return switch (this.breaker.state()) {
            default -> throw new IncompatibleClassChangeError();
            case CircuitBreakerState.OPEN, CircuitBreakerState.HALF_OPEN -> true;
            case CircuitBreakerState.CLOSED -> false;
        };
    }
}

