/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.validation.model;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;

public final class ValidationResult {
    private final List<String> warnings;
    private final List<String> errors;

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public static ValidationResult error(String errorMessageFormat) {
        return ValidationResult.error(Collections.emptyList(), errorMessageFormat);
    }

    public static ValidationResult error(List<String> warnings, String errorMessageFormat) {
        return new ValidationResult(warnings, Collections.singletonList(errorMessageFormat));
    }

    public static ValidationResult success() {
        return ValidationResult.success(Collections.emptyList());
    }

    public static ValidationResult success(List<String> warnings) {
        return new ValidationResult(warnings, Collections.emptyList());
    }

    public static ValidationResult warning(List<String> warnings) {
        return new ValidationResult(warnings, Collections.emptyList());
    }

    @ConstructorProperties(value={"warnings", "errors"})
    public ValidationResult(List<String> warnings, List<String> errors) {
        this.warnings = warnings;
        this.errors = errors;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidationResult)) {
            return false;
        }
        ValidationResult other = (ValidationResult)o;
        List<String> this$warnings = this.getWarnings();
        List<String> other$warnings = other.getWarnings();
        if (this$warnings == null ? other$warnings != null : !((Object)this$warnings).equals(other$warnings)) {
            return false;
        }
        List<String> this$errors = this.getErrors();
        List<String> other$errors = other.getErrors();
        return !(this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $warnings = this.getWarnings();
        result = result * 59 + ($warnings == null ? 43 : ((Object)$warnings).hashCode());
        List<String> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        return result;
    }

    public String toString() {
        return "ValidationResult(warnings=" + this.getWarnings() + ", errors=" + this.getErrors() + ")";
    }
}

