/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.IOUtils;

public class ResourceUtil {
    private ResourceUtil() {
    }

    public static String readFromClasspath(String path) throws IOException {
        InputStream resourceAsStream = ResourceUtil.class.getClassLoader().getResourceAsStream(path);
        if (resourceAsStream == null) {
            throw new IllegalArgumentException("Could not find file at path: " + path);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resourceAsStream, StandardCharsets.UTF_8));){
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }

    public static byte[] readByteArrayFromClassPath(String path) throws IOException {
        InputStream resourceAsStream = ResourceUtil.class.getClassLoader().getResourceAsStream(path);
        if (resourceAsStream == null) {
            throw new IllegalArgumentException("Could not find file at path: " + path);
        }
        return IOUtils.toByteArray((InputStream)resourceAsStream);
    }
}

