/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config.metrics;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.izettle.metrics.influxdb.InfluxDbHttpSender;
import com.izettle.metrics.influxdb.InfluxDbReporter;
import com.izettle.metrics.influxdb.InfluxDbSender;
import io.vertx.core.Closeable;
import io.vertx.core.Vertx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ObjectUtils;
import org.prebid.server.metric.AccountMetricsVerbosityResolver;
import org.prebid.server.metric.CounterType;
import org.prebid.server.metric.Metrics;
import org.prebid.server.metric.model.AccountMetricsVerbosityLevel;
import org.prebid.server.spring.env.YamlPropertySourceFactory;
import org.prebid.server.vertx.CloseableAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Configuration
@PropertySource(value={"classpath:/metrics-config/metrics.yaml"}, factory=YamlPropertySourceFactory.class)
public class MetricsConfiguration {
    public static final String METRIC_REGISTRY_NAME = "metric-registry";
    @Autowired(required=false)
    private List<ScheduledReporter> reporters = Collections.emptyList();
    @Autowired
    private Vertx vertx;

    @Bean
    @ConditionalOnProperty(prefix="metrics.graphite", name={"enabled"}, havingValue="true")
    ScheduledReporter graphiteReporter(GraphiteProperties graphiteProperties, MetricRegistry metricRegistry) {
        Graphite graphite = new Graphite(graphiteProperties.getHost(), graphiteProperties.getPort().intValue());
        GraphiteReporter reporter = GraphiteReporter.forRegistry((MetricRegistry)metricRegistry).prefixedWith(graphiteProperties.getPrefix()).build(graphite);
        reporter.start((long)graphiteProperties.getInterval().intValue(), TimeUnit.SECONDS);
        return reporter;
    }

    @Bean
    @ConditionalOnProperty(prefix="metrics.influxdb", name={"enabled"}, havingValue="true")
    ScheduledReporter influxdbReporter(InfluxdbProperties influxdbProperties, MetricRegistry metricRegistry) throws Exception {
        InfluxDbHttpSender influxDbSender = new InfluxDbHttpSender(influxdbProperties.getProtocol(), influxdbProperties.getHost(), influxdbProperties.getPort().intValue(), influxdbProperties.getDatabase(), influxdbProperties.getAuth(), TimeUnit.SECONDS, influxdbProperties.getConnectTimeout().intValue(), influxdbProperties.getReadTimeout().intValue(), influxdbProperties.getPrefix());
        Map tags = (Map)ObjectUtils.defaultIfNull(influxdbProperties.getTags(), Collections.emptyMap());
        InfluxDbReporter reporter = InfluxDbReporter.forRegistry((MetricRegistry)metricRegistry).withTags(tags).build((InfluxDbSender)influxDbSender);
        reporter.start((long)influxdbProperties.getInterval().intValue(), TimeUnit.SECONDS);
        return reporter;
    }

    @Bean
    @ConditionalOnProperty(prefix="metrics.console", name={"enabled"}, havingValue="true")
    ScheduledReporter consoleReporter(ConsoleProperties consoleProperties, MetricRegistry metricRegistry) {
        ConsoleReporter reporter = ConsoleReporter.forRegistry((MetricRegistry)metricRegistry).build();
        reporter.start((long)consoleProperties.getInterval().intValue(), TimeUnit.SECONDS);
        return reporter;
    }

    @Bean
    Metrics metrics(@Value(value="${metrics.metricType}") CounterType counterType, MetricRegistry metricRegistry, AccountMetricsVerbosityResolver accountMetricsVerbosityResolver) {
        return new Metrics(metricRegistry, counterType, accountMetricsVerbosityResolver);
    }

    @Bean
    MetricRegistry metricRegistry(@Value(value="${metrics.jmx.enabled}") boolean jmxEnabled) {
        boolean alreadyExists = SharedMetricRegistries.names().contains(METRIC_REGISTRY_NAME);
        MetricRegistry metricRegistry = SharedMetricRegistries.getOrCreate((String)METRIC_REGISTRY_NAME);
        if (!alreadyExists && jmxEnabled) {
            metricRegistry.register("jvm.gc", (Metric)new GarbageCollectorMetricSet());
            metricRegistry.register("jvm.memory", (Metric)new MemoryUsageGaugeSet());
        }
        return metricRegistry;
    }

    @Bean
    AccountMetricsVerbosityResolver accountMetricsVerbosity(AccountsProperties accountsProperties) {
        return new AccountMetricsVerbosityResolver(accountsProperties.getDefaultVerbosity(), accountsProperties.getBasicVerbosity(), accountsProperties.getDetailedVerbosity());
    }

    @PostConstruct
    void registerReporterCloseHooks() {
        this.reporters.stream().map(CloseableAdapter::new).forEach(closeable -> this.vertx.getOrCreateContext().addCloseHook((Closeable)closeable));
    }

    @Component
    @ConfigurationProperties(prefix="metrics.graphite")
    @ConditionalOnProperty(prefix="metrics.graphite", name={"enabled"}, havingValue="true")
    @Validated
    private static class GraphiteProperties {
        @NotBlank
        private String prefix;
        @NotBlank
        private String host;
        @NotNull
        private Integer port;
        @NotNull
        @Min(value=1L)
        private @NotNull @Min(value=1L) Integer interval;

        public String getPrefix() {
            return this.prefix;
        }

        public String getHost() {
            return this.host;
        }

        @NotNull
        public Integer getPort() {
            return this.port;
        }

        @NotNull
        public Integer getInterval() {
            return this.interval;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(@NotNull Integer port) {
            this.port = port;
        }

        public void setInterval(@NotNull Integer interval) {
            this.interval = interval;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GraphiteProperties)) {
                return false;
            }
            GraphiteProperties other = (GraphiteProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$port = this.getPort();
            Integer other$port = other.getPort();
            if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
                return false;
            }
            Integer this$interval = this.getInterval();
            Integer other$interval = other.getInterval();
            if (this$interval == null ? other$interval != null : !((Object)this$interval).equals(other$interval)) {
                return false;
            }
            String this$prefix = this.getPrefix();
            String other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            return !(this$host == null ? other$host != null : !this$host.equals(other$host));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GraphiteProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $port = this.getPort();
            result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
            Integer $interval = this.getInterval();
            result = result * 59 + ($interval == null ? 43 : ((Object)$interval).hashCode());
            String $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            return result;
        }

        public String toString() {
            return "MetricsConfiguration.GraphiteProperties(prefix=" + this.getPrefix() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", interval=" + this.getInterval() + ")";
        }
    }

    @Component
    @ConfigurationProperties(prefix="metrics.influxdb")
    @ConditionalOnProperty(prefix="metrics.influxdb", name={"enabled"}, havingValue="true")
    @Validated
    private static class InfluxdbProperties {
        @NotBlank
        private String prefix;
        @NotBlank
        private String protocol;
        @NotBlank
        private String host;
        @NotNull
        private Integer port;
        @NotBlank
        private String database;
        @NotBlank
        private String auth;
        @NotNull
        @Min(value=1L)
        private @NotNull @Min(value=1L) Integer connectTimeout;
        @NotNull
        @Min(value=1L)
        private @NotNull @Min(value=1L) Integer readTimeout;
        @NotNull
        @Min(value=1L)
        private @NotNull @Min(value=1L) Integer interval;
        private Map<String, String> tags;

        public String getPrefix() {
            return this.prefix;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getHost() {
            return this.host;
        }

        @NotNull
        public Integer getPort() {
            return this.port;
        }

        public String getDatabase() {
            return this.database;
        }

        public String getAuth() {
            return this.auth;
        }

        @NotNull
        public Integer getConnectTimeout() {
            return this.connectTimeout;
        }

        @NotNull
        public Integer getReadTimeout() {
            return this.readTimeout;
        }

        @NotNull
        public Integer getInterval() {
            return this.interval;
        }

        public Map<String, String> getTags() {
            return this.tags;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(@NotNull Integer port) {
            this.port = port;
        }

        public void setDatabase(String database) {
            this.database = database;
        }

        public void setAuth(String auth) {
            this.auth = auth;
        }

        public void setConnectTimeout(@NotNull Integer connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public void setReadTimeout(@NotNull Integer readTimeout) {
            this.readTimeout = readTimeout;
        }

        public void setInterval(@NotNull Integer interval) {
            this.interval = interval;
        }

        public void setTags(Map<String, String> tags) {
            this.tags = tags;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InfluxdbProperties)) {
                return false;
            }
            InfluxdbProperties other = (InfluxdbProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$port = this.getPort();
            Integer other$port = other.getPort();
            if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
                return false;
            }
            Integer this$connectTimeout = this.getConnectTimeout();
            Integer other$connectTimeout = other.getConnectTimeout();
            if (this$connectTimeout == null ? other$connectTimeout != null : !((Object)this$connectTimeout).equals(other$connectTimeout)) {
                return false;
            }
            Integer this$readTimeout = this.getReadTimeout();
            Integer other$readTimeout = other.getReadTimeout();
            if (this$readTimeout == null ? other$readTimeout != null : !((Object)this$readTimeout).equals(other$readTimeout)) {
                return false;
            }
            Integer this$interval = this.getInterval();
            Integer other$interval = other.getInterval();
            if (this$interval == null ? other$interval != null : !((Object)this$interval).equals(other$interval)) {
                return false;
            }
            String this$prefix = this.getPrefix();
            String other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            String this$protocol = this.getProtocol();
            String other$protocol = other.getProtocol();
            if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            String this$database = this.getDatabase();
            String other$database = other.getDatabase();
            if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
                return false;
            }
            String this$auth = this.getAuth();
            String other$auth = other.getAuth();
            if (this$auth == null ? other$auth != null : !this$auth.equals(other$auth)) {
                return false;
            }
            Map<String, String> this$tags = this.getTags();
            Map<String, String> other$tags = other.getTags();
            return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InfluxdbProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $port = this.getPort();
            result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
            Integer $connectTimeout = this.getConnectTimeout();
            result = result * 59 + ($connectTimeout == null ? 43 : ((Object)$connectTimeout).hashCode());
            Integer $readTimeout = this.getReadTimeout();
            result = result * 59 + ($readTimeout == null ? 43 : ((Object)$readTimeout).hashCode());
            Integer $interval = this.getInterval();
            result = result * 59 + ($interval == null ? 43 : ((Object)$interval).hashCode());
            String $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            String $protocol = this.getProtocol();
            result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            String $database = this.getDatabase();
            result = result * 59 + ($database == null ? 43 : $database.hashCode());
            String $auth = this.getAuth();
            result = result * 59 + ($auth == null ? 43 : $auth.hashCode());
            Map<String, String> $tags = this.getTags();
            result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
            return result;
        }

        public String toString() {
            return "MetricsConfiguration.InfluxdbProperties(prefix=" + this.getPrefix() + ", protocol=" + this.getProtocol() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", database=" + this.getDatabase() + ", auth=" + this.getAuth() + ", connectTimeout=" + this.getConnectTimeout() + ", readTimeout=" + this.getReadTimeout() + ", interval=" + this.getInterval() + ", tags=" + this.getTags() + ")";
        }
    }

    @Component
    @ConfigurationProperties(prefix="metrics.console")
    @ConditionalOnProperty(prefix="metrics.console", name={"enabled"}, havingValue="true")
    @Validated
    private static class ConsoleProperties {
        @NotNull
        @Min(value=1L)
        private @NotNull @Min(value=1L) Integer interval;

        @NotNull
        public Integer getInterval() {
            return this.interval;
        }

        public void setInterval(@NotNull Integer interval) {
            this.interval = interval;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConsoleProperties)) {
                return false;
            }
            ConsoleProperties other = (ConsoleProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$interval = this.getInterval();
            Integer other$interval = other.getInterval();
            return !(this$interval == null ? other$interval != null : !((Object)this$interval).equals(other$interval));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConsoleProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $interval = this.getInterval();
            result = result * 59 + ($interval == null ? 43 : ((Object)$interval).hashCode());
            return result;
        }

        public String toString() {
            return "MetricsConfiguration.ConsoleProperties(interval=" + this.getInterval() + ")";
        }
    }

    @Component
    @ConfigurationProperties(prefix="metrics.accounts")
    @Validated
    private static class AccountsProperties {
        @NotNull
        private AccountMetricsVerbosityLevel defaultVerbosity;
        private List<String> basicVerbosity = new ArrayList<String>();
        private List<String> detailedVerbosity = new ArrayList<String>();

        @NotNull
        public AccountMetricsVerbosityLevel getDefaultVerbosity() {
            return this.defaultVerbosity;
        }

        public List<String> getBasicVerbosity() {
            return this.basicVerbosity;
        }

        public List<String> getDetailedVerbosity() {
            return this.detailedVerbosity;
        }

        public void setDefaultVerbosity(@NotNull AccountMetricsVerbosityLevel defaultVerbosity) {
            this.defaultVerbosity = defaultVerbosity;
        }

        public void setBasicVerbosity(List<String> basicVerbosity) {
            this.basicVerbosity = basicVerbosity;
        }

        public void setDetailedVerbosity(List<String> detailedVerbosity) {
            this.detailedVerbosity = detailedVerbosity;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AccountsProperties)) {
                return false;
            }
            AccountsProperties other = (AccountsProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AccountMetricsVerbosityLevel this$defaultVerbosity = this.getDefaultVerbosity();
            AccountMetricsVerbosityLevel other$defaultVerbosity = other.getDefaultVerbosity();
            if (this$defaultVerbosity == null ? other$defaultVerbosity != null : !((Object)((Object)this$defaultVerbosity)).equals((Object)other$defaultVerbosity)) {
                return false;
            }
            List<String> this$basicVerbosity = this.getBasicVerbosity();
            List<String> other$basicVerbosity = other.getBasicVerbosity();
            if (this$basicVerbosity == null ? other$basicVerbosity != null : !((Object)this$basicVerbosity).equals(other$basicVerbosity)) {
                return false;
            }
            List<String> this$detailedVerbosity = this.getDetailedVerbosity();
            List<String> other$detailedVerbosity = other.getDetailedVerbosity();
            return !(this$detailedVerbosity == null ? other$detailedVerbosity != null : !((Object)this$detailedVerbosity).equals(other$detailedVerbosity));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AccountsProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AccountMetricsVerbosityLevel $defaultVerbosity = this.getDefaultVerbosity();
            result = result * 59 + ($defaultVerbosity == null ? 43 : ((Object)((Object)$defaultVerbosity)).hashCode());
            List<String> $basicVerbosity = this.getBasicVerbosity();
            result = result * 59 + ($basicVerbosity == null ? 43 : ((Object)$basicVerbosity).hashCode());
            List<String> $detailedVerbosity = this.getDetailedVerbosity();
            result = result * 59 + ($detailedVerbosity == null ? 43 : ((Object)$detailedVerbosity).hashCode());
            return result;
        }

        public String toString() {
            return "MetricsConfiguration.AccountsProperties(defaultVerbosity=" + this.getDefaultVerbosity() + ", basicVerbosity=" + this.getBasicVerbosity() + ", detailedVerbosity=" + this.getDetailedVerbosity() + ")";
        }
    }
}

