/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config.database.model;

import java.beans.ConstructorProperties;

public final class DatabaseAddress {
    private final String host;
    private final int port;
    private final String databaseName;

    @ConstructorProperties(value={"host", "port", "databaseName"})
    private DatabaseAddress(String host, int port, String databaseName) {
        this.host = host;
        this.port = port;
        this.databaseName = databaseName;
    }

    public static DatabaseAddress of(String host, int port, String databaseName) {
        return new DatabaseAddress(host, port, databaseName);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatabaseAddress)) {
            return false;
        }
        DatabaseAddress other = (DatabaseAddress)o;
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$databaseName = this.getDatabaseName();
        String other$databaseName = other.getDatabaseName();
        return !(this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $databaseName = this.getDatabaseName();
        result = result * 59 + ($databaseName == null ? 43 : $databaseName.hashCode());
        return result;
    }

    public String toString() {
        return "DatabaseAddress(host=" + this.getHost() + ", port=" + this.getPort() + ", databaseName=" + this.getDatabaseName() + ")";
    }
}

